1000 ! * LIB     .BAC * 
1010 ! +------------------------------+ 
1020 ! !          LIB.BAC             ! 
1030 ! !     Biblioteksprogram        ! 
1040 ! ! f|r alla diskenheter & RAM:  ! 
1050 ! !     (C)  Luxor Datorer AB /  ! 
1060 ! ! Tillh|r Systemdisk, UFD-DOS  ! 
1070 ! +------------------------------+ 
1080 ! *
1090 ! * Because of the size of this programme, it should be squeezed when
1100 ! * running, to perform well.
1110 ! * 
1120 ! * Ver date / VerRev / Sign / Note 
1130 ! * 83-03-17 /  6.00  / LDAB / Orig. LIB Ver 5.0 f|r RAM/skiva
1140 ! * 83-06-23 /  6.01  / LDAB / CE or CR clears error message
1150 ! 
1160 EXTEND : INTEGER 
1170 ! ***********************************************************************
1180 ! *                                                                     *
1190 ! *                  M A I N   P R O G R A M                            *
1200 ! *                                                                     *
1210 ! ***********************************************************************
1220 ! *
1230 Q7=FNInit
1240 Q7=FNSetlin(T)
1250 ! *
1260 IF Scan THEN GOTO 1320
1270 IF FNEnhet THEN Q7=FNFel('Enheten ej klar',T) : GOTO 1450
1280 IF Fil THEN IF FNPrlist THEN Q7=FNFel('Skrivaren ej READY.',T)
1290 IF Fil=F THEN Q7=FNScroll
1300 GOTO 1450
1310 ! * 
1320 ! * Scan sequence
1330 ! *
1340 Devnr=0 ! First device 
1350 ! * 
1360 WHILE Devnr>=0 AND Devnr<LEN(Devs$)/3
1370   Dev$=MID$(Devs$,3*Devnr+1,3)+':'
1380   IF FNDesc THEN GOTO 1420
1390   IF FNEnhet THEN GOTO 1420
1400   IF Fil THEN IF FNPrlist THEN Q7=FNFel('Skrivaren ej READY.',T)
1410   IF Fil=F THEN IF FNScroll THEN GOTO 1450
1420   ! *
1430   IF Forw THEN Devnr=Devnr+1 ELSE Devnr=Devnr-1
1440 WEND 
1450 ! * 
1460 Q7=FNSetlin(F)
1470 IF FNMore THEN GOTO 1220
1480 ; CUR(22,0) '        '
1490 ; CUR(23,0) SPACE$(Wid);
1500 ; CUR(22,0);
1510 END 
1520 ! * 
1530 ! ***********************************************************************
1540 ! *                                                                     *
1550 ! *          F U N C T I O N   D E C L A R A T I O N   P A R T          *
1560 ! *                                                                     *
1570 ! ***********************************************************************
1580 ! *
1590 ! * Initialization
1600 ! *
1610 DEF FNInit
1620   F=0 : T=-1 ! False/True 
1630   DIM Q7$=160
1640   ! * 
1650   Table=PEEK2(24683) ! Device descriptor table
1660   DIM Rtab$=0,Qtab$=32
1670   POKE VAROOT(Rtab$),32,0,Table,SWAP%(Table),32,0 ! Dev desc table
1680   ! * 
1690   DIM Dev$=4 ! Current device name
1700   Devs$='UFDDR0DR1DR2DR3HD0HD1HD2HD3SF0SF1SF2SF3MF0MF1MF2MF3MO0MO1MO2MO3RAM'
1710   Forw=T ! Scan devices forward
1720   DIM Antal(15) ! Directory sector used flag
1730   DIM Summa$=256*20 ! Sorted files area
1740   DIM Volname$=122
1750   DIM Volshort$=12 ! Short volume name
1760   ! *
1770   Dosbuf=256*PEEK(-749)
1780   DIM Dosbuf$=0
1790   POKE VAROOT(Dosbuf$),0,1,Dosbuf,SWAP%(Dosbuf),0,1 ! Disk buffer area
1800   ! *
1810   Wid=PEEK(65364)
1820   IF Wid<=40 THEN Widcomp1=9 : Widcomp2=0 ELSE Widcomp1=23 : Widcomp2=15
1830   Huvud$=CHR$(12)+' ABC800 LIB  Ver. 6.01'+CUR(0,Wid)+''+STRING$(Wid,ASCII('='))
1840   DIM Prhead$=160
1850   Prhead$='* ABC800 LIB * Ver. 6.01 *                                                    *'+CHR$(13,10)
1860   Prhead$=Prhead$+STRING$(79,ASCII('='))
1870   Lhead1$='Filnamn:     Storlek: Skriv-Raderskydd:'
1880   Lhead2$='------------ -------- ----- -----------'
1890   IF Wid<80 THEN Mxlin=14 ELSE Mxlin=15 ! Max filename on display
1900   ! * 
1910   ! * Machine code areas
1920   ! *
1930   DIM Bitmap$=33
1940   Bitmap$=CHR$(17,0,245,33,0,0,26,254,255,40,15,6,8,203,39,56,6,197,1,1,0,9,193,5,32,243,19,62,161,187,32,230,201)
1950   DIM Stor$=39
1960   Stor$=CHR$(6,112,205,15,96,33,0,0,58,21,253,192,6,118,221,33,4,252,85,221,126,0,60,200,221,126,1,230,31,60,95,25,221,35,221,35,16,237,201)
1970   ! *
1980   Q7=FNMeny
1990   RETURN F
2000 FNEND 
2010 ! * 
2020 ! ******************************* 
2030 ! * 
2040 ! * Set/Reset linear addressing 
2050 ! * 
2060 DEF FNSetlin(Set)
2070   IF NOT Set THEN GOTO 2150
2080   Qtab$=Rtab$
2090   I=6
2100   WHILE I<32
2110     MID$(Rtab$,I,1)=CHR$(ASCII(MID$(Rtab$,I,1)) AND 255-64) ! Res old addr. 
2120     I=I+4
2130   WEND 
2140   RETURN F
2150   ! * 
2160   Rtab$=Qtab$
2170   RETURN F
2180 FNEND 
2190 ! * 
2200 ! ******************************* 
2210 ! * 
2220 ! * Make drive descriptor from dev-name 
2230 ! * 
2240 DEF FNDesc LOCAL Idev,Entry
2250   IF Dev$='UFD:' THEN RETURN FNUdesc
2260   Idev=ASCII(Dev$)+SWAP%(ASCII(RIGHT$(Dev$,2)))
2270   IF Dev$='RAM:' THEN Idev=ASCII('R')+SWAP%(ASCII('M'))
2280   Entry=0
2290   WHILE Entry<32
2300     IF PEEK2(Table+Entry+2)=Idev THEN GOTO 2340
2310     Entry=Entry+4
2320   WEND 
2330   RETURN T
2340   ! * 
2350   IF Scan IF Entry=PEEK(Table) AND 16+8+4 THEN RETURN T ! Don't show DR again if Scan
2360   IF Entry=0 THEN Entry=PEEK(Table) AND 16+8+4 ! DR conv.
2370   Selcod=Entry
2380   IF Dev$<>'RAM:' THEN Selcod=Selcod OR VAL(MID$(Dev$,3,1))
2390   IF Dev$='RAM:' THEN Selcod=Selcod OR 1
2400   Clusi=2^(PEEK(Table+Entry+1) AND 7)
2410   Dirbeg=16
2420   RETURN F
2430 FNEND 
2440 ! *
2450 DEF FNUdesc LOCAL Qselcod
2460   Qselcod=PEEK(-7)
2470   Entry=Qselcod AND 16+8+4
2480   Selcod=30
2490   Clusi=2^(PEEK(Table+Entry+1) AND 7)
2500   Dirbeg=PEEK2(-9)
2510   IF Dirbeg=0 THEN RETURN T ! UFD not active
2520   RETURN F
2530 FNEND 
2540 ! * 
2550 ! +---------------------------------+ 
2560 ! ! Huvudrutin f|r en drive el. RAM ! 
2570 ! +---------------------------------+ 
2580 DEF FNEnhet
2590   Q7=FNVolname
2600   IF Dev$='UFD:' THEN Q7=FNMfd ELSE Q7=FNVolshort
2610   IF FNBitmap THEN RETURN T
2620   Q7=FNReadfil
2630   RETURN Q7
2640 FNEND 
2650 ! * 
2660 ! ********************************************************************** 
2670 ! *                                                                    * 
2680 ! *     S U B   F U N C T I O N   D E C L A R A T I O N   P A R T      *
2690 ! *                                                                    * 
2700 ! ********************************************************************** 
2710 ! * 
2720 DEF FNUnsign.(X)=-(X AND 32768)*2.+X 
2730 ! *
2740 ! +-----------------------------+ 
2750 ! !  Meny                       ! 
2760 ! +-----------------------------+ 
2770 DEF FNMeny LOCAL I
2780   ! * 
2790   ; Huvud$ CUR(8,0);
2800   ; TAB(Widcomp1) '1 - Skrivare (Printer)'
2810   ; TAB(Widcomp1) '2 - Storlek'
2820   ; TAB(Widcomp1) '3 - Filstatus'
2830   ; TAB(Widcomp1) '4 - Viss drivenhet'
2840   Q7$=FNCon$('V{lj (1,2,3,4) ',13,Widcomp1+3)
2850   I=1
2860   WHILE I<=LEN(Q7$)
2870     IF INSTR(1,'1234',MID$(Q7$,I,1))=0 OR LEN(Q7$)>4 THEN 2780
2880     I=I+1
2890   WEND 
2900   IF INSTR(1,Q7$,'1') THEN Fil=T ELSE Fil=F
2910   IF INSTR(1,Q7$,'2') THEN Storlek=T ELSE Storlek=F
2920   IF INSTR(1,Q7$,'3') THEN Filstatus=T ELSE Filstatus=F
2930   IF INSTR(1,Q7$,'4') THEN Scan=F ELSE Scan=T
2940   IF Scan THEN RETURN F
2950   ! * 
2960   Q7$=FNCon$('Enhet ? ',16,6)
2970   IF FNDevname(Q7$) OR FNDesc THEN Q7=FNFel('Felaktigt enhetsnamn',T) : GOTO 2950
2980   RETURN F
2990 FNEND 
3000 ! * 
3010 ! ******************************** 
3020 ! * 
3030 ! * Skriv ledtext och h{mta svar 
3040 ! * 
3050 DEF FNCon$(Text$,Rad,Kol) LOCAL S,S1,T$=160
3060   ! *
3070   S=160
3080   ; CUR(Rad,Kol) Text$;
3090   WHILE S1<=S AND (PEEK(65362)<Wid OR PEEK(65363)<23)
3100     ; ' ';
3110     S1=S1+1
3120   WEND 
3130   ; CUR(Rad,Kol) Text$;
3140   ON ERROR GOTO 3200
3150   INPUT LINE T$
3160   WHILE ASCII(T$)=ASCII(' ')
3170     T$=RIGHT$(T$,2) ! Skip leading spaces
3180   WEND 
3190   RETURN LEFT$(T$,LEN(T$)-2)
3200   ! *
3210   Q7=FNFel('Funktionstangent',T)
3220   RESUME 3060
3230 FNEND 
3240 ! * 
3250 ! ******************************** 
3260 ! * 
3270 ! * Kontrollera och formatera enhetsnamn 
3280 ! * Enhetsnamn ut i Dev$ om ej error 
3290 ! * 
3300 DEF FNDevname(N1$) LOCAL N$=160
3310   Dev$='   :'
3320   N$=FNUpcase$(N1$)
3330   IF N$='' THEN RETURN T
3340   IF N$='0' OR N$='1' THEN Dev$='DR'+N$+':' : RETURN F
3350   IF LEN(N$)>4 OR LEN(N$)<3 THEN RETURN T
3360   IF LEN(N$)=4 THEN N$=LEFT$(N$,3)
3370   IF INSTR(1,Devs$,N$)=0 THEN RETURN T
3380   Dev$=N$+':'
3390   RETURN F
3400 FNEND 
3410 ! * 
3420 ! +------------------------------------+ 
3430 ! ! Scroll rutin                       ! 
3440 ! +------------------------------------+ 
3450 DEF FNScroll LOCAL Mxname,Index,Lin,I,Opt
3460   ; Huvud$
3470   ; Dev$ Volshort$ FNUnsign.(Rsize) 'kvar av' FNUnsign.(Osize) TAB(Wid)
3480   ; 'VOLYM: ' Volname$
3490   ; CUR(4,0);
3500   ; TAB(Widcomp2+1) Lhead1$
3510   ; TAB(Widcomp2+1) Lhead2$
3520   Q7=FNHelp
3530   Mxname=LEN(Summa$)/20-1 ! Max filename nr
3540   WHILE Index+Mxlin<=Mxname
3550     Lin=0
3560     WHILE Lin<=Mxlin
3570       I=20*(Index+Lin)+1
3580       ; CUR(Lin+6,Widcomp2);
3590       ; MID$(Summa$,I,12)+' '+MID$(Summa$,I+12,6)+'     '+MID$(Summa$,I+18,1)+'        '+MID$(Summa$,I+19,1);
3600       Lin=Lin+1
3610     WEND 
3620     Opt=FNKey(CHR$(13,32,196,198,212,214))
3630     IF Opt=1 THEN RETURN T
3640     IF Opt=2 OR Opt=4 THEN Index=Index+1
3650     IF Opt=3 THEN Index=Index-1 : IF Index<0 THEN Index=0
3660     IF Opt=5 THEN Forw=F : RETURN F ELSE Forw=T
3670     IF Opt=6 THEN RETURN F
3680   WEND 
3690   RETURN F
3700 FNEND 
3710 ! *
3720 ! *******************************
3730 ! *
3740 ! * List filenames on pr:
3750 ! *
3760 DEF FNPrlist LOCAL Mxname,Name,I,Tabul
3770   ON ERROR GOTO 3950
3780   PREPARE 'pr:' AS FILE 1
3790   ; #1,Prhead$
3800   ; #1
3810   ; #1,Dev$ Volshort$ ',' FNUnsign.(Rsize) 'lediga av totalt' FNUnsign.(Osize) 'sektorer.'
3820   ; #1,'VOLYM: ' Volname$
3830   ; #1
3840   ; #1,Lhead1$ TAB(41) Lhead1$
3850   ; #1,Lhead2$ TAB(41) Lhead2$
3860   Mxname=LEN(Summa$)/20-1
3870   WHILE Name<=Mxname
3880     IF Tabul=1 THEN Tabul=41 ELSE Tabul=1
3890     I=20*Name+1
3900     ; #1,TAB(Tabul);
3910     ; #1,MID$(Summa$,I,12)+' ' MID$(Summa$,I+12,6)+'     '+MID$(Summa$,I+18,1)+'        '+MID$(Summa$,I+19,1);
3920     LET Name=Name+1
3930   WEND 
3940   RETURN F
3950   ! *
3960   RESUME 3970
3970   RETURN T
3980 FNEND 
3990 ! *
4000 ! *******************************
4010 ! * 
4020 ! * Read volume name 
4030 ! * 
4040 DEF FNVolname
4050   Volname$=''
4060   IF FNRdsec(0) THEN RETURN T
4070   I=-2681
4080   WHILE I<-2560
4090     IF PEEK(I)=13 AND PEEK(I+1)=10 THEN RETURN F
4100     IF PEEK(I)<32 OR PEEK(I)>127 THEN Volname$='' : RETURN F
4110     Volname$=Volname$+CHR$(PEEK(I))
4120     I=I+1
4130   WEND 
4140   Volname$=''
4150   RETURN F
4160 FNEND 
4170 ! * 
4180 ! *******************************
4190 ! *
4200 ! * Read short volume name in sysdir
4210 ! *
4220 DEF FNVolshort
4230   ON ERROR GOTO 4280
4240   OPEN Dev$+'sysdir.sys' AS FILE 2
4250   GET #2,Q7$ COUNT 11
4260   Volshort$=LEFT$(Q7$,8)+'.'+RIGHT$(Q7$,9)
4270   RETURN F
4280   ! *
4290   RESUME 4300
4300   Volshort$=SPACE$(12)
4310   RETURN F
4320 FNEND 
4330 ! *
4340 ! *******************************
4350 ! *
4360 ! * Find MFD device
4370 ! *
4380 DEF FNMfd LOCAL Mfdcod,D$=3
4390   Mfdcod=PEEK(-7)
4400   D$=CVT%$(PEEK2(Table+(Mfdcod AND 16+8+4)+2))
4410   IF (Mfdcod AND 16+8+4)=PEEK(Table) THEN D$='DR'
4420   D$=D$+NUM$(Mfdcod AND 2+1)
4430   IF Mfdcod>=28 THEN D$='RAM'
4440   Volshort$='   ('+D$+':)   '
4450   RETURN F
4460 FNEND 
4470 ! *
4480 ! +------------------------------+ 
4490 ! ! Sortera in filnamn i listan  ! 
4500 ! +------------------------------+ 
4510 DEF FNSort(Filnamn$) LOCAL Bottom,Mitten,Top
4520   Top=LEN(Summa$)/20-1
4530   WHILE Bottom<>Top
4540     Mitten=(Bottom+Top)/2
4550     IF Filnamn$<MID$(Summa$,Mitten*20+1,12) THEN Top=Mitten ELSE Bottom=Mitten+1
4560   WEND 
4570   Summa$=LEFT$(Summa$,Bottom*20)+Filnamn$+RIGHT$(Summa$,Top*20+1)
4580   RETURN F
4590 FNEND 
4600 ! * 
4610 ! ********************************* 
4620 ! * 
4630 ! * Read one physical sector 
4640 ! * 
4650 DEF FNRdsec(Secnr) LOCAL Ecod
4660   POKE -767,Selcod
4670   Q7=CALL(24678,Secnr)
4680   Ecod=PEEK(-747)
4690   IF Ecod=0 THEN RETURN F
4700   IF Ecod AND 128 THEN RETURN T
4710   IF Ecod AND 16 THEN Q7=FNFel(Dev$+'Skivan d}ligt formatterad.',F)
4720   IF Ecod AND 255-16 THEN Q7=FNFel(Dev$+'Diskfel '+NUM$(Ecod),F)
4730   RETURN T
4740 FNEND 
4750 ! * 
4760 ! +----------------------------------+ 
4770 ! ! Bitmap                           ! 
4780 ! +----------------------------------+ 
4790 DEF FNBitmap LOCAL Index,Sec
4800   IF Clusi=1 THEN Sec=7 ELSE Sec=15
4810   IF FNRdsec(Sec) THEN RETURN T
4820   IF Clusi=1 AND Dev$<>'UFD:' AND PEEK(Dosbuf+3)<>255 THEN Mxdirsec=7 ELSE Mxdirsec=15
4830   Osize=CALL(VARPTR(Bitmap$))*Clusi
4840   ! *
4850   IF FNRdsec(Sec-1) THEN RETURN T
4860   Rsize=CALL(VARPTR(Bitmap$))*Clusi
4870   IF Dev$='UFD:' THEN IF FNRdsec(Dirbeg-1) THEN RETURN T
4880   WHILE Index<16
4890     Antal(Index)=PEEK(-2577+Index)
4900     Index=Index+1
4910   WEND 
4920   RETURN F
4930 FNEND 
4940 ! * 
4950 ! +------------------------------------+ 
4960 ! ! Omvandlar sm} bokst{ver till stora ! 
4970 ! +------------------------------------+ 
4980 DEF FNUpcase$(Text$)
4990   IF LEN(Text$)=0 THEN RETURN ''
5000   IF ASCII(Text$)>95 AND ASCII(Text$)<127 THEN RETURN CHR$(ASCII(Text$) AND 95)+FNUpcase$(RIGHT$(Text$,2))
5010   RETURN LEFT$(Text$,1)+FNUpcase$(RIGHT$(Text$,2))
5020 FNEND 
5030 ! *
5040 ! +-------------------------------------+ 
5050 ! ! H{mta filnamn ur DOSBUF 0           ! 
5060 ! +-------------------------------------+ 
5070 DEF FNFilnamn$(Index) LOCAL Filnamn$=12
5080   Filnamn$=MID$(Dosbuf$,Index+4,11)
5090   Filnamn$=LEFT$(Filnamn$,8)+'.'+RIGHT$(Filnamn$,9)
5100   RETURN Filnamn$
5110 FNEND 
5120 ! *
5130 ! +-------------------------------------+ 
5140 ! ! Skriv- och rad`rskydd               ! 
5150 ! +-------------------------------------+ 
5160 DEF FNProt$(Index) LOCAL Prot$=4,Protbyte
5170   IF Filstatus=0 THEN RETURN '  '
5180   Prot$='  '
5190   Protbyte=ASCII(MID$(Dosbuf$,Index+1,1))
5200   IF (Protbyte AND 1) THEN MID$(Prot$,1,1)='S'
5210   IF (Protbyte AND 2) THEN MID$(Prot$,2,1)='R'
5220   RETURN Prot$
5230 FNEND 
5240 ! *
5250 ! +-------------------------------------+ 
5260 ! ! Filens storlek                      ! 
5270 ! +-------------------------------------+ 
5280 DEF FNStorlek$(Index) LOCAL Ribad,Filesize,Storlek$=6
5290   IF Storlek=F THEN RETURN '      '
5300   Filesize=CVT$%(MID$(Dosbuf$,Index+2,2))
5310   Storlek$=NUM$(FNUnsign.(Filesize))
5320   IF Filesize THEN RETURN SPACE$(6-LEN(Storlek$))+Storlek$
5330   ! *
5340   ! * Old DOS file size computing
5350   ! *
5360   Ribad=Clusi*(SWAP%(CVT$%(MID$(Dosbuf$,Index,2)))/32)
5370   Filesize=Clusi*CALL(VARPTR(Stor$),Ribad)
5380   Storlek$=NUM$(FNUnsign.(Filesize))
5390   RETURN SPACE$(6-LEN(Storlek$))+Storlek$
5400 FNEND 
5410 ! *
5420 ! +-----------------------------------+ 
5430 ! ! Huvudrutin f|r l{sning av filnamn ! 
5440 ! +-----------------------------------+ 
5450 DEF FNReadfil LOCAL Status,Index,Filnamn$=20,Dirsec,Rad
5460   Summa$=SPACE$(20)
5470   WHILE Dirsec<=Mxdirsec
5480     IF Antal(Dirsec)=0 THEN GOTO 5590
5490     IF FNRdsec(Dirsec+Dirbeg) THEN RETURN T
5500     Index=1
5510     WHILE Index<=250
5520       Q7=ASCII(RIGHT$(Dosbuf$,Index))
5530       IF Q7=0 OR Q7=255 THEN GOTO 5560
5540       Filnamn$=FNFilnamn$(Index)+FNStorlek$(Index)+FNProt$(Index)
5550       Q7=FNSort(Filnamn$)
5560       ! *
5570       Index=Index+16
5580     WEND 
5590     ! *
5600     Dirsec=Dirsec+1
5610   WEND 
5620   IF LEN(Summa$)<20*(Mxlin+1) THEN Summa$=Summa$+SPACE$(20*(Mxlin+1)-LEN(Summa$))
5630   RETURN F
5640 FNEND 
5650 ! *
5660 ! +----------------------------------+ 
5670 ! ! L{s ett tkn                      ! 
5680 ! +----------------------------------+ 
5690 DEF FNKey(Opt$) LOCAL Key$=1
5700   ; CUR(23,Wid-2) '*';
5710   GET Key$
5720   ; CUR(23,Wid-2) ' ';
5730   RETURN INSTR(1,Opt$,Key$)
5740 FNEND 
5750 ! *
5760 ! +----------------------------------+ 
5770 ! !  Fler utskrifter ??              ! 
5780 ! +----------------------------------+ 
5790 DEF FNMore
5800   IF Wid<80 THEN ; CUR(22,0) SPACE$(Wid);
5810   Q7$=FNCon$('Fler utskrifter (J/N) ? ',23,0)
5820   IF (ASCII(Q7$) OR 32)=ASCII('j') THEN RETURN T ELSE RETURN F
5830 FNEND 
5840 ! * 
5850 ! +------------------------------------+ 
5860 ! ! Skriv ut hj{lptext                 ! 
5870 ! +------------------------------------+ 
5880 DEF FNHelp
5890   IF Wid>=80 THEN GOTO 5940
5900   ; CUR(22,0) 'PF5=F|reg}ende   SH+PF5=F|reg}ende enhet';
5910   ; CUR(23,0) 'PF7=N{sta        SH+PF7=N{sta enhet >';
5920   ; CUR(21,0);STRING$(Wid,ASCII('='));
5930   RETURN F
5940   ! * 
5950   ; CUR(23,0);'PF5=F|reg}ende  PF7=N{sta  SH+PF5=F|reg}ende enhet  SH+PF7=N{sta enhet      >';
5960   ; CUR(22,0);STRING$(Wid,ASCII('='));
5970   RETURN F
5980 FNEND 
5990 ! * 
6000 ! ******************************** 
6010 ! * 
6020 ! * Felfunktion 
6030 ! * 
6040 DEF FNFel(Skriv$,Kvittera)
6050   ; CHR$(7);
6060   ; CUR(23,0);SPACE$(Wid);CUR(23,0);Skriv$;
6070   IF Kvittera=F THEN Q7=5000 : WHILE Q7 : Q7=Q7-1 : WEND : GOTO 6130
6080   ; ' - Tryck <CE>';
6090   Q$=' '
6100   WHILE INSTR(1,CHR$(24,13),Q$)=0
6110     GET Q$
6120   WEND 
6130   ! *
6140   ; CUR(23,0);SPACE$(Wid);
6150   RETURN F
6160 FNEND 
6170 ! * 
