100 ! -----------------------------------------------------
110 ! 
120 ! '           IFR - SIMULATOR         (f|r ABC806)
130 ! '           ===============
140 ! 
150 ! '                      Saved as  'SIMULHR.BAC'
160 ! 
170 ! ID Computer-Systeme GmbH * Bad Honnef *
180 ! 
190 ! 20.02.1985
200 ! 
210 ! 9'976 bytes frei
220 ! ------------------------------------------------------
230 ! 
235 EXTEND : FLOAT 
240 ! ---------------------- Common ---------------------------
250 ! 
260 COMMON Vs(19,2),Vp(9,1,5),Vpl(9),Wa(10,1),Err(23),Errtot(23),Errtot
270 COMMON Vs$(19)=3,Vp$(9)=10,Err$(23)=50
280 COMMON Nlatmin,Nlatmax,Nlatdiff,Elongmin,Elongmax,Elongdiff
290 COMMON Flag
300 ! 
310 COMMON Korr,Zgr,Kd,Kgr
320 COMMON Fra,Fin,Fhi,Fza,Fan,Fze
330 COMMON A(4),A0,A1,A2,A4,A6,A7
340 COMMON B(4),B0,B1,B2,B4,B6,B7
350 ! 
360 ! ---------------------- Wind ------------------------------
370 ! 
380 Rs=1 : IF RND<.5 THEN Rs=-1
390 FOR I=0 TO 10 : Wa(I,0)=RND/4 : NEXT I 
400 FOR I=4 TO 6 : Wa(I,0)=Wa(I,0)*Rs : NEXT I 
410 FOR I=0 TO 6 : Wa(I,1)=FIX(5*RND) : NEXT I 
420 FOR I=4 TO 6 : Wa(I,1)=Wa(I,1)*Rs : NEXT I 
430 ! 
440 ! ------------- Pisten - Daten -------------------
450 ! 
460 Vpl(0)=285 : Vp$(0)="Paris"
470 Vp(0,0,0)=81 : Vp(0,0,1)=2.1 : Vp(0,0,2)=1.1 : Vp(0,0,3)=2.1 : Vp(0,0,4)=3.1 : Vp(0,0,5)=4.1
480 Vp(0,1,0)=81 : Vp(0,1,1)=2.1 : Vp(0,1,2)=1.1 : Vp(0,1,3)=2.1 : Vp(0,1,4)=3.1 : Vp(0,1,5)=4.1
490 Vpl(1)=636 : Vp$(1)="Lyon"
500 Vp(1,0,0)=168 : Vp(1,0,1)=2.1 : Vp(1,0,2)=1.1 : Vp(1,0,3)=2.1 : Vp(1,0,4)=3.1 : Vp(1,0,5)=4.1
510 Vp(1,1,0)=168 : Vp(1,1,1)=2.1 : Vp(1,1,2)=1.1 : Vp(1,1,3)=2.1 : Vp(1,1,4)=3.1 : Vp(1,1,5)=4.1
520 Vpl(2)=66 : Vp$(2)="Marseille"
530 Vp(2,0,0)=138 : Vp(2,0,1)=2.1 : Vp(2,0,2)=1.1 : Vp(2,0,3)=2.1 : Vp(2,0,4)=3.1 : Vp(2,0,5)=4.1
540 Vp(2,1,0)=138 : Vp(2,1,1)=2.1 : Vp(2,1,2)=1.1 : Vp(2,1,3)=2.1 : Vp(2,1,4)=3.1 : Vp(2,1,5)=4.1
550 Vpl(3)=691 : Vp$(3)="Milan"
560 Vp(3,0,0)=352 : Vp(3,0,1)=2.1 : Vp(3,0,2)=1.1 : Vp(3,0,3)=2.1 : Vp(3,0,4)=3.1 : Vp(3,0,5)=4.1
570 Vp(3,1,0)=352 : Vp(3,1,1)=2.1 : Vp(3,1,2)=1.1 : Vp(3,1,3)=2.1 : Vp(3,1,4)=3.1 : Vp(3,1,5)=4.1
580 Vpl(4)=164 : Vp$(4)="Br}ssel"
590 Vp(4,0,0)=50 : Vp(4,0,1)=2.1 : Vp(4,0,2)=1.1 : Vp(4,0,3)=2.1 : Vp(4,0,4)=3.1 : Vp(4,0,5)=4.1
600 Vp(4,1,0)=50 : Vp(4,1,1)=2.1 : Vp(4,1,2)=1.1 : Vp(4,1,3)=2.1 : Vp(4,1,4)=3.1 : Vp(4,1,5)=4.1
610 Vpl(5)=111 : Vp$(5)="......."
620 Vp(5,0,0)=0 : Vp(5,0,1)=2.1 : Vp(5,0,2)=1.1 : Vp(5,0,3)=2.1 : Vp(5,0,4)=3.1 : Vp(5,0,5)=4.1
630 Vp(5,1,0)=0 : Vp(5,1,1)=2.1 : Vp(5,1,2)=1.1 : Vp(5,1,3)=2.1 : Vp(5,1,4)=3.1 : Vp(5,1,5)=4.1
640 Vpl(6)=111 : Vp$(6)="......."
650 Vp(6,0,0)=0 : Vp(6,0,1)=2.1 : Vp(6,0,2)=1.1 : Vp(6,0,3)=2.1 : Vp(6,0,4)=3.1 : Vp(6,0,5)=4.1
660 Vp(6,1,0)=0 : Vp(6,1,1)=2.1 : Vp(6,1,2)=1.1 : Vp(6,1,3)=2.1 : Vp(6,1,4)=3.1 : Vp(6,1,5)=4.1
670 Vpl(7)=111 : Vp$(7)="......."
680 Vp(7,0,0)=0 : Vp(7,0,1)=2.1 : Vp(7,0,2)=1.1 : Vp(7,0,3)=2.1 : Vp(7,0,4)=3.1 : Vp(7,0,5)=4.1
690 Vp(7,1,0)=0 : Vp(7,1,1)=2.1 : Vp(7,1,2)=1.1 : Vp(7,1,3)=2.1 : Vp(7,1,4)=3.1 : Vp(7,1,5)=4.1
700 Vpl(8)=111 : Vp$(8)="......."
710 Vp(8,0,0)=0 : Vp(8,0,1)=2.1 : Vp(8,0,2)=1.1 : Vp(8,0,3)=2.1 : Vp(8,0,4)=3.1 : Vp(8,0,5)=4.1
720 Vp(8,1,0)=0 : Vp(8,1,1)=2.1 : Vp(8,1,2)=1.1 : Vp(8,1,3)=2.1 : Vp(8,1,4)=3.1 : Vp(8,1,5)=4.1
730 Vpl(9)=111 : Vp$(9)="......."
740 Vp(9,0,0)=0 : Vp(9,0,1)=2.1 : Vp(9,0,2)=1.1 : Vp(9,0,3)=2.1 : Vp(9,0,4)=3.1 : Vp(9,0,5)=4.1
750 Vp(9,1,0)=0 : Vp(9,1,1)=2.1 : Vp(9,1,2)=1.1 : Vp(9,1,3)=2.1 : Vp(9,1,4)=3.1 : Vp(9,1,5)=4.1
760 ! 
770 ! -------------------- VOR - Daten ------------------------
780 ! 
790 Vs(0,0)=48.7166 : Vs(0,1)=2.3833 : Vs(0,2)=111.2 : Vs$(0)="OL "
800 Vs(1,0)=45.75 : Vs(1,1)=4.95 : Vs(1,2)=116.3 : Vs$(1)="LYO"
810 Vs(2,0)=43.45 : Vs(2,1)=5.2 : Vs(2,2)=117.1 : Vs$(2)="MBO"
820 Vs(3,0)=45.63301 : Vs(3,1)=8.7 : Vs(3,2)=113.7 : Vs$(3)="SRN"
830 Vs(4,0)=50.9 : Vs(4,1)=4.4833 : Vs(4,2)=114.6 : Vs$(4)="BUB"
840 Vs(5,0)=42 : Vs(5,1)=1 : Vs(5,2)=109.1 : Vs$(5)="..."
850 Vs(6,0)=42 : Vs(6,1)=1 : Vs(6,2)=109.1 : Vs$(6)="..."
860 Vs(7,0)=42 : Vs(7,1)=1 : Vs(7,2)=109.1 : Vs$(7)="..."
870 Vs(8,0)=42 : Vs(8,1)=1 : Vs(8,2)=109.1 : Vs$(8)="..."
880 Vs(9,0)=42 : Vs(9,1)=1 : Vs(9,2)=109.1 : Vs$(9)="..."
890 Vs(10,0)=42 : Vs(10,1)=1 : Vs(10,2)=109.1 : Vs$(10)="..."
900 Vs(11,0)=42 : Vs(11,1)=1 : Vs(11,2)=109.1 : Vs$(11)="..."
910 Vs(12,0)=42 : Vs(12,1)=1 : Vs(12,2)=109.1 : Vs$(12)="..."
920 Vs(13,0)=42 : Vs(13,1)=1 : Vs(13,2)=109.1 : Vs$(13)="..."
930 Vs(14,0)=42 : Vs(14,1)=1 : Vs(14,2)=109.1 : Vs$(14)="..."
940 Vs(15,0)=42 : Vs(15,1)=1 : Vs(15,2)=109.1 : Vs$(15)="..."
950 Vs(16,0)=42 : Vs(16,1)=1 : Vs(16,2)=109.1 : Vs$(16)="..."
960 Vs(17,0)=42 : Vs(17,1)=1 : Vs(17,2)=109.1 : Vs$(17)="..."
970 Vs(18,0)=42 : Vs(18,1)=1 : Vs(18,2)=109.1 : Vs$(18)="..."
980 Vs(19,0)=42 : Vs(19,1)=1 : Vs(19,2)=109.1 : Vs$(19)="..."
990 ! 
1000 ! -------------------- Definitionen ------------------------
1010 ! 
1020 DEF FNZahl(X0,Y0,N$,F) LOCAL X,Y
1030   X=X0-4 : Y=Y0
1040   FOR J=1 TO LEN(N$)
1050     Z=-1
1060     Z$=MID$(N$,J,1)
1070     IF Z$>="0" AND Z$<="9" THEN Z=VAL(Z$)
1080     X=X+4 : Y=Y0
1090     IF Z$="-" THEN Z=10 : X=X-1
1100     IF Z$="." THEN Z=11 : X=X-2
1110     IF Z$="1" THEN X=X-1
1120     IF Z=0 THEN FGPOINT X,Y,F : FGLINE X+2,Y : FGLINE X+2,Y+4 : FGLINE X,Y+4 : FGLINE X,Y
1130     IF Z=1 THEN FGPOINT X+2,Y,F : FGLINE X+2,Y+4
1140     IF Z=2 THEN FGPOINT X+2,Y,F : FGLINE X,Y : FGLINE X,Y+2 : FGLINE X+2,Y+2 : FGLINE X+2,Y+4 : FGLINE X,Y+4
1150     IF Z=3 THEN FGPOINT X,Y,F : FGLINE X+2,Y : FGLINE X+2,Y+4 : FGLINE X,Y+4 : FGPOINT X+1,Y+2
1160     IF Z=4 THEN FGPOINT X+2,Y,F : FGLINE X+2,Y+4 : FGPOINT X,Y+4 : FGLINE X,Y+2 : FGLINE X+2,Y+2
1170     IF Z=5 THEN FGPOINT X,Y,F : FGLINE X+2,Y : FGLINE X+2,Y+2 : FGLINE X,Y+2 : FGLINE X,Y+4 : FGLINE X+2,Y+4
1180     IF Z=6 THEN FGPOINT X+2,Y+4,F : FGLINE X,Y+4 : FGLINE X,Y : FGLINE X+2,Y : FGLINE X+2,Y+2 : FGLINE X,Y+2
1190     IF Z=7 THEN FGPOINT X+2,Y,F : FGLINE X+2,Y+4 : FGLINE X,Y+4
1200     IF Z=8 THEN FGPOINT X,Y,F : FGLINE X+2,Y : FGLINE X+2,Y+4 : FGLINE X,Y+4 : FGLINE X,Y : FGPOINT X+1,Y+2
1210     IF Z=9 THEN FGPOINT X,Y,F : FGLINE X+2,Y : FGLINE X+2,Y+4 : FGLINE X,Y+4 : FGLINE X,Y+2 : FGLINE X+2,Y+2
1220     IF Z=10 THEN FGPOINT X+1,Y+2,F : FGLINE X+2,Y+2
1230     IF Z=11 THEN FGPOINT X+1,Y,F
1240   NEXT J 
1250   RETURN 0
1260 FNEND 
1270 DEF FNVor(X1,Y1)
1280   FOR J=0 TO 29
1290     FGPOINT X1+2*SIN(J*PI/15)*2,Y1+COS(J*PI/15)/Korr*2,2
1300     IF INT(J/5)*5=J THEN FGLINE X1+2*SIN(J*PI/15)*3,Y1+COS(J*PI/15)*3/Korr
1310   NEXT J 
1320   RETURN 0
1330 FNEND 
1340 ! 
1350 ! --------------------- Verteilung ------------------------
1360 ! 
1370 IF Flag=1 THEN 1400
1380 IF Flag=2 THEN 3220
1390 IF Flag=3 THEN 3380
1400 ! 
1410 ! --------------------- Variablen / Clear -----------------
1420 ! 
1430 FGCTL BLK
1440 FGPICTURE 0,0,4 : FGPOINT 0,0,0 : FGFILL 511,239
1450 FGPICTURE 1,0 : FGPOINT 0,0,0 : FGFILL 511,239
1460 FGPICTURE 2,0 : FGPOINT 0,0,0 : FGFILL 511,239
1470 RESTORE 
1480 FOR I=0 TO 23
1490   READ Err$(I),Err(I)
1500 NEXT I 
1510 ! 
1520 ! -------------------- Ursprung ---------------------------
1530 ! 
1540 Nlatmin=42 : Nlatmax=52 : Nlatdiff=Nlatmax-Nlatmin
1550 Elongmin=0 : Elongmax=Elongmin+2*Nlatdiff : Elongdiff=Elongmax-Elongmin
1560 Korr=.865
1570 Zgr=14 : ! Zeigergr|sse
1580 Kd=18 : ! Kreisgr|sse
1590 Kgr=3 : ! Kreisgradation
1600 Khd=23 : ! K}nstl. Horizont Durchmesser
1610 A(0)=227 : A(1)=173 : A(2)=173 : A(3)=227 : A(4)=117
1620 B(0)=40 : B(1)=40 : B(2)=100 : B(3)=100 : B(4)=45
1630 A0=117 : B0=105 : ! K}nstlicher Horizont
1640 A1=203 : B1=140 : ! ILS Kreuz
1650 A2=128 : B2=235 : ! Mittelstreifen
1660 A4=0 : B4=140 : ! Radio
1670 A5=0 : B5=170 : ! DME
1680 A6=32 : B6=96 : ! Wheels
1690 A7=50 : B7=50 : ! Tanks
1700 A8=78 : B8=0 : ! VLF
1710 A9=0 : B9=200 : ! Navigation
1720 Fra=5 : ! F Rahmen
1730 Frah=6 : ! F Rahmen-Instrumente
1740 Fin=5 : ! F Instrumente
1750 Fhi=5 : ! F Hintergrund
1760 Fza=7 : ! F Zahlen
1770 Fan=7 : ! F Analog
1780 Fze=6 : ! F Zeiger
1790 Fkrd=5 : ! F VOR Koordinaten
1800 ! 
1810 ! ----------------- VOR Karte zeichnen ------------------------
1820 ! 
1830 FGPICTURE 1,1 : FGCTL BLK : ! 1,0 /
1840 FGCTL BLK+BLU+GRN+RED : ! /
1850 FOR I=0 TO Elongdiff
1860   Z=FNZahl(I*490/Elongdiff+8,3,NUM$(I+Elongmin),1)
1870   FOR J=10 TO 230 STEP 2
1880     FGPOINT I*490/Elongdiff+10,J,1
1890   NEXT J 
1900 NEXT I 
1910 FOR I=0 TO Nlatdiff
1920   Z=FNZahl(0,I*220/Nlatdiff+8,NUM$(I+Nlatmin),1)
1930   FOR J=10 TO 500 STEP 4
1940     FGPOINT J,I*220/Nlatdiff+10
1950   NEXT J 
1960 NEXT I 
1970 FOR I=0 TO 5
1980   Y=11+(Vs(I,0)-Nlatmin)/Nlatdiff*220 : X=12+(Vs(I,1)-Elongmin)/Elongdiff*490
1990   Z=FNVor(X,Y)
2000   Z=FNZahl(X,Y+5,NUM$(Vs(I,2)),3)
2010 NEXT I 
2020 ! 
2030 ! ------------------- Platz Karte zeichnen --------------------
2040 ! 
2050 FGPICTURE 2,0 : FGCTL BLK+BLK+BLK+BLK+BLK
2060 FGPOINT 0,180,1 : FGLINE 40,180
2070 FGPOINT 20,160 : FGLINE 20,200
2080 ! 
2090 ! ----------------------- Rahmenstruktur -------------------------
2100 ! 
2110 FGPICTURE 0,0 : FGCTL BLK+BLK+BLK+BLK+BLK
2120 FGCTL BLK+CYA+RED+YEL+GRN+BLU+MAG+WHT : ! /
2130 ! Fenster
2140 FGPOINT 75,135,Fra : FGLINE 181,135
2150 FGPOINT 101,237 : FGLINE 155,237
2160 FGPOINT 75,135 : FGLINE 101,237
2170 FGPOINT 181,135 : FGLINE 155,237
2180 FGPOINT 128,140,6 : FGLINE 128,136 : FGLINE 130,136
2190 FGLINE 128,138 : FGLINE 126,136 : FGLINE 128,136
2200 ! K}nstlicher Horizont
2210 FGPOINT A0-25,B0-25/Korr,Frah : FGFILL A0+25,B0-25/Korr : FGFILL A0+25,B0+24/Korr : FGFILL A0-25,B0+24/Korr : FGFILL A0-25,B0-25/Korr
2220 FGPOINT A0,B0+Khd/Korr,Frah
2230 FOR I=0 TO 119
2240   FGLINE A0+SIN(I*PI/60)*Khd,B0+COS(I*PI/60)*Khd/Korr,Frah
2250 NEXT I 
2260 FGPAINT A0-24,B0-27,Frah
2270 ! ILS Kreuz
2280 FGPOINT A1,B1,6 : FGFILL A1+50,B1+2 : FGFILL A1+48,B1+50 : FGFILL A1,B1+48 : FGFILL A1+2,B1
2290 FGPOINT A1+50,B1+51,Fin : FGLINE A1+50,B1+82 : FGLINE A1,B1+82 : FGLINE A1,B1+51
2300 ! warnings
2310 FGPOINT A1-30,B1+70,Fin : FGLINE A1-30,B1+30 : FGLINE A1-1,B1+30 : FGLINE A1-1,B1+70 : FGLINE A1-30,B1+70
2320 ! Radio
2330 FGPOINT A4,B4,Fin : FGLINE A4+74,B4 : FGLINE A4+74,B4+30 : FGLINE A4,B4+30 : FGLINE A4,B4
2340 FGPOINT A4+6,B4+8,Fan : FGLINE A4+66,B4+8
2350 FOR I=0 TO 60 STEP 5
2360   FGPOINT A4+6+I,B4+9,Fan
2370   IF MOD(I,10)=0 THEN FGPOINT A4+6+I,B4+10 : FGLINE A4+6+I,B4+11
2380 NEXT I 
2390 FOR I=0 TO 3
2400   Z=FNZahl(A4+1+I*20,B4+14,NUM$(110+I*4),Fan)
2410 NEXT I 
2420 ! DME
2430 FGPOINT A5,B5,Fin : FGLINE A5+74,B5 : FGLINE A5+74,B5+30 : FGLINE A5,B5+30 : FGLINE A5,B5
2440 ! Navigation
2450 FGPOINT A9,B9,Fin : FGLINE A9+74,B9 : FGLINE A9+74,B9+39 : FGLINE A9,B9+39 : FGLINE A9,B9 : FGPOINT A9,B9+29 : FGLINE A9+74,B9+29
2460 ! Schalter
2470 FGPOINT 50,50,Fin : FGLINE 78,50 : FGLINE 78,0 : FGLINE 0,0
2480 FGLINE 0,130 : FGLINE 50,130 : FGLINE 50,0 : FGLINE 0,0
2490 FGPOINT 0,30 : FGLINE 50,30 : FGPOINT 0,60 : FGLINE 50,60
2500 FGPOINT 0,90 : FGLINE 50,90 : FGPOINT 0,110 : FGLINE 50,110
2510 ! VLF
2520 FGPOINT A8,B8,Fin : FGLINE A8+66,B8 : FGLINE A8+66,B8+20 : FGLINE A8,B8+20 : FGLINE A8,B8
2530 ! Tanks
2540 FGPOINT A7,B7,Fin : FGLINE A7+37,B7 : FGLINE A7+37,B7+80 : FGLINE A7,B7+80 : FGLINE A7,B7
2550 FGPOINT A7+5,B7+30 : FGLINE A7+33,B7+30 : FGLINE A7+33,B7+68 : FGLINE A7+5,B7+68 : FGLINE A7+5,B7+30
2560 FGPOINT A7+19,B7+30 : FGLINE A7+19,B7+68
2570 FGPOINT A7+6,B7+31,6 : FGFILL A7+18,B7+67
2580 FGPOINT A7+20,B7+31,6 : FGFILL A7+32,B7+67
2590 ! Uhren
2600 FOR J=0 TO 4
2610   FOR I=-Kd TO Kd STEP .5
2620     FGPOINT A(J)+I,B(J)+SQR(ABS(Kd^2-I^2))/Korr,Fza
2630     IF I=-Kd THEN FGLINE A(J)+I+Kgr,B(J)+(SQR(ABS(Kd^2-I^2)))/Korr
2640     IF I=-Kd THEN FGPOINT A(J)+I,B(J)+(SQR(ABS(Kd^2-I^2))-3)/Korr : FGLINE A(J)+I,B(J)+(SQR(ABS(Kd^2-I^2))+3)/Korr
2650     IF I=0 THEN FGLINE A(J)+I,B(J)+(SQR(ABS(Kd^2-I^2))-Kgr)/Korr
2660     IF I=Kd THEN FGLINE A(J)+I-Kgr,B(J)+SQR(ABS(Kd^2-I^2))/Korr
2670     IF I=Kd THEN FGPOINT A(J)+I,B(J)+(SQR(ABS(Kd^2-I^2))-3)/Korr : FGLINE A(J)+I,B(J)+(SQR(ABS(Kd^2-I^2))+3)/Korr
2680     FGPOINT A(J)+I,B(J)-SQR(ABS(Kd^2-I^2))/Korr,Fza
2690     IF I=0 THEN FGLINE A(J)+I,B(J)-(SQR(ABS(Kd^2-I^2))-Kgr)/Korr
2700   NEXT I 
2710 NEXT J 
2720 FGPOINT 200,11,Fin : FGLINE 200+54,11 : FGLINE 200+54,11+58 : FGLINE 200,11+58 : FGLINE 200,11
2730 FGPOINT 201,12,1 : FGFILL 218,18
2740 FGPOINT 146,11,Fin : FGLINE 146+51,11 : FGLINE 146+51,11+58 : FGLINE 146,11+58 : FGLINE 146,11
2750 FGPOINT 147,12,1 : FGFILL 164,18
2760 FGPOINT 146,71,Fin : FGLINE 146+51,71 : FGLINE 146+51,71+58 : FGLINE 146,71+58 : FGLINE 146,71
2770 FGPOINT 147,72,1 : FGFILL 164,78
2780 FGPOINT 200,71,Fin : FGLINE 200+54,71 : FGLINE 200+54,71+58 : FGLINE 200,71+58 : FGLINE 200,71
2790 FGPOINT 201,72,1 : FGFILL 218,78
2800 FGPOINT 88,21,Fin : FGLINE 88+56,21 : FGLINE 88+56,21+49 : FGLINE 88,21+49 : FGLINE 88,21
2810 ! Hintergrund
2820 FGPOINT 0,0,Fhi : FGLINE 0,239 : FGLINE 255,239 : FGLINE 255,0 : FGLINE 149,0
2830 FGPAINT 100,75 : FGPAINT 80,230 : FGPAINT 180,170 : FGPAINT 157,237
2840 FGPAINT 10,136 : FGPAINT 250,1 : FGPAINT 81,23
2850 ! acc
2860 Z=FNZahl(A(0)-1,B(0)+23,"0",Fza)
2870 Z=FNZahl(A(0)+14,B(0)+17,".5",Fza)
2880 Z=FNZahl(A(0)+20,B(0)-2,"1",Fza)
2890 Z=FNZahl(A(0)+14,B(0)-20,".5",Fza)
2900 Z=FNZahl(A(0)-1,B(0)-27,"2",Fza)
2910 Z=FNZahl(A(0)-18,B(0)-19,".5",Fza)
2920 Z=FNZahl(A(0)-23,B(0)-2,"1",Fza)
2930 Z=FNZahl(A(0)-18,B(0)+16,".5",Fza)
2940 ! vario
2950 Z=FNZahl(A(1)-1,B(1)+23,"0",Fza)
2960 Z=FNZahl(A(1)+14,B(1)+17,"1",Fza)
2970 Z=FNZahl(A(1)+20,B(1)-2,"2",Fza)
2980 Z=FNZahl(A(1)+14,B(1)-20,"3",Fza)
2990 Z=FNZahl(A(1)-1,B(1)-27,"4",Fza)
3000 Z=FNZahl(A(1)-16,B(1)-19,"3",Fza)
3010 Z=FNZahl(A(1)-23,B(1)-2,"2",Fza)
3020 Z=FNZahl(A(1)-17,B(1)+16,"1",Fza)
3030 ! tas
3040 Z=FNZahl(A(2)-1,B(2)+23,"0",Fza)
3050 Z=FNZahl(A(2)+14,B(2)+17,"1",Fza)
3060 Z=FNZahl(A(2)+20,B(2)-2,"2",Fza)
3070 Z=FNZahl(A(2)+14,B(2)-20,"3",Fza)
3080 Z=FNZahl(A(2)-1,B(2)-27,"4",Fza)
3090 Z=FNZahl(A(2)-17,B(2)-19,"5",Fza)
3100 Z=FNZahl(A(2)-23,B(2)-2,"6",Fza)
3110 Z=FNZahl(A(2)-17,B(2)+16,"7",Fza)
3120 ! alt
3130 Z=FNZahl(A(3)-1,B(3)+23,"0",Fza)
3140 Z=FNZahl(A(3)+14,B(3)+17,"5",Fza)
3150 Z=FNZahl(A(3)+20,B(3)-2,"10",Fza)
3160 Z=FNZahl(A(3)+14,B(3)-20,"15",Fza)
3170 Z=FNZahl(A(3)-1,B(3)-27,"20",Fza)
3180 Z=FNZahl(A(3)-20,B(3)-19,"25",Fza)
3190 Z=FNZahl(A(3)-26,B(3)-2,"30",Fza)
3200 Z=FNZahl(A(3)-20,B(3)+16,"35",Fza)
3210 GOTO 3840
3220 ! 
3230 ! --------------------- Fehlermeldungen -------------------------
3240 ! 
3250 ; CHR$(12) CUR(0,10) ULN GRN "Fehlermeldungen" NULN " "
3260 ; CUR(1,5) ULN "Text" NULN " " CUR(1,55) ULN "Fehler" NULN " "
3270 ; CUR(1,62) ULN "Anzahl" NULN " " CUR(1,72) ULN "Punkte" NULN " "
3280 ; CUR(0,50) RED "Total Fehler : " YEL Errtot
3290 FOR I=1 TO 23
3300   ; CUR(1+I,0) MAG Err$(I);
3310   ; CUR(1+I,55) WHT; : ; USING "####" Err(I);
3320   ; CUR(1+I,62) BLU; : ; USING "###" Errtot(I)/Err(I);
3330   ; CUR(1+I,72) YEL; : ; USING "####" Errtot(I);
3340 NEXT I 
3350 IF SYS(5)<>0 THEN GET H$ ELSE 3350
3360 IF H$<>CHR$(32) THEN 3350
3370 GOTO 3840
3380 ! 
3390 ! ------------------------- Instruktionen ----------------------------
3400 ! 
3410 ; CHR$(12) CUR(0,20) ULN GRN "Instruktionen" NULN " "
3420 ; CUR(3,0) RED "E = " YEL "Ende"
3430 ; CUR(3,0) RED "C = " YEL "Kursvorwahl"
3440 ; CUR(4,0) RED "W = " YEL "Wheels"
3450 ; CUR(5,0) RED "V = " YEL "VOR Frequenz"
3460 ; CUR(6,0) RED "R = " YEL "Radial"
3470 ; CUR(7,0) RED "A = " YEL "Kurs einstellen"
3480 ; CUR(8,0) RED "M = " YEL "Durchstarten"
3490 ; CUR(9,0) RED "F = " YEL "Auftanken"
3500 ; CUR(10,0) RED "T = " YEL "Tank li/re"
3510 ; CUR(11,0) RED "K = " YEL "VOR Karten"
3520 ; CUR(12,0) RED "S = " YEL "Starterlaubnis"
3530 ; CUR(13,0) RED "P = " YEL "Pistendaten"
3540 ; CUR(15,0) RED "PF1/2 = " YEL "Thrust"
3550 ; CUR(16,0) RED "PF3/4 = " YEL "Flaps"
3560 ; CUR(17,0) RED "PF5/6 = " YEL "Bremsen"
3570 ; CUR(18,0) RED "PF7/8 = " YEL "VOR Frequenz"
3580 ; CUR(19,0) RED "SH+PF7/8 = " YEL "Platzwahl"
3590 ; CUR(2,40) ULN MAG "Steuerung" NULN " "
3610 ; CUR(3,58) YEL "auf " CYA "["
3620 ; CUR(4,58) RED " ! "
3630 ; CUR(5,45) YEL "left " CYA "<-" RED "  <-     ->  " YEL " right " CYA "->"
3640 ; CUR(6,58) RED " ! "
3650 ; CUR(7,58) YEL "ab " CYA "-"
3660 ; CUR(9,40) ULN MAG "Flaps" NULN " "
3670 ; CUR(10,40) RED " 5` = " YEL "    > 240 kts"
3680 ; CUR(11,40) RED "15` = " YEL "210 - 239 kts"
3690 ; CUR(12,40) RED "25` = " YEL "180 - 209 kts"
3700 ; CUR(13,40) RED "40` = " YEL "150 - 179 kts"
3710 ; CUR(15,40) ULN MAG "Daten" NULN " "
3720 ; CUR(16,40) RED "Leergewicht" TAB(60) YEL "140 t"
3730 ; CUR(17,40) RED "Treibstoff" TAB(60) YEL " 20 t"
3740 ; CUR(18,40) RED "Max speed" TAB(60) YEL "650 kts"
3750 ; CUR(19,40) RED "Min speed" TAB(60) YEL "150 kts"
3760 ; CUR(20,40) RED "Max groundspeed" TAB(60) YEL "182 kts"
3770 ; CUR(21,40) RED "Max vert speed" TAB(60) YEL "1500 ft/min"
3780 ; CUR(22,40) RED "Max Schub" TAB(60) YEL "450 kN"
3790 ; CUR(23,40) RED "Max gear down" TAB(60) YEL "270 kts";
3800 ! 
3810 ! 
3820 IF SYS(5)<>0 THEN GET H$ ELSE 3820
3830 IF H$<>CHR$(32) THEN 3820
3840 ! 
3850 ! ------------------------- Back to SIMUL -------------------------
3860 ! 
3870 CHAIN 'SIMUL.BAC'
3880 ! 
3890 ! ------------------- Fehlertexte -------------------------
3900 ! 
3910 DATA "Congratulation for a successfull flight",0
3920 DATA "The aircraft don't stand on the landing gear",200
3930 DATA "Release brakes before setting the thrust",1
3940 DATA "You rolled off the decision point",20
3950 DATA "You ran out of the runway from the centerline",10
3960 DATA "You ran out of the runway past end",10
3970 DATA "Landing gear down below 4oo FT",1
3980 DATA "Flaps to be retracted",1
3990 DATA "Flaps to be setted",1
4000 DATA "Thrust reduce above 15oo FTs",5
4010 DATA "Thrust reduce below 2ooo FTs",5
4020 DATA "Speed must not exeed 950 knots",2
4030 DATA "Speed must be at least 150 kts",2
4040 DATA "You flew into the ground - Congratulations",1000
4050 DATA "You touch ground before runway",50
4060 DATA "You are out of fuel",1
4070 DATA "You try to set brakes when gears are up",1
4080 DATA "Aufsetzdruck zu gross",100
4090 DATA "---",1
4100 DATA "---",1
4110 DATA "---",1
4120 DATA "---",1
4130 DATA "---",1
4140 DATA "---",1
