100 ! ----------------------------------------------
110 ! 
120 ! '           IFR - SIMULATOR     (f|r ABC806)
130 ! '           ===============
140 ! 
150 ! '                  Saved as  'SIMUL.BAC'
160 ! 
170 ! ID Computer-Systeme GmbH * Bad Honnef *
180 ! 
190 ! o2.o8.1984
200 ! 
210 ! 7'029 bytes frei
220 ! ---------------------------------------------
230 ! 
240 ON ERROR GOTO : ATTRIBUTE 1 : RANDOMIZE : EXTEND : FLOAT 
250 OUT 1,50 : OUT 34,129
260 ! 
270 ! ------------------------ Common --------------------------
280 ! 
290 COMMON Vs(19,2),Vp(9,1,5),Vpl(9),Wa(10,1),Err(23),Errtot(23),Errtot
300 COMMON Vs$(19)=3,Vp$(9)=10,Err$(23)=50
310 COMMON Nlatmin,Nlatmax,Nlatdiff,Elongmin,Elongmax,Elongdiff
320 COMMON Flag
330 ! 
340 COMMON Korr,Zgr,Kd,Kgr
350 COMMON Fra,Fhi,Fin,Fza,Fan,Fze
360 COMMON A(4),A0,A1,A2,A4,A6,A7
370 COMMON B(4),B0,B1,B2,B4,B6,B7
380 ! 
390 ! ---------------------- Dimensionierung ------------------------
400 ! 
410 DIM Vs(19,2),Vp(9,1,5),Vpl(9),Wa(10,1),Err(23),Errtot(23)
420 DIM Vs$(19)=3,Vp$(9)=10,Err$(23)=50
430 ! 
440 ! ------------- Definitionen -------------------
450 ! 
460 DEF FNZeit=VAL(MID$(TIME$,12,2))*3600+VAL(MID$(TIME$,15,2))*60+VAL(MID$(TIME$,18,2)) 
470 DEF FNErr(F)
480   OUT 34,7
490   ; CUR(24,0) BLU NWBG YEL Err$(F) CUR(22,78) BLBG " "
500   Errtot=Errtot+Err(F)
510   Errtot(F)=Errtot(F)+Err(F)
520   IF Errtot<=1000 THEN RETURN 0
530   ; CUR(24,55) BLU NWBG FLSH RED "Zuviele Fehler gemacht !" CUR(22,78) BLBG " "
540   IF SYS(5) THEN ; CUR(22,78); : GET H$ ELSE 540
550   IF H$<>CHR$(32) THEN 540
560   RETURN -1
570 FNEND 
580 DEF FNPiste(Breite,Pos1,Geschw)
581   Pos=-Pos1
590   FGPOINT 80,141,0 : FGFILL 176,150
600   IF Breite<=0 OR Pos<-20 OR Pos>20 THEN FGPOINT 102,151,0 : FGFILL 154,236
605   IF Breite<=0 THEN 810
610   IF Pos>-10 AND Pos<85 THEN FGPOINT A2+Pos-37,141,7 : FGFILL A2+Pos-38,150
620   IF Pos<10 AND Pos>-85 THEN FGPOINT A2+Pos+37,141,7 : FGFILL A2+Pos+38,150
630   IF Pos<-20 OR Pos>20 THEN 810
650   FGPOINT A2+Pos-Breite/2-1,B2,0 : FGFILL A2-26,B2-84
660   FGPOINT A2+Pos+Breite/2+1,B2 : FGFILL A2+26,B2-84
665   IF Geschw<.3 THEN Geschw=15
666   IF Geschw<1 THEN Geschw=1
670   FOR H=0 TO 14 STEP ABS(Geschw)
680     IF H<6 THEN FGPOINT A2+Pos-Breite/2,B2+1,0 : FGFILL A2+Pos+Breite/2,B2+1-H : GOTO 710
690     FGPOINT A2+Pos-Breite/2,B2,7 : FGFILL A2+Pos+Breite/2,B2+6-H
700     FGPOINT A2+Pos-Breite/2,B2+5-H,0 : FGFILL A2+Pos+Breite/2,B2+1-H
710     FOR J=0 TO 60 STEP 15
720       FGPOINT A2+Pos-Breite/2,B2-J-H,7 : FGFILL A2+Pos+Breite/2,B2-J-9-H
740       FGPOINT A2+Pos+Breite/2,B2-J-10-H : FGFILL A2+Pos-Breite/2,B2-J-14-H,0
760     NEXT J 
770     IF H>5 THEN FGPOINT A2+Pos-Breite/2,B2-60-H,7 : FGFILL A2+Pos+Breite/2,B2-74 : GOTO 800
780     FGPOINT A2+Pos-Breite/2,B2-60-H,7 : FGFILL A2+Pos+Breite/2,B2-69-H
790     FGPOINT A2+Pos-Breite/2,B2-70-H,0 : FGFILL A2+Pos+Breite/2,B2-74
800   NEXT H 
810   RETURN 0
820 FNEND 
830 DEF FNGlide
840   FGPOINT A1+3+Bilsx,B1+3,0 : FGLINE A1+3+Bilsx,B1+47
850   FGPOINT A1+3,B1+3+Bilsy : FGLINE A1+47,B1+3+Bilsy
860   Bilsx=Ilsx : Bilsy=Ilsy
870   FGPOINT A1+3+Bilsx,B1+3,3 : FGLINE A1+3+Bilsx,B1+47
880   FGPOINT A1+3,B1+3+Bilsy : FGLINE A1+47,B1+3+Bilsy
890   RETURN 0
900 FNEND 
910 DEF FNToff(F)
920   IF F=1 THEN ; CUR(24,0) BLU NWBG RED "You are cleared to takeoff" CUR(22,78) BLBG " "
930   IF F=0 THEN ; CUR(24,0) BLU NWBG RED "You have to wait" CUR(22,78) BLBG " "
940   FOR I=0 TO 5000 : NEXT I 
950   RETURN 0
960 FNEND 
970 ! 
980 ! ------------- Init flight ----------------
990 ! 
1000 K$="ECWVRAMFSPTK"+CHR$(49,50,51,52,192,193,194,195,196,197,198,199,214,215)
1010 ! 
1020 Kr=180/PI : Kts=2 : Feet=10/3 : At=2.5 : Mleer=140000 : Mtreib=20000
1030 Vmax=950 : Vmin=150 : Vmaxgr=182 : Vmaxvert=1500 : Vmaxgear=270 : Kmax=450
1040 ! 
1050 Bilsx=22 : Bilsy=22 : Bkhx1=-22 : Bkhy1=0 : Bkhx2=22 : Bkhy2=0 : Bccx=0 : Bccy=0 : Bvorfr=0
1060 Basx=0 : Basy=0 : Balx=0 : Baly=0 : Brcx=0 : Brcy=0 : Bacx=0 : Bacy=0
1070 ! 
1080 Fu(0)=9999 : Fu(1)=9999 : Fp(0)=100 : Fp(1)=100 : Ta=0 : Cc=81 : As=0 : Rc=0
1090 Tr=1 : Fa=0 : Ca=0 : Ac=0 : Ar=0 : Wh=1 : Br=3 : Fl=0 : Ct=0
1100 Tu=0 : Tu1=0 : Tu2=0 : Tu3=0 : Tu4=0 : Toff=0
1110 Ap=285 : Al=Ap : Ld=48 : Lm=43 : Gd=2 : Gm=23 : Za=0 : Ma=0
1120 Ilsx=22 : Ilsy=22 : Z=FNGlide
1130 Z1$="OUT " : Vorfr=111.2 : Z2=0 : Qdm=0 : Dme=0 : Vorind=1 : Platzind=1 : Piste=0 : Platz=0
1140 Xx=0 : Yy=0 : Ix=0 : Cv=0 : Cz=0
1150 ! 
1160 ! 
1170 ! ------------------- Menue -----------------------------
1180 ! 
1190 ; CHR$(12) : FGCTL BLK+BLK+BLK+BLK+BLK
1200 ; CUR(2,24) YEL DBLE "S I M U L - X"
1210 ; CUR(5,27) RED "IFR Flight simulator"
1220 IF Flag<>0 THEN 1250
1230 ; CUR(8,27) GRN "Einen Moment bitte !"
1240 Flag=1 : CHAIN 'SIMULHR.BAC'
1250 ; CUR(8,26) MAG ULN "Select program function" NULN " "
1260 ; CUR(10,24) CYA "1 ...... Normal cruise operations"
1270 ; CUR(11,24) CYA "2 ...... Takeoff training"
1280 ; CUR(12,24) CYA "3 ...... Cruise training"
1290 ; CUR(13,24) CYA "4 ...... Landing training"
1300 ; CUR(14,24) CYA "5 ...... Karte der VOR's"
1310 ; CUR(15,24) CYA "6 ...... Daten der Pl{tze"
1320 ; CUR(16,24) CYA "7 ...... Fehlermeldungen"
1330 ; CUR(17,24) CYA "8 ...... Instruktionen"
1340 ; CUR(18,24) CYA "9 ...... Ende"
1350 ; CUR(21,26) MAG "Your choice (1-9) >"; : GET G$
1360 IF G$<"1" OR G$>"9" THEN 1350
1370 IF G$="5" THEN GOSUB 2500 : GOTO 1190
1380 IF G$="6" THEN GOSUB 2650 : GOTO 1190
1390 IF G$="7" THEN Flag=2 : CHAIN 'SIMULHR.BAC'
1400 IF G$="8" THEN Flag=3 : CHAIN 'SIMULHR.BAC'
1410 IF G$<>"9" THEN 1460
1420 ATTRIBUTE 4
1430 ; CUR(22,0) GRN;
1440 OUT 34,1
1450 END 
1460 GOSUB 2000
1470 FOR I=0 TO 20 : Errtot(I)=0 : NEXT I : Errtot=0
1480 Z=FNPiste(0,Ix,0)
1490 Zbak1=FNZeit
1500 IF G$="1" OR G$="2" THEN GOSUB 3000 : GOSUB 4000 : GOTO 6000
1510 Tu=4 : Tu1=1 : Tu2=1 : Tu3=1 : Tu4=1 : Toff=1
1520 Al=1800 : Ap=0 : As=250 : Tr=5 : Wh=0 : Br=0 : Fl=0
1530 Ld=50 : Lm=0 : Gd=4 : Gm=0 : Vorfr=114.6 : Cc=19 : Dme=19 : Platz=4
1540 IF G$="4" THEN Lm=47 : Gm=18 : Kx=1 : Cc=45 : Dme=45
1550 GOSUB 3000 : GOTO 8000
2000 ! 
2010 ! ------------- Panel ------------------
2020 ! 
2030 ; CHR$(12) : FGCTL BLK+CYA+RED+YEL+GRN+BLU+MAG+WHT
2040 ; CUR(1,0) GRN "VOR"
2050 ; CUR(1,11) GRN "Range"
2060 ; CUR(0,0) GRN "Platz:"
2070 ; CUR(2,0) GRN "Pos N             Lat"
2080 ; CUR(3,0) GRN "    E             Long"
2090 ; CUR(4,0) ULN GRN "DME" NULN " " CUR(4,12) ULN GRN "QDM" NULN " "
2100 ; CUR(5,4) GRN "......:......"
2110 ; CUR(7,0) ULN GRN "Radio" NULN " " CUR(7,17) GRN "MHz"
2120 ; CUR(2,67) GRN "L{nge:"
2130 ; CUR(3,67) GRN "Breite:"
2140 ; CUR(4,67) GRN "Marker > <"
2150 ; CUR(7,73) RED "#"
2160 FGPOINT A1+3+Bilsx,B1+3,3 : FGLINE A1+3+Bilsx,B1+47
2170 FGPOINT A1+3,B1+3+Bilsy : FGLINE A1+47,B1+3+Bilsy
2180 ; CUR(11,0) ULN GRN "Time" NULN " "
2190 ; CUR(13,0) ULN GRN "Wheels" NULN " "
2200 ; CUR(15,0) ULN GRN "Thrust" NULN " "
2210 ; CUR(16,0) GRN "RI........M"
2220 ; CUR(18,0) ULN GRN "Flaps" NULN " "
2230 ; CUR(19,0) GRN "05`15`25`40`"
2240 ; CUR(20,0) GRN " .  .  .  ."
2250 ; CUR(21,0) ULN GRN "Triebwerke" NULN " "
2260 ; CUR(22,0) GRN "1  2  3  4"
2270 ; CUR(19,15) ULN GRN "Brakes" NULN " "
2280 ; CUR(20,18) GRN ".rel" CUR(21,18) GRN ".1" CUR(22,18) GRN ".2" CUR(23,18) GRN ".max";
2290 ; CUR(11,16) ULN GRN "Fuel" NULN " "
2300 FGPOINT A7+18,B7+31,6 : FGFILL A7+6,B7+67
2310 FGPOINT A7+32,B7+31 : FGFILL A7+20,B7+67
2320 ; CUR(12,36) RED "!" CUR(13,33) RED "---+---"
2330 ; CUR(16,16) GRN ">  < >  <"
2340 ; CUR(3,56) GRN "GPS  WUS" CUR(5,56) "]ZW  ]Z2"
2350 ; CUR(4,56) GRN "> <  > <" CUR(6,56) "> <  > <"
2360 ; CUR(17,27) GRN "(    )"
2370 ; CUR(18,36) "N" CUR(19,32) "W       E" CUR(20,36) "S"
2380 ; CUR(22,24) ULN GRN "VLF" NULN "  N           Lat"
2390 ; CUR(23,29) GRN "E           Long";
2400 ; CUR(11,47) GRN "tas" CUR(11,65) GRN "alt"
2410 ; CUR(17,47) GRN "var" CUR(17,65) GRN "acc"
2420 ; CUR(19,51) GRN "-      +" CUR(19,69) GRN "-      +"
2430 ; CUR(23,59) WHT "Errors :         Pkt.";
2440 RETURN 
2500 ! 
2510 ! ----------------------- VOR Karten -------------------------
2520 ! 
2530 FGPICTURE 0,1 : FGCTL BLK+BLU+GRN+YEL
2540 ; CHR$(12) CUR(0,20) ULN YEL "Karte der VOR's und Pl{tze" NULN " "
2550 ; CUR(24,70) MAG "E LONG" CUR(0,0) MAG "N LAT"
2560 IF Ld<Nlatmin OR Ld>Nlatmax OR Gd<Elongmin OR Gd>Elongmax THEN 2580
2570 ; CUR((Nlatmax-Ld)/Nlatdiff*23,(Gd-Elongmin)/Elongdiff*79) FLSH RED "#"
2580 FOR I=0 TO 19
2590   ; CUR((Nlatmax-Vs(I,0))/Nlatdiff*23,2+(Vs(I,1)-Elongmin)/Elongdiff*79) Vs$(I);
2600 NEXT I 
2610 IF SYS(5)<>0 THEN GET H$ ELSE 2610
2620 IF H$<>CHR$(32) THEN 2610
2630 FGCTL BLK+BLK+BLK+BLK : FGPICTURE 0,0
2640 RETURN 
2650 ! 
2660 ! ------------------------ Flugpl{tze ------------------------
2670 ! 
2680 FGPICTURE 0,2 : FGCTL BLK+MAG+YEL+RED+BLU+WHT+GRN+CYA
2690 ; CHR$(12) CUR(0,20) ULN YEL "Flugplatzdaten" NULN " "
2700 ; CUR(3,60) ULN YEL "Piste A" NULN "   " ULN YEL "Piste B" NULN " "
2710 ; CUR(5,40) GRN "QDM           :"
2720 ; CUR(6,40) GRN "Anfang        :"
2730 ; CUR(7,40) GRN "L{nge         :"
2740 ; CUR(8,40) GRN "Outer marker  :"
2750 ; CUR(9,40) GRN "Middle marker :"
2760 ; CUR(10,40) GRN "Dec. point    :"
2770 I=Platz
2780 ; CUR(1,50) MAG "<- ->"
2790 ; CUR(12,40) RED Vp$(I) "    " YEL Vpl(I) RED "feet           "
2800 ; CUR(5,60) MAG; : ; USING "###" Vp(I,0,0)
2810 ; CUR(5,70) MAG; : ; USING "###" Vp(I,1,0)
2820 ; CUR(6,60) MAG; : ; USING "#.#" Vp(I,0,1)
2830 ; CUR(6,70) MAG; : ; USING "#.#" Vp(I,1,1)
2840 ; CUR(7,60) MAG; : ; USING "#.#" Vp(I,0,2)
2850 ; CUR(7,70) MAG; : ; USING "#.#" Vp(I,1,2)
2860 ; CUR(8,60) MAG; : ; USING "#.#" Vp(I,0,3)
2870 ; CUR(8,70) MAG; : ; USING "#.#" Vp(I,1,3)
2880 ; CUR(9,60) MAG; : ; USING "#.#" Vp(I,0,4)
2890 ; CUR(9,70) MAG; : ; USING "#.#" Vp(I,1,4)
2900 ; CUR(10,60) MAG; : ; USING "#.#" Vp(I,0,5)
2910 ; CUR(10,70) MAG; : ; USING "#.#" Vp(I,1,5)
2920 ; CUR(1,52); : GET G$
2930 IF G$=CHR$(32) THEN 2970
2940 IF G$=CHR$(8) AND I>0 THEN I=I-1
2950 IF G$=CHR$(9) AND I<9 THEN I=I+1
2960 GOTO 2790
2970 FGCTL BLK+BLK+BLK+BLK+BLK : FGPICTURE 0,0
2980 RETURN 
3000 ! 
3010 ! ------------------- Schalterstellung ------------------
3020 ! 
3030 ; CUR(20,0) GRN " .  .  .  ." CUR(20,Fl*3) RED ">"
3040 ; CUR(20,17) " " CUR(21,17) " " CUR(22,17) " " CUR(23,17) " " CUR(20+Br,17) RED ">";
3050 FGPOINT A6,B6,0 : FGFILL A6+14,B6+9
3060 FGPOINT 102,136,0 : FGFILL 114,140 : FGPOINT 140,136 : FGFILL 152,140
3070 IF Wh=1 THEN 3100
3080 FGPOINT A6,B6+5,6 : FGFILL A6+14,B6+9
3090 GOTO 3180
3100 FGPOINT A6,B6,6 : FGFILL A6+4,B6+4
3110 FGPOINT A6+5,B6+5 : FGFILL A6+9,B6+9
3120 FGPOINT A6+10,B6 : FGFILL A6+14,B6+4
3130 ! 
3140 FGPOINT 102,136,6 : FGFILL 103,140 : FGPOINT 105,136 : FGFILL 106,140
3150 FGPOINT 110,136 : FGFILL 111,140 : FGPOINT 113,136 : FGFILL 114,140
3160 FGPOINT 140,136 : FGFILL 141,140 : FGPOINT 143,136 : FGFILL 144,140
3170 FGPOINT 148,136 : FGFILL 149,140 : FGPOINT 151,136 : FGFILL 152,140
3180 ; CUR(17,0) SPACE$(11) CUR(17,Tr) RED "!"
3190 ; CUR(23,0); : IF Tu1=0 THEN ; WHT "O"; ELSE ; RED "#";
3200 ; CUR(23,3); : IF Tu2=0 THEN ; WHT "O"; ELSE ; RED "#";
3210 ; CUR(23,6); : IF Tu3=0 THEN ; WHT "O"; ELSE ; RED "#";
3220 ; CUR(23,9); : IF Tu4=0 THEN ; WHT "O"; ELSE ; RED "#";
3230 IF Ta=0 THEN ; CUR(16,17) RED "##" CUR(16,22) "  " ELSE ; CUR(16,17) "  " CUR(16,22) RED "##"
3240 ; CUR(7,11) MAG; : ; USING "###.#" Vorfr
3250 FGPOINT A4+6+Bvorfr,B4+1,0 : FGLINE A4+6+Bvorfr,B4+7
3260 FGPOINT A4+6+Bvorfr,B4+12 : FGLINE A4+6+Bvorfr,B4+13
3270 FGPOINT A4+6+Bvorfr,B4+19 : FGLINE A4+6+Bvorfr,B4+29
3280 Bvorfr=(Vorfr-110)*5
3290 FGPOINT A4+6+Bvorfr,B4+1,Fze : FGLINE A4+6+Bvorfr,B4+7
3300 FGPOINT A4+6+Bvorfr,B4+12 : FGLINE A4+6+Bvorfr,B4+13
3310 FGPOINT A4+6+Bvorfr,B4+19 : FGLINE A4+6+Bvorfr,B4+29
3320 IF Vorind<>1 THEN 3490
3330 FOR I=0 TO 19
3340   IF ABS(Vorfr-Vs(I,2))<.001 THEN Vorind=2 : GOTO 3440
3350 NEXT I 
3360 Vorind=0
3370 L2=0 : G2=0 : C2=0 : Dme=0 : Qdm=0
3380 Z1$="OUT "
3390 ; CUR(1,5) SPACE$(3)
3400 ; CUR(2,6) SPACE$(6) CUR(3,6) SPACE$(6)
3410 ; CUR(4,4) SPACE$(5) CUR(4,16) SPACE$(4)
3420 ; CUR(6,0) SPACE$(20)
3430 GOTO 3490
3440 L2=Vs(I,0)
3450 G2=Vs(I,1)
3460 ; CUR(1,5) MAG Vs$(I)
3470 ; CUR(2,6) MAG; : ; USING "###.##" L2
3480 ; CUR(3,6) MAG; : ; USING "###.##" G2
3490 IF Platzind<>1 THEN 3530
3500 Platzind=0
3510 ; CUR(0,7) MAG Vp$(Platz) SPACE$(8)
3520 ; CUR(0,15) MAG; : ; USING "####" Vpl(Platz)
3530 RETURN 
4000 ! 
4010 ! ------------- Display instruments value -----------
4020 ! 
4030 ; CUR(17,15) MAG; : ; USING "#####" Fu(0)
4040 ; CUR(17,20) MAG; : ; USING "#####" Fu(1)
4050 ; CUR(18,16) MAG; : ; USING "###_%" Fp(0)
4060 ; CUR(18,21) MAG; : ; USING "###_%" Fp(1)
4070 FGPOINT A7+18,B7+31+Fp(0)*36/100 : FGFILL A7+6,B7+67,7
4080 FGPOINT A7+32,B7+31+Fp(1)*36/100 : FGFILL A7+20,B7+67
4090 ; CUR(17,41) YEL; : ; USING "###_`" Cc
4100 FGPOINT A(4),B(4),0 : FGLINE A(4)+Bccx,B(4)+Bccy
4110 FGPOINT A(4),B(4),0 : FGLINE A(4)-Bccx,B(4)-Bccy
4120 Bccx=Zgr*SIN(PI*Cc/180)
4130 Bccy=Zgr*COS(PI*Cc/180)/Korr
4140 FGPOINT A(4),B(4),Fze : FGLINE A(4)+Bccx,B(4)+Bccy
4150 FGPOINT A(4),B(4),1 : FGLINE A(4)-Bccx,B(4)-Bccy
4160 ; CUR(17,28) YEL; : ; USING "###_`" Cv
4170 ; CUR(16,48) MAG; : ; USING "###" As
4180 FGPOINT A(2),B(2),0 : FGLINE A(2)+Basx,B(2)+Basy
4190 Basx=Zgr*SIN(PI*As/400)
4200 Basy=Zgr*COS(PI*As/400)/Korr
4210 FGPOINT A(2),B(2),Fze : FGLINE A(2)+Basx,B(2)+Basy
4220 ; CUR(11,5) RIGHT$(TIME$,12)
4230 ; CUR(22,46) MAG; : ; USING "+#####" Rc
4240 FGPOINT A(1),B(1),0 : FGLINE A(1)+Brcx,B(1)+Brcy
4250 Brcx=Zgr*SIN(PI*Rc/4000)
4260 Brcy=Zgr*COS(PI*Rc/4000)/Korr
4270 FGPOINT A(1),B(1),Fze : FGLINE A(1)+Brcx,B(1)+Brcy
4280 IF Ar=0 THEN ; CUR(16,65) MAG; : ; USING "#####" Al
4290 FGPOINT A(3),B(3),0 : FGLINE A(3)+Balx,B(3)+Baly
4300 Balx=Zgr*SIN(PI*Al/20000)
4310 Baly=Zgr*COS(PI*Al/20000)/Korr
4320 FGPOINT A(3),B(3),Fze : FGLINE A(3)+Balx,B(3)+Baly
4330 ; CUR(22,64) MAG; : ; USING "+###.#" Ac
4340 FGPOINT A(0),B(0),0 : FGLINE A(0)+Bacx,B(0)+Bacy
4350 Bacx=Zgr*SIN(PI*Ac)
4360 Bacy=Zgr*COS(PI*Ac)/Korr
4370 FGPOINT A(0),B(0),Fze : FGLINE A(0)+Bacx,B(0)+Bacy
4380 ; CUR(13,73) SPACE$(5)
4390 IF Ar=0 AND Ma=0 THEN 4460
4400 ; CUR(16,65) RED; : ; USING "#####" Ar
4410 FGPOINT A(3),B(3),0 : FGLINE A(3)+Barx,B(3)+Bary
4420 IF Ma=1 THEN 4460
4430 Barx=Zgr*SIN(PI*Ar/2000)
4440 Bary=Zgr*COS(PI*Ar/2000)/Korr
4450 FGPOINT A(3),B(3),2 : FGLINE A(3)+Barx,B(3)+Bary
4460 ; CUR(22,32) MAG; : ; USING "##" Ld
4470 ; CUR(22,36) MAG; : ; USING "##.#" Lm
4480 ; CUR(23,32) MAG; : ; USING "##" Gd;
4490 ; CUR(23,36) MAG; : ; USING "##.#" Gm;
4500 ; CUR(14,30) RED; : ; USING "+##_`" Fa
4510 ; CUR(14,38) RED; : ; USING "+##_`" Ca
4520 FGPOINT A0+Bkhx1,B0+Bkhy1,4 : FGLINE A0+Bkhx2,B0+Bkhy2
4530 Bkhx1=-22*COS((Fa+Ca+Ct)/Kr) : Bkhy1=-22*SIN((Fa+Ca+Ct)/Kr)/Korr
4540 Bkhx2=22*COS((Fa-Ca-Ct)/Kr) : Bkhy2=-22*SIN((Fa-Ca-Ct)/Kr)/Korr
4550 Pkhx1=-19*COS((Fa+Ca+Ct+4)/Kr) : Pkhy1=-19*SIN((Fa+Ca+Ct+4)/Kr)/Korr
4560 Pkhx2=-19*COS((Fa+Ca+Ct-4)/Kr) : Pkhy2=-19*SIN((Fa+Ca+Ct-4)/Kr)/Korr
4570 Pkhx3=19*COS((Fa-Ca-Ct+4)/Kr) : Pkhy3=-19*SIN((Fa-Ca-Ct+4)/Kr)/Korr
4580 Pkhx4=19*COS((Fa-Ca-Ct-4)/Kr) : Pkhy4=-19*SIN((Fa-Ca-Ct-4)/Kr)/Korr
4590 IF (Al-Ap)=0 THEN Bkhx1=-22 : Bkhy1=0 : Bkhx2=22 : Bkhy2=0
4600 FGPOINT A0+Bkhx1,B0+Bkhy1,0 : FGLINE A0+Bkhx2,B0+Bkhy2
4610 FGPAINT A0+Pkhx1,B0+Pkhy1,4 : FGPAINT A0+Pkhx3,B0+Pkhy3
4620 FGPAINT A0+Pkhx2,B0+Pkhy2,1 : FGPAINT A0+Pkhx4,B0+Pkhy4
4630 ; CUR(2,74) YEL; : ; USING "##.###" Yy/Feet/1000
4640 ; CUR(3,74) YEL; : ; USING "##.###" Xx/Feet/1000
4650 IF Z1$="OUT " THEN ; CUR(1,17) RED Z1$ : GOTO 4710
4660 ; CUR(1,17) FLSH RED Z1$ STDY " "
4670 ; CUR(4,16) MAG; : ; USING "###_`" Qdm
4680 ; CUR(4,4) MAG; : ; USING "###.#" Dme
4690 ; CUR(6,0) SPACE$(20)
4700 IF Z2>0 THEN ; CUR(6,Z2+3) MAG "#"
4710 ; CUR(4,57) RED; : IF Al<300 AND Ap=0 THEN OUT 34,7 : ; "#" ELSE ; " "
4720 ; CUR(4,62) RED; : IF Ar<200 AND Ar>0 AND Wh=0 THEN OUT 34,7 : ; "#" ELSE ; " "
4730 ; CUR(6,57) RED; : IF Fa>11 THEN OUT 34,7 : ; "#" ELSE ; " "
4740 ; CUR(6,62) RED; : IF Fa>15 THEN OUT 34,7 : ; "#" ELSE ; " "
4750 ; CUR(24,0) BLU NWBG SPACE$(80) CUR(22,78) BLBG " "
4760 ; CUR(23,68) YEL; : ; USING "####" Errtot;
4770 RETURN 
5000 ! 
5010 ! ------------- Key input ---------------------------
5020 ! 
5030 Mxinp=0
5032 Z=INP(42)
5034 IF Z<>8 AND Z<>9 AND Z<>91 AND Z<>123 AND Z<>45 THEN 5180
5040 IF SYS(5) THEN GET G$ ELSE 5180
5100 IF G$=CHR$(9) THEN Ca=Ca+1
5110 IF G$=CHR$(8) THEN Ca=Ca-1
5120 IF G$="{" OR G$="[" THEN Fa=Fa-1
5130 IF G$="-" THEN Fa=Fa+1
5180 IF SYS(5)=0 THEN RETURN ELSE GET H$
5190 IF H$>="a" AND H$<"x" THEN H$=CHR$(ASCII(H$) AND 223)
5200 G=INSTR(1,K$,H$)
5210 IF G=0 THEN 5180
5220 IF G<13 THEN 5240
5230 ON G-12 GOTO 5540,5560,5580,5600,5270,5290,5320,5340,5360,5380,5400,5420,5430,5450
5240 ON G GOTO 1080,5650,5480,5720,5740,5520,5530,5780,5860,5640,5500,5630
5250 Mxinp=Mxinp+1 : GOSUB 3000
5260 IF Mxinp<8 THEN 5180 ELSE RETURN 
5270 IF Tr>0 THEN Tr=Tr-1
5280 GOTO 5250
5290 IF Tr<10 THEN Tr=Tr+1
5300 IF Toff=0 AND Tr>2 THEN Tr=2
5310 GOTO 5250
5320 IF Fl>0 THEN Fl=Fl-1
5330 GOTO 5250
5340 IF Fl<3 THEN Fl=Fl+1
5350 GOTO 5250
5360 IF Br>0 THEN Br=Br-1
5370 GOTO 5250
5380 IF Br<3 THEN Br=Br+1
5390 GOTO 5250
5400 IF Vorfr>110.09 THEN Vorfr=Vorfr-.1 : Vorind=1
5410 GOTO 5250
5420 IF Vorfr<121.91 THEN Vorfr=Vorfr+.1 : Vorind=1
5430 IF Platz>0 THEN Platz=Platz-1 : Platzind=1
5440 GOTO 5250
5450 IF Platz<9 THEN Platz=Platz+1 : Platzind=1
5460 GOTO 5250
5470 GOTO 5250
5480 IF Wh=0 THEN Wh=1 ELSE Wh=0
5490 GOTO 5250
5500 IF Ta=0 THEN Ta=1 ELSE Ta=0
5510 GOTO 5250
5520 Za=1 : GOTO 5260
5530 Ma=1 : GOTO 5260
5540 IF Tu1=0 THEN Tu1=1 ELSE Tu1=0
5550 GOTO 5610
5560 IF Tu2=0 THEN Tu2=1 ELSE Tu2=0
5570 GOTO 5610
5580 IF Tu3=0 THEN Tu3=1 ELSE Tu3=0
5590 GOTO 5610
5600 IF Tu4=0 THEN Tu4=1 ELSE Tu4=0
5610 Tu=Tu1+Tu2+Tu3+Tu4
5620 GOTO 5250
5630 GOSUB 2500 : Platzind=1 : Vorind=1 : GOSUB 2000 : GOTO 5250
5640 GOSUB 2650 : Platzind=1 : Vorind=1 : GOSUB 2000 : GOTO 5250
5650 ON ERROR GOTO 5260
5660 ; CUR(17,28); : INPUT ' 'Cv
5670 ON ERROR GOTO 
5680 Cz=1
5690 IF Cv>360 THEN Cv=Cv-360
5700 IF Cv<=0 THEN Cv=360+Cv
5710 GOTO 5260
5720 ON ERROR GOTO 5740
5730 ; CUR(7,11); : INPUT ''Vorfr
5740 ON ERROR GOTO 5760
5750 ; CUR(4,16); : INPUT ''Qdm
5760 ON ERROR GOTO 
5770 GOTO 5260
5780 IF (Al-Ap)>0 OR As<>0 THEN 5250
5790 FOR I=0 TO 1
5800   IF Fu(I)>=9999 THEN Fu(I)=9999 : Fp(I)=100 : GOTO 5840
5810   Fu(I)=Fu(I)+1000
5820   Fp(I)=Fp(I)/10
5830   GOSUB 4000
5840 NEXT I 
5850 GOTO 5250
5860 IF As>0 OR Al-Ap>0 THEN 5260
5870 IF Yy>-10 AND Yy<10 AND Xx>-10 AND Xx<10 THEN Toff=1 ELSE Toff=0
5880 Z=FNToff(Toff)
5890 GOTO 5260
6000 ! 
6010 ! ------------- Take off module ---------------------
6020 ! 
6030 Z=FNPiste(7,Ix,0)
6040 GOSUB 4000
6050 IF Tr>1 AND Br>0 THEN IF FNErr(2) THEN 1080
6060 IF Wh=0 AND Al-Ap=0 THEN IF FNErr(1) THEN 1080
6070 IF As<>0 THEN 6100
6080 GOSUB 6500
6090 GOTO 6040
6100 IF Al-Ap>0 THEN 6190
6110 IF Tr<0 AND Br=1 THEN IF FNErr(2) THEN 1080
6120 IF Yy>6800 AND Tr=10 THEN IF FNErr(3) THEN 1080 ! 6500
6130 IF Yy>10500 THEN IF FNErr(5) THEN 1080
6140 IF ABS(Xx)>100 THEN IF FNErr(4) THEN 1080
6150 IF As<150 AND Fa>0 THEN IF FNErr(12) THEN 1080
6160 GOSUB 6500
6170 GOSUB 7000
6180 GOTO 6040
6190 IF Al<1500 AND Tr<9 THEN IF FNErr(9) THEN 1080
6200 IF As<150 THEN IF FNErr(12) THEN 1080
6210 IF Al-Ap<800 THEN Z=FNPiste(6-(Al-Ap)/100,Ix,As/20*(-1)*(Yy<10500))
6220 IF Al-Ap>1500 THEN Yy=0 : Xx=0 : Ap=0 : GOTO 8000
6230 GOSUB 6500
6240 GOSUB 9000
6250 GOTO 6040
6500 ! 
6510 ! ------------- Update FU-AS-RC ---------------------
6520 ! 
6530 GOSUB 5000
6540 Zdiff=FNZeit-Zbak1 : Zbak1=FNZeit
6550 IF As>270-30*Fl AND Fl>0 THEN IF FNErr(7) THEN 1080
6560 IF As<240-30*Fl AND Al-Ap>0 THEN IF FNErr(8) THEN 1080
6570 IF Al-Ap>0 AND As<150 THEN IF FNErr(12) THEN 1080
6580 IF Wh=0 AND Br=1 THEN IF FNErr(16) THEN 1080
6590 IF (Al-Ap)>400 AND Wh=1 THEN IF FNErr(6) THEN 1080
6600 IF As>950 THEN IF FNErr(11) THEN 1080
6610 IF Al>2100 AND Tr=10 THEN IF FNErr(10) THEN 1080
6620 IF Al-Ap<0 AND Ar=0 THEN IF FNErr(13) THEN 1080
6630 IF Fu(0)=0 AND Fu(1)=0 THEN IF FNErr(15) THEN 1080
6640 Fu(Ta)=Fu(Ta)-ABS(Tu*(Tr-3*(Tr=0)-3*(Tr=10))/6*Zdiff)
6650 IF Fu(Ta)<0 THEN Fu(Ta)=0 : Tu=0 : Tu1=0 : Tu2=0 : Tu3=0 : Tu4=0 : GOSUB 3000
6660 Fp(Ta)=Fu(Ta)/100
6670 Mtot=Mleer+Fu(0)+Fu(1)
6680 As=As/Kts
6690 Ft=Tu*At/32*(Tr-1+4*(Tr=0))*(Mleer+20000)
6700 Rl=As^2*(5+ABS(Fa)+2*Fl+4*Wh)*(1-Al/40000)
6710 Rbr=As*Br^2*At*10000*(-1)*((Al-Ap)=0)
6720 As=As+((Ft-Rl-Rbr)/Mtot)*Zdiff
6730 As=As-SGN(Fa)*(As-As*COS(Fa/Kr))
6735 IF As<0 THEN As=0 : ! /
6740 Rc=As*SIN(Fa/Kr)*Feet*60*(1-Al/40000)+(120-15*Fl-As)^2*(As<120-15*Fl AND (Al-Ap)>0)
6750 Al=Al+(Zdiff*Rc/60)
6760 IF Al<Ap THEN Al=Ap-1
6770 As=As*Kts
6780 Ac=1/COS(7*Ca/Kr)-1+((Ft-Rl)/Mtot)
6790 Ct=(Fu(1)-Fu(0))/1000
6800 Cc=Cc+(Ca)*Zdiff : ! +(Ca+Ct)*
6810 IF Cc>360 THEN Cc=Cc-360
6820 IF Cc<0 THEN Cc=Cc+360
6830 RETURN 
7000 ! 
7010 ! ------------- Motion on runway --------------------
7020 ! 
7030 IF FNZeit<(Zbak2+10) THEN 7070
7040 Zbak2=FNZeit
7050 IF RND<.5 THEN Z=1 ELSE Z=-1
7060 Cc=Cc+RND*Z
7070 Da=(Cc-Vp(Platz,Piste,0))/Kr
7080 Dy=As*COS(Da)*Zdiff*1.58
7090 Dx=As*SIN(Da)*Zdiff*1.58
7100 Yy=Yy+Dy
7110 Xx=Xx+Dx
7120 Ix=FIX(Xx*22/100)
7130 Z=FNPiste(7,Ix,As/20)
7140 RETURN 
8000 ! 
8010 ! ------------- Cruise module -----------------------
8020 ! 
8030 GOSUB 4000
8040 GOSUB 6500
8050 IF Cz=0 THEN 8210
8060 Cc=INT(Cc)
8070 IF Cc=Cv THEN Cz=0 : Ca=0 : GOTO 8210
8080 IF Cv>Cc THEN Rt=1 : Cd=Cv-Cc
8090 IF Cv<Cc THEN Rt=-1 : Cd=Cc-Cv
8100 IF Cv>Cc+180 THEN Rt=-1 : Cd=360-Cv+Cc
8110 IF Cv<Cc-180 THEN Rt=1 : Cd=360-Cc+Cv
8120 IF Cd>20 THEN Ce=Rt*7 : Rt=Rt*20 : GOTO 8150
8130 IF Cd>10 THEN Ce=Rt*5 : Rt=Rt*10 : GOTO 8150
8140 IF Cd>5 THEN Ce=Rt*3 : Rt=Rt*5 ELSE Ce=Rt
8150 IF Ce<Ca THEN Ce=Ca-Ce : Ra=-1 ELSE Ce=Ce-Ca : Ra=1
8160 IF Ce>10 THEN Ra=Ra*4 : GOTO 8190
8170 IF Ce>6 THEN Ra=Ra*3 : GOTO 8190
8180 IF Ce>4 THEN Ra=Ra*2
8190 Ca=Ca+Ra
8200 Cc=Cc+Rt
8210 Wi=FIX(Al/4000)
8220 IF Wi>=10 THEN Wi=10
8230 IF RND<.5 THEN Z=1 ELSE Z=-1
8240 As=As : ! +Wa(Wi,1)*Z
8250 Cc=Cc : ! +Wa(Wi,0)*Z
8260 IF Cc>360 THEN Cc=Cc-360
8270 IF Cc<=0 THEN Cc=360+Cc
8280 GOSUB 9000
8290 Wi=0
8300 IF Vorind<>2 THEN 8030
8310 IF L1<Vs(Platz,0)+.025 AND L1>Vs(Platz,0)-.025 THEN Wi=Wi+1
8320 IF G1<Vs(Platz,1)+.025 AND G1>Vs(Platz,1)-.025 THEN Wi=Wi+1
8330 IF Al<1900 AND Al>1700 THEN Wi=Wi+1
8350 IF Al>1900 THEN Ma=0
8360 ; CUR(4,75) " "
8370 IF Wi<>3 THEN 8030
8380 IF Ma=1 THEN 8030
8400 ; CUR(4,75) RED "#"
8410 IF ABS(Cc-Vp(Platz,0,0))<5 AND Z1$<>"OUT " THEN Piste=0 : GOTO 9500
8420 IF ABS(Cc-Vp(Platz,1,0))<5 AND Z1$<>"OUT " THEN Piste=1 : GOTO 9500
8430 GOTO 8030
9000 ! 
9010 ! ------------- Situation routine -------------------
9020 ! 
9030 Vv=As*(1+(Al/40000))
9040 Dl=Zdiff*Vv/3600*COS(Cc/Kr)/60
9050 Dg=Zdiff*Vv/3600*SIN(Cc/Kr)/COS(((Lm/60)+Ld)/Kr)/60
9060 L1=Ld+(Lm/60)
9070 G1=Gd+(Gm/60)
9080 L1=L1+Dl
9090 G1=G1+Dg
9100 Ld=FIX(L1)
9110 Lm=(L1-FIX(L1))*60
9120 Gd=FIX(G1)
9130 Gm=(G1-FIX(G1))*60
9140 IF Vorind=0 THEN 9370
9150 Dl=(L2-L1)*60
9160 Dg=(G2-G1)*COS(((L1+L2)/2)/Kr)*60
9170 D=SQR((Dl^2)+(Dg^2))
9180 IF D>300 THEN Z1$="OUT " : GOTO 9370
9190 IF Dme=0 THEN 9220
9200 IF D<Dme THEN Z1$=" TO "
9210 IF D>Dme THEN Z1$="FROM"
9220 Dme=D
9230 IF G2=G1 AND L2<L1 THEN Z5=180 : GOTO 9310
9240 IF G2=G1 AND L2>L1 THEN Z5=0 : GOTO 9310
9250 Z5=ATN((L2-L1)/((G2-G1)*COS(((L1+L2)/2)/Kr)))*Kr
9260 Z5=ABS(INT(Z5))
9270 IF L2>L1 AND G1<G2 THEN Z5=90-Z5 : GOTO 9310
9280 IF L2<=L1 AND G1<G2 THEN Z5=90+Z5 : GOTO 9310
9290 IF L2<L1 AND G1>G2 THEN Z5=270-Z5 : GOTO 9310
9300 IF L2>L1 AND G1>G2 THEN Z5=270+Z5 : GOTO 9310
9310 IF Za=1 THEN Qdm=Z5 : Za=0 : Cv=Qdm : Cz=1
9320 Z6=Qdm-Z5
9330 Dd=D*SIN(Z6/Kr)
9340 Z2=7+INT(Dd)
9350 IF Z2>13 THEN Z2=13
9360 IF Z2<1 THEN Z2=1
9370 RETURN 
9500 ! 
9510 ! ------------- Landing module ----------------------
9520 ! 
9530 Qdm=Qdm(Piste)
9540 Yy=34220 : Ap=Vpl(Platz)
9550 Xx=100 : IF RND<.5 THEN Xx=-100
9560 GOSUB 4000
9570 GOSUB 6500
9580 Yy=Yy-((As*Zdiff)*COS((Cc-Vp(Platz,Piste,0))/Kr)*1.58)
9590 Xx=Xx+((As*Zdiff)*SIN((Cc-Vp(Platz,Piste,0))/Kr)*1.58)
9600 Ex=Yy*SIN(1/Kr)
9610 IF Ex<100 THEN Ex=100
9620 Ilsx=22+INT(7/Ex*Xx)*(22/7)
9630 IF Ilsx<0 THEN Ilsx=0
9640 IF Ilsx>44 THEN Ilsx=44
9650 Ar=Al-Ap
9660 Dr=Ar-(Yy*SIN(3/Kr))
9670 Er=Yy*SIN(1/Kr)
9680 IF Er<50 THEN Er=50
9690 Ilsy=22+INT(7/Er*Dr)*(22/3)
9700 IF Ilsy<0 THEN Ilsy=0
9710 IF Ilsy>44 THEN Ilsy=44
9720 Z=FNGlide
9730 IF Yy<3500 THEN Ma=0
9735 IF Yy<-9500 THEN Ma=1
9740 IF Ma=1 THEN Tr=9 : Fa=5 : Ar=0 : Ap=0 : Ilsx=22 : Ilsy=22 : Z=FNGlide : GOTO 8000
9750 ; CUR(4,75) RED; : IF Yy<4500 AND Yy>3500 THEN ; FLSH "#" ELSE ; "#"
9760 IF Yy>4000 THEN 9810
9770 Ix=FIX(Xx*22/100)
9780 IF Ix>22 THEN Ix=22
9790 IF Ix<-22 THEN Ix=-22
9800 Z=FNPiste(6-Ar/100,Ix,As/20*(-1)*(Yy<1000))
9810 IF Ar>0 THEN 9560
9820 IF Rc<-400 THEN IF FNErr(17) THEN 1080
9830 IF Rc<-800 THEN IF FNErr(13) THEN 1080
9840 IF Yy<-9500 THEN IF FNErr(5) THEN 1080
9850 IF ABS(Xx)>100 THEN IF FNErr(4) THEN 1080
9860 IF Wh=0 THEN IF FNErr(1) THEN 1080
9870 IF Yy>1000 THEN IF FNErr(14) THEN 1080
9880 IF As>0 THEN 9560
9890 Toff=0
9900 GOSUB 4000
9910 IF Rc<50 THEN Z=FNErr(0)
9920 Z=FNPiste(7,Ix,15)
9930 IF SYS(5) THEN GET G$ ELSE 9930
9940 IF G$<>CHR$(32) THEN 9930
9950 GOTO 6040
