1000 ! * LOGOUT.BAC
1005 INTEGER : EXTEND 
1010 ; '** Logout utility **'
1020 ; '   Ver X.07, 1985-02-15'
1030 ; '   Copyright 1984 Dataindustrier AB'
1040 ; 
1050 ! *  Written by Benny L|fgren
1060 ! ** ** ** ** ** ** ** ** ** ** **
1070 ! *
1080 ! * Ver date / Ver nb / Sign / Note
1090 ! * 84-06-03 /  X.00  /  BL  / Main
1100 ! * 84-06-07 /  X.01  /  BL  / Clear out entire field at logout
1110 ! * 84-06-14 /  X.02  /  BL  / Fix UFD/LFD/PFD pointer
1120 ! * 84-06-21 /  X.03  /  BL  / User code sent over in right register.
1130 ! * 84-09-05 /  X.04  /  GN  / Time messages
1140 ! * 84-09-17 /  X.05  /  GN  / Proper 'Good ***' message
1150 ! * 85-02-15 /  X.06  /  BL  / Accesible from DOS
1160 ! * 85-02-15 /  X.07  /  BL  / Talknet calls NETCALL + checks if Lux-net
1170 ! *
1180 ! ** ** ** ** ** ** ** ** ** ** **
1190 ! *
1200 ! EJECT
1210 IF FNLogout THEN ; 'LOGOUT abort'
1220 ; FNExit
1230 ! EJECT
1240 ! *****************************************
1250 ! *
1260 ! *  Logout user
1270 ! *
1280 DEF FNLogout
1290   IF FNInitialize THEN RETURN T
1300   IF FNGetstat(254) THEN RETURN T
1310   Ownname$=Username$
1320   Ownehtime.=Ehtime.
1330   Ownestime=Estime
1340   Logouttime$=FNTime$(MID$(Buff$,33,6))
1350   Logouthour=Hour
1360   FOR Usrpnt=0 TO Maxuser
1370     IF FNGetstat(Usrpnt) THEN RETURN T
1380     IF Ownname$=Username$ THEN Usrcnt=Usrcnt+1
1390   NEXT Usrpnt 
1400   Usrcnt=Usrcnt-1
1410   ! ********************************
1420   ! *
1430   ! *  Clear ufd/lfd/pfd pointers
1440   ! *
1450   POKE PEEK2(24685),0,0,0 ! Clear UFD pointer.
1460   POKE PEEK2(24695),0,0,0 ! Clear LFD pointer.
1470   POKE PEEK2(24697),0,0,0 ! Clear PFD pointer.
1480   ! ********************************
1490   ! *
1500   ! *  Clear user/password/group field
1510   ! *
1520   Buff$=SPACE$(32)
1530   Error=FNTalknet(14+64,1,0,0,0,0)
1540   IF Error THEN ; 'Error' Error 'during logout' : RETURN T
1550   ; 'User ''' Ownname$ ''' logged out at ' Logouttime$ ', elapsed time was ';
1560   IF Ownehtime.<>0. THEN ; NUM$(Ownehtime.) ':';
1570   ; RIGHT$(NUM$(100+Ownestime/60),2) '.' RIGHT$(NUM$(100+MOD(Ownestime,60)),2)
1580   IF Usrcnt THEN ; NUM$(Usrcnt) ' user';
1590   IF Usrcnt>1 ; 's';
1600   IF Usrcnt THEN ; ' still logged in under this id.'
1610   IF Logouthour>=3 AND Logouthour<10 THEN ; 'Good morning' : RETURN F
1620   IF Logouthour>=10 AND Logouthour<14 THEN ; 'Good day' : RETURN F
1630   IF Logouthour>=14 AND Logouthour<19 THEN ; 'Good afternoon' : RETURN F
1640   ; 'Good night'
1650   RETURN F
1660 FNEND 
1670 ! ********************************
1680 ! *
1690 ! *  Do communication with net central.
1700 ! *
1710 DEF FNTalknet(Fc,Sfc,B,C,D,E) LOCAL Z
1720   IF PEEK(PEEK2(24616))=201 RETURN -1 ! This is not a Lux-net!!!
1730   POKE 64961,Fc ! FC -> MSG.FC (Function code).
1740   POKE 64962,Sfc ! SFC -> MSG.SFC (Subfunction code).
1750   POKE 64963,C,B ! MSG.PDN, MSG.ERRB (BC register to/from central).
1760   POKE 64965,E,D ! Register DE to/from central.
1770   POKE 64798,255 ! TFT fake => BSAVE.
1780   Z=CALL(24615) ! NETCALL => Talk to the central.
1790   RETURN PEEK(64962)
1800 FNEND 
1810 END 
1820 ! ********************************************
1830 ! *
1840 ! *  All initialisations
1850 ! *
1860 DEF FNInitialize
1870   F=0
1880   T=NOT (F)
1890   DIM Hmonth.(12)
1900   Buff$=''
1910   POKE VAROOT(Buff$),0,1,0,PEEK(64787),0,1
1920   FOR Month=2 TO 12
1930     READ Days.
1940     Hmonth.(Month)=Hmonth.(Month-1)+Days.*24.
1950   NEXT Month 
1960   Month$='JanFebMarAprMayJunJulAugSepOctNovDec'
1970   Maxuser=32
1980   RETURN F
1990   DATA 31,28,31,30,31,30,31,31,30,31,30,31
2000 FNEND 
2010 ! ******************************************
2020 ! *
2030 ! *  Get status for user
2040 ! *
2050 DEF FNGetstat(Usernr)
2060   IF FNTalknet(14,0,0,0,0,Usernr) THEN RETURN T
2070   IF ASCII(MID$(Buff$,51,1)) AND 1=0 THEN Username$='' : RETURN F
2080   Htime.=ASCII(MID$(Buff$,33,1))*8760.+Hmonth.(ASCII(MID$(Buff$,34,1)))+(ASCII(MID$(Buff$,35,1))-1)*24.+ASCII(MID$(Buff$,36,1))
2090   Stime=ASCII(MID$(Buff$,37,1))*60+ASCII(MID$(Buff$,38,1))
2100   Username$=MID$(Buff$,40,8)
2110   Ltime$=FNTime$(MID$(Buff$,53,6))
2120   Ehtime.=Htime.-ASCII(MID$(Buff$,53,1))*8760.-Hmonth.(ASCII(MID$(Buff$,54,1)))-(ASCII(MID$(Buff$,55,1))-1)*24.-ASCII(MID$(Buff$,56,1))
2130   Estime=Stime-ASCII(MID$(Buff$,57,1))*60-ASCII(MID$(Buff$,58,1))
2140   IF Estime<0 THEN Estime=Estime+3600 : Ehtime.=Ehtime.-1.
2150   RETURN F
2160 FNEND 
2170 ! **********************************
2180 ! *
2190 ! *  Calculate a time string
2200 ! *
2210 DEF FNTime$(Timebuff$)
2220   Month=ASCII(MID$(Timebuff$,2,1))
2230   Day=ASCII(MID$(Timebuff$,3,1))
2240   Year=ASCII(MID$(Timebuff$,1,1))
2250   Hour=ASCII(MID$(Timebuff$,4,1))
2260   Minute=ASCII(MID$(Timebuff$,5,1))
2270   IF Month>12 OR Month=0 OR Day>31 OR Day=0 OR Hour>23 OR Minute>59 THEN RETURN ''
2280   Tm$=MID$(Month$,Month*3-2,3)+' '+RIGHT$(NUM$(100+Day),2)
2290   IF Year<80 THEN Year=Year+100
2300   IF MOD(Year,100)<>PEEK(-17) THEN Tm$=Tm$+'  '+NUM$(1900+Year) ELSE Tm$=Tm$+' '+RIGHT$(NUM$(100+Hour),2)+':'+RIGHT$(NUM$(100+Minute),2)
2310   RETURN Tm$
2320 FNEND 
2330 ! 
2340 ! *********************************
2350 ! *
2360 ! *  Check if user entered from DOS or BASIC
2370 ! *
2380 DEF FNChkdos LOCAL I
2390   I=PEEK2(65302)-160
2400   WHILE I<160 : IF PEEK2(I)=-212 RETURN -1
2410   IF PEEK(I)<>13 I=I+1 : WEND 
2420   RETURN 0
2430 FNEND 
2440 ! 
2450 ! **********************************
2460 ! *
2470 ! *  Get start parameter string (if any)
2480 ! *
2490 DEF FNStartpar$ LOCAL Cmdsp,I,Cmd$=160
2500   Cmdsp=PEEK2(65302)-160
2510   WHILE I<160 : I=I+1 : IF PEEK(Cmdsp+I-1)=44 GOTO 2540
2520     IF PEEK(Cmdsp+I-1)=13 RETURN '' ! No startpar string
2530   WEND : RETURN '' ! No startpar string
2540   IF PEEK(Cmdsp+I)=255 I=I+1 ! Skip DOS-entry flag
2550   WHILE I<160 : IF PEEK(Cmdsp+I)=13 GOTO 2580
2560     IF PEEK(Cmdsp+I)<32 OR PEEK(Cmdsp+I)>127 RETURN ''
2570   Cmd$=Cmd$+CHR$(PEEK(Cmdsp+I)) : I=I+1 : WEND 
2580   RETURN Cmd$
2590 FNEND 
2600 ! 
2610 ! *************************************
2620 ! *
2630 ! *  Exit to DOS or BASIC
2640 ! *
2650 DEF FNExit LOCAL A$=21,A
2660   IF FNChkdos=0 GOTO 2710 ELSE CLOSE ! We MUST close ALL files!!!
2670   A$='CMDINT  SYS'+CHR$(14,255,205,27,96,216,195,3,193)
2680   A=VARPTR(A$)
2690   IF CALL(A+11,A) ; "Can't load CMDINT.SYS, press any key for RESET!";
2700   GET A$ : IF CALL(0) REM Just a miracle would get through here...
2710   END ! End to get out of a function is ugly but...
2720 FNEND 
