100 ! ---------------------------------------------------------!
110 ! *                   S K Y P L A . B A C                  !
120 ! *                   ===================                  !
130 ! * ABC-800 Mini-planetarium. Plottar stj{rnhimlen f|r en  !
140 ! * godtycklig dag, klockslag och plats p} jorden. Bilden  !
150 ! * visar 170 grader bredd och 10-70 grader elvation.      !
160 ! * Vid programstart anger man huvudriktning, N,S,E,W      !
170 ! * Programmet placerar {ven ut sol, m}ne och planeter i   !
180 ! * den m}n de finns just d{r. Programmet nyttjar HR-kort, !
190 ! * men {r f|rberett f|r ABC-802 med videotex-grafik       !
200 ! * Efter SKYPLA i Celestial Basic av Eric Burgess (SYBEX) !
210 ! * ABC-800 version Torbj|rn Alm ABC-116                   !
220 ! * Indata tas in via meny. Inom parentes vias gammalt     !
230 ! * v{rde, som tas som default om mang|r endast RETURN     !
240 ! * Default longitud, latitud = -17.98, 59.33 = ABC-klubben!
250 ! * Version 1                                    83.09.13  !
300 ! ---------------------------------------------------------!
305 DOUBLE : FLOAT : EXTEND 
310 DIM Ra(237),Dec(237)
320 IF Kk=0 GOSUB 1000 : H=FNStardata : Kk=1 ! l{s datasatser ang. stj{rnor och planeter
330 ; CHR$(12) '            SKYPLA - ABC-800 Planetarium' : ; : ; 
340 ON ERROR GOTO 350 : ; 'Longitude(' Lo ')'; : INPUT Lo1 : Lo=Lo1 : GOTO 360
350 RESUME 360
360 ON ERROR GOTO 370 : ; 'Latitude(' FNDeg(La) ')'; : INPUT La1 : La=FNRad(La1) : GOTO 380
370 RESUME 380
380 INPUT 'Horisont (EWSN) v{lj';Hz$ : Hz=INSTR(1,'EWSN',Hz$) : IF Hz=0 THEN 380 ELSE Hz$=Az$(Hz)
390 ON ERROR GOTO 400 : ; : ; 'Nytt datum (' Y ',' M ',' D ')'; : INPUT Y,M,D : GOTO 410
400 RESUME 410
410 ON ERROR GOTO 420 : ; ' LMT...(' T1 ')'; : INPUT Tq1 : T1=Tq1 : GOTO 430
420 RESUME 430
430 ON ERROR GOTO 440 : ; 'Tidzon fr}n GMT(' Zn ')'; : INPUT Zn : GOTO 450
440 RESUME 450
450 ; 'Ber{kningen startar - haf t}lamod'
460 H=FNScreenit ! init hr-type plot
465 H=FNDefine : Sila=SIN(La) : Cola=COS(La)
470 ! H=fnini802 ! init ABC-802 type video graphics
480 K=0 : WHILE K<=236 : Tr{ff=FNAzel(Ra(K),Dec(K),Low(Hz),High(Hz))
490   IF Tr{ff FGPOINT Azi,Elv
500   ! if tr{ff setdot azitex%,elvtex%
510 K=K+1 : WEND 
520 FOR J=0 TO 8 : GOSUB 1400 : A(J+1)=A : D(J+1)=D : L(J+1)=L
530 NEXT J 
540 FOR I=1 TO 9
550   IF I<>3 GOSUB 1540 : Z(I)=Z : Q(I)=Q : V(I)=V : Al(I)=Al : Az(I)=Az
555   IF Med Elv(I)=Elv : Elvtex(I)=Elvtex : Azi(I)=Azi(I) : Azitex(I)=Azitex ELSE Elv(I)=-1
557   IF Med ; CUR(Yy,Xx) LEFT$(P$(I),1);
560 NEXT I 
570 GOSUB 1820 : IF Med Yy=(Elvtex+1)/3 : Xx=(Azitex+1)/2
590 H=FNMoon : IF Med Yy=(Elvtex+1)/3 : Xx=(Azitex+1)/2 : ; CUR(Yy,Xx);Moon$;
800 ; CUR(0,70) ' Ok!';
810 GET A$
820 GOTO 330
1000 ! Plandata  bandata f|r alla planeter
1010 RESTORE 1050
1020 DIM Pd(8,8)
1030 FOR Yy=0 TO 8 : FOR Xx=0 TO 8 : READ Pd(Yy,Xx) : NEXT Xx : NEXT Yy 
1040 ! Mercury
1050 DATA .071422,3.8484,.388301,1.34041,.3871,.07974,2.73514,.122173,.836013
1060 ! Venus
1070 DATA .027962,3.02812,.013195,2.28638,.7233,.00506,3.85017,.059341,1.33168
1080 ! Earth
1090 DATA .017202,1.74022,.032044,1.78547,1,.017,3.33929,0,0
1100 ! Mars
1110 DATA .009146,4.51234,.175301,5.85209,1.5237,.141704,1.04656,.03142,.858702
1120 ! Jupiter
1130 DATA .00145,4.53364,.090478,.23911,5.2028,.249374,1.76188,.01972,1.74533
1140 ! Saturn
1150 DATA .000584,4.89884,.105558,1.61094,9.5385,.534156,3.1257,.043633,1.977458
1160 ! Uranus
1170 DATA .000205,2.46615,.088593,2.96706,19.182,.901554,4.49084,.01396,1.28805
1180 ! Neptune
1190 DATA .000104,3.78556,.016965,.773181,30.06,.27054,2.33498,.031416,2.29162
1200 ! Pluto
1210 DATA .000069,3.16948,.471239,3.91303,39.44,9.86,5.23114,.300197,1.91812
1220 DIM P$(9)=10 : FOR I9=1 TO 9 : READ P$(I9) : NEXT I9 
1230 DATA Mercury,Venus,Earth,Mars,Jupiter,Saturn,Uranus,Neptune,Pluto
1240 READ Lo,La,Zn,Y,M,D,T1 : La=FNRad(La)
1250 FOR I=1 TO 4 : READ Az$(I) : NEXT I : FOR I=1 TO 4 : READ Hru$(I) : NEXT I 
1255 FOR I=1 TO 4 : READ Low(I),High(I) : NEXT I 
1260 RETURN 
1270 DATA -17.98,59.33,-1,1983,1,1,18
1280 DATA East,West,South,North
1290 DATA '   N      20     40     60     80  E  100    120    140    160     S'
1300 DATA '   S      200    220    240    260 W  280    300    320    340     N'
1310 DATA '   E      110    130    150    170 S  190    210    230    250     W'
1320 DATA '   W      290    310    330    350 N  10     30     50     70      E'
1330 DATA 0,180,180,360,90,270,270,90
1400 ! Calc A,D and L
1410 ! Heliocentric Logitude A
1420 A=Nd*Pd(J,0)+Pd(J,1)
1430 IF A>2*PI THEN A=((A/(2*PI))-INT(A/(2*PI)))*2*PI
1440 IF A<0 THEN A=A+2*PI : GOTO 1440
1450 C=Pd(J,2)*SIN(A-Pd(J,3))
1460 A=A+C
1470 IF A>2*PI THEN A=A-2*PI
1480 IF A<0 THEN A=A+2*PI : GOTO 1480
1490 ! Calc dist of planet from sun - D
1500 D=Pd(J,4)+Pd(J,5)*SIN(A-Pd(J,6))
1510 ! Calc dist of planet from ecliptic - L
1520 L=Pd(J,7)*SIN(A-Pd(J,8))
1530 RETURN 
1540 ! Calc Ra and Dec - R, V
1550 ! and dist from Earth - Q
1560 Z=A(3)-A(I)
1570 IF ABS(Z)>PI AND Z<0 THEN Z=Z+2*PI
1580 IF ABS(Z)>PI AND Z>0 THEN Z=Z-2*PI
1590 ! dist from Earth
1600 Q=SQR(D(I)^2+D(3)^2-2*D(I)*D(3)*COS(Z))
1610 ! Calc ang dist from Sun
1620 P=(D(I)+D(3)+Q)/2
1630 X=2*FNAco(SQR(((P*(P-D(I)))/(D(3)*Q))))
1640 ! calc RA
1650 IF Z<0 THEN R=FNDeg(A(3)+PI-X)/15
1660 IF Z>0 THEN R=FNDeg(A(3)+PI+X)/15
1670 IF R>24 THEN R=R-24 : GOTO 1670
1680 IF R<-24 THEN R=R+24 : GOTO 1680
1690 IF R<0 THEN R=R+24 : GOTO 1690
1700 ! calc Decl.
1710 IF Z<0 THEN V=SIN(A(3)+PI-X)*23.44194+FNDeg(L(I))
1720 IF Z>0 THEN V=SIN(A(3)+PI+X)*23.44194+FNDeg(L(I))
1730 Ha=T2-R
1740 IF Ha<-12 Ha=Ha+24
1750 IF Ha>12 Ha=Ha-24
1760 Ha=FNRad(Ha*15) : V=FNRad(V)
1770 Al=FNAsn(SIN(V)*Sila+COS(V)*Cola*COS(Ha))
1780 Az=FNAco((SIN(V)-Sila*SIN(Al))/(Cola*COS(Al)))
1790 IF Ha>0 Az=PI*2-Az
1800 Al=FNDeg(Al) : Az=FNDeg(Az)
1810 RETURN 
1820 ! sun data
1830 Rs=FNDeg(A(3)+PI)/15
1840 WHILE Rs>24 : Rs=Rs-24 : WEND 
1850 WHILE Rs<-24 : Rs=Rs+24 : WEND 
1860 WHILE Rs<0 : Rs=Rs+24 : WEND 
1870 Vs=SIN(A(3)+PI)*23.44194 : Hs=T2-Rs
1880 IF Hs<-12 Hs=Hs+24
1890 IF Hs>12 Hs=Hs-24
1900 Med=FNAzel(Hs,Vs,Low(Hz),High(Hz))
1940 As=Az : Hs=Ell
1950 RETURN 
2000 DEF FNStardata LOCAL K ! read star data into ra and dec
2010   ! Store Ra and Dec in Ra() and Dec()
2020   RESTORE 2060
2030   K=0 : WHILE K<=236 : READ Ra(K),Dec(K) : K=K+1 : WEND : RETURN 0
2040   ! stardata ra och dec f|r stj{rnorna
2050   ! Ursa Minor
2060   DATA 2,89,18,86,17,82,16,78,15,75,15.4,72,16.3,76
2070   ! Cepheus
2080   DATA 20.8,61,21.5,70
2090   ! Cassiopeja
2100   DATA 1.9,63,1.4,60,0.9,60,0.6,56,0.1,59
2110   ! Perseus
2120   DATA 3.3,50,3,53,3.7,48,3.1,41,3.9,40,3.9,32
2130   ! Ursa Major
2140   DATA 11,57,11,63,11.9,54,12.2,58,12.9,57,13.4,55,13.7,50
2150   ! Draco
2160   DATA 16,59,16.4,62,17.1,66,17.5,52,17.9,51,18.3,73,19.2,68
2170   ! Cepheus
2180   DATA 23.8,78,21.3,62,22.1,58,22.8,67
2190   ! Andromeda
2200   DATA 2,42,1.1,35,.6,31
2210   ! Triangulum
2220   DATA 2.1,35,1.8,29,2.2,34
2230   ! Pegasus
2240   DATA 22.7,30,0.1,29,0.2,14,21.7,10,22.2,6,22.7,10,23.0,4,23,28
2250   ! Auriga (Kusken)
2260   DATA 5.2,46,5.9,45,5.9,37,4.9,33,5,41
2270   ! Bootes
2280   DATA 14.5,39,15,40,15.3,33,14.2,20,13.9,19,14.7,27,15.5,27,15.4,29
2290   ! Corona
2300   DATA 15.6,27
2310   ! Hercules
2320   DATA 16.7,39,16.7,31,17,31,17.2,37,17.2,25,16.5,21,16.4,19
2330   ! Lyra
2340   DATA 18.7,39,18.8,33,19,32
2350   ! Cygnus (Svanen)
2360   DATA 20.7,45,20.3,40,19.8,45,20.8,34,19.5,28
2370   ! Taurus (Oxen)
2380   DATA 3.6,24,3,4,2.7,3,4.5,17,5.4,29,5.6,21,3.7,24,4.3,15,4.45,19
2390   ! Aries (V{duren)
2400   DATA 2.1,23,1.8,21,1.8,19
2410   ! Eridianus
2420   DATA 3.9,-13,3.3,-20
2430   ! Pisces
2440   DATA 1.5,-9,1.2,-10
2450   ! Cetus
2460   DATA .7,-18,1.1,-10,1.3,-9,2,2
2470   ! Orion
2480   DATA 5.9,8,5.4,8,5.75,-2,5.6,-1,5.45,0,5.8,-10,5.6,-6,5.6,10,5.5,-21,5.2,-9
2490   ! Canis Major
2500   DATA 6.7,-17,6.3,-18,6.9,-29,7.2,-27,7.4,-29
2510   ! Canis Minor
2520   DATA 7.6,7,7.4,9
2530   ! Gemini (Tvillingarna)
2540   DATA 7.6,32,7.7,28,7.3,22,6.7,25,6.6,16,6.4,22,6.3,22
2550   ! Leo
2560   DATA 10.1,12,10.1,17,10.3,20,10.3,24,11.2,20,11.2,16,11.8,15,9.8,28,9.7,26
2570   ! Cancer
2580   DATA 8.7,29,8.6,21
2590   ! Hydra
2600   DATA 9.5,-9,8.7,7,8.9,7,9.2,2,10.4,-17
2610   ! Virgo (jungfrun)
2620   DATA 11.8,2,13.4,-11,13,11,12.9,3,12.7,-1,12.3,-1,13.1,-5
2630   ! Crater
2640   DATA 10.8,-16,10.9,-18,11.3,-15,11.4,-18
2650   ! Curvus
2660   DATA 12.5,-16,12.2,-17,12.5,-23,12.2,-22
2670   ! Serpens
2680   DATA 15.8,17,15.5,10,15.7,7,15.8,5,15.8,-3
2690   ! Libra (V}gen)
2700   DATA 15.3,-9,14.8,-16
2710   ! Ophiuchus
2720   DATA 17.5,12,17.2,25,17.6,5,17.7,3
2730   ! Sagittarius (Skytten)
2740   DATA 18.3,-30,18,-30,18.4,-25,18.9,-26,19,-30,19.1,-21,18.3,-21
2750   ! Scorpio
2760   DATA 16.5,-26,16.6,-28,16.4,-24,16,-20,15.9,-22,15.9,-26,18.6,-43,16.7,-34,18.5,-37,18.7,-40,16.7,-38,22.9,-30
2770   ! Capricornus
2780   DATA 21.7,-18,21.6,-18,21.4,-22,20.8,-28,20.7,-26,20.3,-14,20.2,-12,22.9,-30
2790   ! Delphinus
2800   DATA 20.5,11,20.6,15,20.7,15,20.6,16,20.8,16
2810   ! Aquarius
2820   DATA 22.6,0,22.5,0,22.4,1,22.3,-2,22,0,21.5,-6
2830   ! Aquila (\rnen)
2840   DATA 19.8,9,19.7,10.5,19.9,6,19.1,13,18.95,14,20.1,-1
2850   ! South Polar Region ( South Cross etc.)
2860   DATA 12.2,-59,12.1,-50,12.4,-57,12.7,-59,12.3,-63
2870   DATA 14,-60,14.7,-60,14.7,-65,15.9,-63,15.1,-69,16.9,-69
2880   DATA 20.3,-57,1.7,-57,2,-62,0.4,-63,6.3,-52,6.8,-51
2890   DATA 8.8,-55,9.3,-55,9.2,-59,8.3,-60,9.1,-70,9.8,-65
2900   DATA 3.9,-75,12.5,-69,12.6,-68
2910   ! End of Star list
2920 FNEND 
3000 DEF FNAzel(Sr,Sq,Lean,Rian) LOCAL Ad,Si,Sd,Ha
3010   ! COmput Azimut & elvation fom Ra and Dec. Check if between limits.
3020   ! Return check value. Store Elvation in EL and azimut in AZ
3030   ! If within limits, return Plot Coordinates(HR) in azi% and elv%
3040   ! and 802-coordinates in azitex% and elvtex%
3050   Hd=T2-Sr : IF Hd<-12 Hd=Hd+24 ELSE IF Hd>12 Hd=Hd-24
3060   Ha=Hd*PI/12 : Sd=Sq*PI/180 : Sisd=SIN(Sd)
3070   Sl=FNAsn(Sisd*Sila-COS(Sd)*Cola*COS(Ha))
3080   Az=(Sisd-Sila*SIN(Sl))/(Cola*COS(Sl))
3085   Ell=FNDeg(Sl)
3090   IF Az>=1 Az=0 ELSE IF Az<=-1 Az=0 ELSE Az=FNAco(Az) : IF Ha>0 Az=PI*2-Az
3100   Az=FNDeg(Az) : IF Ell<10 OR Ell>70 RETURN 0
3110   Elv=3*Ell+19 : Elvtex=66-.9*Ell
3120   IF Lean<Rian IF Az<Lean OR Az>Rian RETURN 0 ELSE Azi=1.2*(Az-Lean)+10 : Azitex=.833*(Az-Lean)+6 : RETURN 1
3130   IF Az>Rian AND Az<Lean RETURN 0 ELSE IF Az<Rian Azi=1.2*Az+10 : Azitex=.833*Az+6 ELSE Azi=1.2*(Az-Lean)+10 : Azitex=.833*(Az-Lean)+6
3140   RETURN 1
3150 FNEND 
3200 DEF FNScreenit
3210   FGPOINT 0,0,0 : ; CHR$(12); : FGFILL 239,239 : FGCTL 3
3220   ; '    Date ' Y M D '   LMT..' T1 ' hrs     LST..' T2 ' hrs'
3230   ; '    ' Hz$(Hz) 'Horizon   Latitude ';ABS(FNDeg(La)); : IF La>0 ; ' North' ELSE ; ' South'
3240   ; CUR(3,0) '70' CUR(6,0) '60' CUR(9,0) '50' CUR(12,0) '40' CUR(15,0) '30' CUR(18,0) '20';
3250   FGPOINT 9,20,3 : FGFILL 9,219
3260   K=25 : WHILE K<=215 : FGPOINT 7,K : FGFILL 11,K : K=K+10 : WEND 
3270   FGPOINT 7,17 : FGFILL 211,17
3280   K=10 : WHILE K<=211 : FGPOINT K,17 : FGFILL K,9 : K=K+3 : WEND 
3290   ; CUR(23,2) Hru$(Hz);
3300   RETURN 0
3310 FNEND 
3320 DEF FNMoon
3330   Nd=Nd-.5 : Lp=255.7433 : Lz=311.1687 : Lg=178.699 : Lm=Lz+360*Nd/27.32158
3340   Lm=FNMd(Lm) : Pg=.111404*Nd+Lp : Pg=Lm-FNMd(Pg)
3350   Dr=6.2886*SIN(FNRad(Pg)) : Lm=Lm+Dr : Rq=Lm : Rm=Lm/15
3360   WHILE Rm>24 : Rm=Rm-24 : WEND 
3370   WHILE Rm<0 : Rm=Rm+24 : WEND 
3380   Al=Le-Nd*.52954 : Nd=Nd+.5 : Al=Rq-FNMd(Al) : He=5.1333*SIN(FNRad(Al))
3390   Dm=Ae+23.1444*SIN(FNRad(Rq))
3400   Hd=T2-Rm : IF Hd<-12 Hd=Hd+24 ELSE IF Hd>12 Hd=Hd-24
3410   IF Hd>12 OR Hd<-12 RETURN 0
3420   RETURN FNAzel(Hd,Dm,Low(Hz),High(Hz))
3430 FNEND 
3440 DEF FNMd(Md) LOCAL Mm
3450   Mm=Md
3460   WHILE Mm<-3600 : Mm=Mm+3600 : WEND 
3470   WHILE Mm<-360 : Mm=Mm+360 : WEND 
3480   WHILE Mm>3600 : Mm=Mm-3600 : WEND 
3490   WHILE Mm>360 : Mm=Mm-360 : WEND 
3500   RETURN Mm
3510 FNEND 
3520 DEF FNEpoch(Y,D,M) LOCAL G ! compute days from epoch
3530   G=365*Y+D+((M-1)*31)
3540   IF M<=2 G=G+INT((Y-1)/4)-INT(.75*INT((Y-1)/100+1)) ELSE G=G-INT(2.3+M*.4)+INT(Y/4)-INT((.75*INT(Y/100)+1))
3550   RETURN G
3560 FNEND 
3570 DEF FNLst(Ns,Zn,T1) LOCAL Sg,T2
3580   Sg=.065711 : T2=Sg*Ns+12.064707+(((Zn+T1)/24)*Sg)+T1
3590   WHILE T2>24 : T2=T2-24 : WEND 
3600   WHILE T2<-24 : T2=T2+24 : WEND 
3610   T2$=NUM$(T2)+'     ' : T2=VAL(LEFT$(T2$,5))
3620   RETURN T2
3630 FNEND 
3640 DEF FNDefine
3650   Rr=INT(T1) : Im=(T1-INT(T1))*60 : Es=INT((Im-INT(Im))*60)
3660   Im=INT(Im) : Lgc=(Zn*15)-Lo
3670   IF Lgc<0 Zn=Zn+Lgc/15 ELSE Zn=Zn+ABS(Lgc/15)
3680   G=FNEpoch(Y,M,D)
3690   Ns=G-722895 : T2=FNLst(Ns,Zn,T1)
3700   Nd=G-715875+T1/24
3705   Sila=SIN(La) : Cola=COS(La)
3710   RETURN 0
3720 FNEND 
3730 DEF FNAsn(X)=ATN(X/SQR(-X*X+1)) 
3740 DEF FNAco(X)=PI*.5-FNAsn(X) 
3750 DEF FNRad(X)=X*PI/180 
3760 DEF FNDeg(X)=X*180/PI 
