100 ! **********************************************************************
110 ! Program          PLANET.800       Utg}va  1.0      1984-04-26
120 ! av Torbj|rn Alm
130 ! Ins{nd av Torbj|rn Alm
140 ! F|r ABC800M ABC800C ABC802 ABC806
150 ! Testad p} ABC806
160 ! 
170 ! Screened by --"-TCP-"--
180 ! **********************************************************************
190 ! 
200 ! ----------------------------------------------------------------!
210 ! *                       P L A N E T . B A C                     !
220 ! *                       ===================                     !
230 ! * Program f|r att finna planeternas l{gen p} himlen             !
240 ! * Version 1  831007 Torbj|rn Alm ABC-116   f|r ABC-800          !
250 ! * Efter PLNTA ur Celestial BASIC av Eric Buregess  (Sybex)      !
260 ! * Programet {r till f|r att finna planeternas l{gen p} himlen en!
270 ! * given dag genom att rita upp de viktigaste stj{rnbilderna i   !
280 ! * den sektor planeten befinner sig och placera planeten d{r.    !
290 ! * Programmet kan {ven plotta konsekutiva planetl{gen med 1 eller!
300 ! * flera dygns intervall. Programmet ber{knar f|rst timvinkel och!
310 ! * deklination f|r planeten, d{refter visas den sektor (4 timmar)!
320 ! * d{r planeten befinner sig och de stj{rnbilder som {r n{rmast  !
330 ! * (fr{mst zoodiaken). Ett koordinatsystem ritas upp. Uppl|sning !
340 ! * {r 1 grad f|r timvinkel och 2 grader f|r deklination. Vid     !
350 ! * programstart erh}lls en meny f|r att v{lja objekt och program-!
360 ! * met tar in data om datum och tid.                             !
370 ! *                                                               !
380 ! ----------------------------------------------------------------!
390 FLOAT : EXTEND : DOUBLE 
400 Pi2=PI*2 : GOSUB 1800 ! l{s planet-data
410 True%=-1%
420 WHILE True%
430   K%=FNIndata%
440   K%=FNEpoch%
450   K%=FNSelect%
460   Nc%=1% : WHILE Nc%<=In%
470     K%=FNPcomp%
480     K%=FNAngdist%
490     K%=FNPlanet%(Ps%)
500     IF Nc%=1% K%=FNChart%
510     IF FNPutplan%(Ps%)<0% Nc%=In%+1%
520     IF Nc%<=In% IF Yn% K=FNPutrest%
530   Nc%=Nc%+1% : Ni=Ni+Ti : WEND 
540   ; CUR(23,60) 'Done'; : GET A$ : IF ASCII(A$)<>13 THEN 540
550 WEND 
560 END 
570 DEF FNSelect%
580   ; CHR$(12%) SPACE$(28%) ' P L A N E T . B A C'
590   ; SPACE$(28%) ' ==================='
600   ; 'Program f|r ber{kning av planetl{gen p} stj{rnhimlen'
610   ; : ; 'V{lj planet, som skall visas' : ; 
620   ; 'Merkurius(m)..1' : ; 'Venus (V).....2'
630   ; '              3 ..... Solen($)'
640   ; 'Mars(M).......4' : ; 'Jupiter(J)....5'
650   ; 'Saturnus(S)...6' : ; 'Uranus(U).....7'
660   ; 'Neptunus(N)...8' : ; 'Pluto(P)......9'
670   ; : ; 'V{lj objekt (1-9)'; : INPUT Ps$
680   Ps%=INSTR(1%,'123456789',Ps$) : IF Ps%=0% THEN 580
690   RETURN Ps%
700 FNEND 
710 DEF FNIndata%
720   ; CHR$(12%) SPACE$(28%) ' P L A N E T . B A C'
730   ; SPACE$(28%) ' ==================='
740   INPUT 'Ange datum (y,m,d)';Y,M,D
750   IF M<1 OR M>12 OR D<1 OR D>31 THEN 720
760   INPUT 'Ange tid i GMT';Ti
770   T2=Ti : D2=D : M2=M : Y2=Y ! Startdatum
780   ; 'V{lj intervall-l{ngd och antal f|r plottning'
790   ; 'Ange 1 om endast 1 plot |nskas'
800   INPUT 'Tidsintervall i dagar:';Ti : IF Ti=0 THEN In=1 : GOTO 820
810   INPUT 'Antal intervall';In% : IF In%<=0% In%=1%
820   INPUT 'Skall |vriga planeter i samma sektor plottas (Y/N)';Yn$
830   IF INSTR(1,'YyJj',Yn$) Yn%=1% ELSE Yn%=0%
840   RETURN 0%
850 FNEND 
860 DEF FNEpoch%
870   IF M<3 Dg=365*Y+((M-1)*31)+FNLeap(Y-1)+D
880   IF M>2 Dg=365*Y+D+((M-1)*31)-INT(M*.4+2.3)+FNLeap(Y)
890   Ni=Dg-715875 : Nm=Ni-.5
900   RETURN 0
910 FNEND 
920 DEF FNLeap(Y)=INT(Y/4)-INT(.75*INT((Y/100)+1)) 
930 DEF FNPcomp% LOCAL J%,A,C,D,S,L
940   J%=0% : WHILE J%<=8%
950     A=Ni*Pd(J%,0%)+Pd(J%,1%) : IF A>Pi2 A=((A/Pi2)-INT(A/Pi2))*Pi2
960     WHILE A<0 : A=A+Pi2 : WEND 
970     C=Pd(J%,2%)*SIN(A-Pd(J%,3%)) : A=A+C
980     WHILE A>Pi2 : A=A-Pi2 : WEND 
990     WHILE A<0 : A=A+Pi2 : WEND 
1000     Ds=Pd(J%,4%)+Pd(J%,5%)*SIN(A-Pd(J%,6%))
1010     L=Pd(J%,7%)*SIN(A-Pd(J%,8%))
1020     A(J%+1%)=A : D(J%+1%)=Ds : L(J%+1%)=L
1030   J%=J%+1% : WEND 
1040   RETURN 0
1050 FNEND 
1060 DEF FNAngdist% LOCAL I%,Z,Q
1070   I%=1% : WHILE I%<=9% : Jj%=(I%<>3%)
1080     WHILE Jj% : Jj%=0%
1090       Z=A(3%)-A(I%)
1100       IF ABS(Z)>PI AND Z<0 Z=Z+Pi2
1110       IF ABS(Z)>PI AND Z>0 Z=Z-Pi2
1120       Q=SQR(D(I%)^2%+D(3%)^2%-2*D(I%)*D(3%)*COS(Z))
1130       Pp=(D(I%)+D(3%)+Q)*.5
1140       X=2*FNAco(SQR(((Pp*(Pp-D(I%)))/(D(3%)*Q))))
1150       IF Z<0 R=FNDeg(A(3%)+PI-X)/15
1160       IF Z>0 R=FNDeg(A(3%)+PI+X)/15
1170       WHILE R>24 : R=R-24 : WEND 
1180       WHILE R<0 : R=R+24 : WEND 
1190       IF Z<0 V=SIN(A(3%)+PI-X)*23.44194+FNDeg(L(I%))
1200       IF Z>0 V=SIN(A(3%)+PI+X)*23.44194+FNDeg(L(I%))
1210       X=FNDeg(X)
1220       Q(I%)=Q : X(I%)=X : R(I%)=R : V(I%)=V
1230     WEND 
1240   I%=I%+1% : WEND 
1250   RETURN 0%
1260 FNEND 
1270 DEF FNPlanet%(Ps%)
1280   R(3%)=(A(3%)*180/PI-180)/15
1290   WHILE R(3%)<0 : R(3%)=R(3%)+24 : WEND 
1300   V(3%)=(SIN(A(3%)-PI))*23.44194
1310   Ra=R(Ps%) : De=V(Ps%)
1320   RETURN 0%
1330 FNEND 
1340 DEF FNChart% LOCAL C1,C2,C3%,C4%
1350   Koff=0 : IF Ra>12 Koff=12
1360   Rr=INT(Ra/4)*4
1370   ; CUR(20%,0%) 'Timvinkel f|r  ' P$(Ps) ' {r ';
1380   ; USING '##.###' Ra : ; 'Declination {r '; : ; USING '###.##' De
1390   ; 'Tryck RETURN f|r att visa planetens l{ge p} stj{rnhimlen' : GET A$
1400   R3=Ra : Dc=De : P$=Pp$(Ps) : Ch=1+INT(Ra/4)
1410   IF Ra>=12 H%=FNLowsc%(INT(Ra/4)*4) ELSE H=FNHihsc%(INT(Ra/4)*4)
1420   ON Ch RESTORE 2300,2390,2460,2530,2590,2650
1430   READ Nconst% ! antal konstellationer i sektor
1440   Iconst%=1% : WHILE Iconst%<=Nconst%
1450     READ Namn$,C1,C2 : C3%=(28-C2-Koff)*.5 : C4%=79-20*(C1-Rr) : IF C4%<0% C4%=1%
1460     ; CUR(C3%,C4%) Namn$;
1470     READ Nstars% : Istar%=1% : WHILE Istar%<=Nstars%
1480       READ C1,C2 : C3%=(28-C2-Koff)*.5 : C4%=79-20*(C1-Rr) : IF C4%<0% C4%=1%
1490     ; CUR(C3%,C4%) '*'; : Istar%=Istar%+1% : WEND 
1500   Iconst%=Iconst%+1% : WEND 
1510   RETURN 0%
1520 FNEND 
1530 DEF FNPutplan%(Ks%)
1540   Ch1=1+INT(R(Ks%)/4) : IF Ch<>Ch1 RETURN -1%
1550   C3%=(28-V(Ks%)-Koff)*.5 : C4%=79-20*(R(Ks%)-Rr)
1560   ; CUR(C3%,C4%) Pp$(Ks%);
1570   RETURN 0
1580 FNEND 
1590 DEF FNLowsc%(Rax%)
1600   Rad%=0% : ; CHR$(12%); : H%=FNLuft%(3%) : H%=FNLinje%('+10','--')
1610   H%=FNLuft%(4%) : H%=FNLinje%('0','- ')
1620   H%=FNLuft%(4%) : H%=FNLinje%('-10','--')
1630   H%=FNLuft%(4%) : H%=FNLinje%('-20','--')
1640   H%=FNLuft%(4%) : H%=FNLinje%('-30','--')
1650   ; CUR(8%,0%) NUM$(Rax%+4%) CUR(8%,18%) NUM$(Rax%+3%) CUR(8%,38%) NUM$(Rax%+2%);
1660   ; CUR(8%,58%) NUM$(Rax%+1%) CUR(8%,78%) NUM$(Rax%);
1670   RETURN 0%
1680 FNEND 
1690 DEF FNHihsc%(Rax%)
1700   Rad%=0% : ; CHR$(12%); : H%=FNLinje%('+30','--')
1710   H%=FNLuft%(4%) : H%=FNLinje%('+20','--')
1720   H%=FNLuft%(4%) : H%=FNLinje%('+10','--')
1730   H%=FNLuft%(4%) : H%=FNLinje%('0','- ')
1740   H%=FNLuft%(4%) : H%=FNLinje%('-10','--')
1750   H%=FNLuft%(3%)
1760   ; CUR(15%,0%) NUM$(Rax%+4%) CUR(15%,18%) NUM$(Rax%+3%) CUR(15%,38%) NUM$(Rax%+2%);
1770   ; CUR(15%,58%) NUM$(Rax%+1%) CUR(15%,78%) NUM$(Rax%);
1780   RETURN 0%
1790 FNEND 
1800 ! Plandata  bandata f|r alla planeter
1810 RESTORE 1850
1820 DIM Pd(8,8)
1830 FOR Yy%=0% TO 8% : FOR Xx%=0% TO 8% : READ Pd(Yy%,Xx%) : NEXT Xx% : NEXT Yy% 
1840 ! Mercury
1850 DATA .071422,3.8484,.388301,1.34041,.3871,.07974,2.73514,.122173,.836013
1860 ! Venus
1870 DATA .027962,3.02812,.013195,2.28638,.7233,.00506,3.85017,.059341,1.33168
1880 ! Earth
1890 DATA .017202,1.74022,.032044,1.78547,1,.017,3.33929,0,0
1900 ! Mars
1910 DATA .009146,4.51234,.175301,5.85209,1.5237,.141704,1.04656,.03142,.858702
1920 ! Jupiter
1930 DATA .00145,4.53364,.090478,.23911,5.2028,.249374,1.76188,.01972,1.74533
1940 ! Saturn
1950 DATA .000584,4.89884,.105558,1.61094,9.5385,.534156,3.1257,.043633,1.977458
1960 ! Uranus
1970 DATA .000205,2.46615,.088593,2.96706,19.182,.901554,4.49084,.01396,1.28805
1980 ! Neptune
1990 DATA .000104,3.78556,.016965,.773181,30.06,.27054,2.33498,.031416,2.29162
2000 ! Pluto
2010 DATA .000069,3.16948,.471239,3.91303,39.44,9.86,5.23114,.300197,1.91812
2020 DIM P$(9%)=10% : FOR I9%=1% TO 9% : READ P$(I9%) : NEXT I9% 
2030 DATA Merkurius,Venus,Solen,Mars,Jupiter,Saturnus,Uranus,Neptunus,Pluto
2040 DIM Pp$(9%)=10% : FOR I9%=1% TO 9% : READ Pp$(I9%) : NEXT I9% 
2050 DATA m,V,$,M,J,S,U,N,P
2060 RETURN 
2070 DEF FNLuft%(N%) LOCAL I%
2080   I%=1% : WHILE I%<=N%
2090     ; CUR(Rad%,0%) '.' TAB(20%) '.' TAB(40%) '.' TAB(60%) '.' TAB(80%) '.';
2100   I%=I%+1% : Rad%=Rad%+1% : WEND 
2110   RETURN 0%
2120 FNEND 
2130 DEF FNLinje%(A$,B$) LOCAL I%
2140   ; CUR(Rad%,0%); : I%=1% : WHILE I%<=40% : ; B$; : I%=I%+1% : WEND 
2150   Rad%=Rad%+1% : IF A$='0' RETURN 0%
2160   ; CUR(Rad%-1%,0%) A$ CUR(Rad%-1%,17%) A$ CUR(Rad%-1%,37%) A$;
2170   ; CUR(Rad%-1%,57%) A$ CUR(Rad%-1%,79%-LEN(A$)) A$;
2180   RETURN 0%
2190 FNEND 
2200 DEF FNAco(X)=-ATN(X/SQR(-X*X+1))+PI*.5 
2210 DEF FNDeg(X)=X*180/PI 
2220 DEF FNRad(X)=X*PI/180 
2230 DEF FNPutrest% LOCAL I%
2240   I%=1% : WHILE I%<=9%
2250     IF I%<>Ps% K%=FNPutplan%(I%)
2260   I%=I%+1% : WEND 
2270   RETURN 0%
2280 FNEND 
2290 ! --------  Ra 0 - Ra 4 ---------------------
2300 DATA 7
2310 DATA Pegasus,3,26,2,.1,29,.2,14
2320 DATA Plejades,3.5,22,2,3.6,24,3.2,24
2330 DATA Aries,2,20,3,2.1,23,1.8,21,1.8,19
2340 DATA Taurus,3,5,2,3,4,2.7,3
2350 DATA Eridianus,4,-15,2,3.9,-13,3.3,-20
2360 DATA Pisces,1.4,-8,2,1.5,-9,1.2,-10
2370 DATA Cetus,1,-16,1,0.7,-18
2380 ! -------Ra 4 - Ra 8 ---------------
2390 DATA 5
2400 DATA Orion,6,6,8,5.9,8,5.4,8,5.7,-2,5.6,-1,5.5,0,5.8,-10,5.6,-6,5.2,-9
2410 DATA Sirius,6.5,-16,2,6.7,-17,6.3,-18
2420 DATA Taurus,4.5,23,3,4.5,17,5.4,29,5.6,21
2430 DATA Procryon,7.6,5,2,7.6,7,7.4,9
2440 DATA Gemini,7.5,26,7,7.5,30,7.7,28,7.3,22,6.7,25,6.6,16,6.4,22,6.3,22
2450 ! -------Ra 8 - Ra 12 ------------------
2460 DATA 5
2470 DATA Leo,10,22,9,10.1,12,10.1,17,10.3,20,10.3,24,11.2,20,11.2,16,11.8,15,9.8,28,9.7,26
2480 DATA Cancer,8.7,25,2,8.7,29,8.6,21
2490 DATA Hydra,9.5,5,5,9.5,-9,8.7,7,8.9,7,9.2,2,19.4,-17
2500 DATA Virgo,11.8,4,1,11.8,2
2510 DATA Crater,10.8,-14,4,10.8,-16,10.9,-18,11.3,-15,11.4,-18
2520 ! ---------- Ra 12 - Ra 16 -------------------
2530 DATA 4
2540 DATA Virgo,13.5,8,6,13.4,-11,13,11,12.9,3,12.7,-1,12.3,-1,13.1,-5
2550 DATA Corvus,12.5,-20,4,12.5,-16,12.2,-17,12.5,-23,12.2,-22
2560 DATA Serpens,15.8,14,5,15.8,17,15.5,10,15.7,7,15.8,5,15.8,-3
2570 DATA Libra,15,-12,2,15.3,-9,14.8,-16
2580 ! ------------ Ra 16 - Ra 20 ---------------
2590 DATA 4
2600 DATA Aquila,19.5,12,5,19.7,10,19.8,9,19.9,8,19.0,13,18.9,14
2610 DATA Ophiocus,17.5,16,3,17.5,12,17.6,5,17.7,3
2620 DATA Sagittarius,18.5,-24,7,18.3,-30,18,-30,18.4,-25,18.9,-26,19.0,-30,19.1,-21,18.3,-21
2630 DATA Scorpio,16.5,-18,6,16.5,-26,16.6,-28,16.4,-24,16,-20,15.9,-22,15.9,-26
2640 ! --------- Ra 20 - Ra 24 -----------------
2650 DATA 5
2660 DATA Formalhaut,22.9,-28,1,22.9,-30
2670 DATA Capricornus,21.7,-20,7,21.7,-18,21.6,-18,21.4,-22,20.8,-28,20.7,-26,20.3,-14,20.2,-12
2680 DATA Delphinus,20.5,18,5,20.5,11,20.6,15,20.7,15,20.6,16,20.8,16
2690 DATA Pegasus,21.7,8,4,21.7,10,22.2,6,22.7,10,23,4
2700 DATA Aquarius,22.6,4,6,22.6,0,22,5,0,22.4,1,22.3,-2,22,0,21.5,-6
2710 ! -------------------------------------------------------
