1 REM Ins{nd av Kristoffer Eriksson <5357>    1987-12-11 19.47.16 (KERMIT)
; Fil: WORDSPLT.ASM
; Av:  Kristoffer Eriksson, "SKE" <5357>, 1987.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
; 1.00 / 87-08-02 / SKE  /
;
; Dela upp en str{ng i enskilda ord. Mest l{mpad f|r filnamn i kommandorad.
; Str{ngens eventuella slut markeras av CR, och semikolon markerar slutet av
; den del av str{ngen som f}r anv{ndas.
; Ordet kan var omgivet av " eller ', och kan f|ljas av ett kommatecken.
; Annars markerar blanktecken, semikolon (;) eller CR slutet av ordet.
; Komma, ", ', och blanktecken l{ses f|rbi f|re retur fr}n rutinen.
;
; In: HL = Pekare till b|rjan av str{ng.
; Ut: HL = Pekare till f|rsta tecken i ordet,
;     BC = Antal tecken i ordet,
;     DE = Pekare till f|rsta ickeblanka tecken efter ord och ev separatortkn.
;      A = Det tecken DE pekar p}.
;
; Exempel:
; Instr{ng (HL)         Ord (HL,BC)   N{sta tecken (DE)
; "abcde",fgh...        abcde         f
; "abcde" , fgh...      abcde         f
; 'abcde' fgh...        abcde         f
; 'abcde<CR>            abcde         <CR>
; abcde fgh...          abcde         f
; abcde<CR>             abcde         <CR>
; abcde <CR>            abcde         <CR>
; abcde;...             abcde         ;
; "abcde" ;...          abcde         ;

            EXTERN WordSplit

SkipSp:     = 24

WordSplit:  LD     BC,0               ; BC r{knar antal tecken i ordet.
            LD     A,(HL)
            CP     "'"
            JR Z   Citat
            CP     '"'
            JR Z   Citat
            PUSH   HL                 ; Ordet omges ej av " eller ', s} aktu-
SearchSp:   CP     " "                ; ellt tecken {r ordets f|rsta. Leta
            JR Z   ex.Komma           ; efter blank, komma,  semikolon eller
            CP     ","                ; CR som avslutande tecken.
            JR Z   ex.Sp
            CP     ";"
            JR Z   Exit
            CP     13
            JR Z   Exit
            INC    HL
            INC    BC
            LD     A,(HL)
            JR     SearchSp

Citat:      LD     E,A                ; Ordet {r citerat. Leta d{rf|r efter
            INC    HL                 ; det avslutande tecknet eller CR.
            PUSH   HL                 ; Adress till ordets f|rsta tecken.
SearchCit:  LD     A,(HL)
            CP     E
            JR Z   ex.Komma
            CP     13
            JR Z   Exit
            INC    HL
            INC    BC
            JR     SearchCit

ex.Komma:   CALL   SkipSp             ; Hoppa |ver blanka och ev kommatecken.
            CP     ","
            JR NZ  Exit
ex.Sp:      CALL   SkipSp             ; Hoppa |ver blanka efter kommatecken.
Exit:       EX     DE,HL              ; DE <- N{sta tecken
            POP    HL                 ; HL <- F|rsta tecken
            RET
