1 REM Ins{nd av Kristoffer Eriksson <5357>    1988-06-21 19.07.55 (KERMIT)
; Fil: WNDWRITE.ASM 
; Av: Kristoffer Eriksson, "SKE" <5357>. 
; 
;-Ver--/-Datum----/-Sign-/-Kommentar---------------------------------- 
; X.00 / 84-12-03 / SKE  / WNDWRITE 
; 1.00 / 85-03-27 / SKE  / 
; 2.00 / 88-04-17 / SKE  / Mer kommentarer. <ESC>s, <ESC>t. PUT p} WIDTH 40 
;                          h{nger sig inte. PUT har nu en egen huvudloop. 
;                          ]terst{llning av attribut vid radbyte, AttrWrap. 
; 
; PRINT & PUT f|r f|nster. 
; 
; S{rskilda koder vid PRINT: 
;    <ESC> = r k     Placera mark|ren. 
;    <ESC> R         Rita om ramen. 
;    <ESC> S nl nh   Lagra f|nsterinneh}ll inkl ram i str{ng. nl & nh anger 
;                    VAROOT (L}g,H|g byte). P} 806 lagra {ven attribut. 
;    <ESC> T nl nh   Skriv tillbaks str{ng lagrad av <ESC> S. 
;    <ESC> s nl nh   Lagra f|nsterinneh}llet, alltid utan attribut. 
;    <ESC> t nl hh   Skriv tillbaks str{ng lagrad av <ESC> s. 
;    <8>             <-         (Backspace)         (Kan scrolla bak}t) 
;    <9>             ->         (Fram}t)        Ny! (Kan scrolla fram}t) 
;    <10>            LF         (Rakt ned)          (Kan scrolla fram}t) 
;    <11>            Reverse LF (Rakt upp)      Ny! (Kan scrolla bak}t) 
;    <12>            FF         (Rensa f|nstret, mark|ren till HOME) 
;    <13>            CR         (Till b|rjan av raden) 
; 
; Dessutom alla koder som PROM-rutinerna tar hand om. 


            EXTERN WndWr#Put, WndWr.1, CrtWr.1, AttrWrap 

; In: HL = Textbuffert, BC = Antal tecken. 
; Beh|ver inte bevara n}gra register. Returstatus i A/Carry. 

WndWr#Put:  BIT   1,(IX+LU.FC)     ; Anv{nd avsedd drivrutin. 
            JR Z  WndWrite 
            ;(JR  WndPut) 


; Det finns olika slags PUT i PROM-rutinerna p} olika 800-modeller, s} vi f}r 
; hitta p} n}gon egen l{mplig variant. 
; 
; Den h{r skriver in tecknen direkt i bildminnet, utan tolkning av n}gon 
; betydelse hos tecknen, s} som 806 g|r, och i motsats till 800 och 802. 
; Den tar inte h{nsyn till EL eller DBLE. Det attribut som anv{nds {r det 
; som senast anv{nts i f|nstret. N{r raden {r full, f}r man ny rad, med ev 
; }terst{llning av attributen om inte ATTRIBUTE 4 g{ller f|r f|nstret. 
; 
; Vid WIDTH 40 skrivs varannan byte i bildminnet, utan |vriga bytes p}verkas, 
; och EL-attribut s{tts inte. P} 802 d{r hela sk{rmen st{lls i dubbel tecken- 
; bredd p} en g}ng, ser det antagligen ok ut. P} 800 och 806 ser man utskrift 
; p} varannan enkelbreddsposition. 
; 
; PROM-PUT p} 806 skriver enkelbreddstecken p} varje position oavsett WIDTH. 
; Dock |kar den positonsr{knaren f|r varje tecken, s} forts{tts utskriften 
; sedan i WIDTH 40 tar den vid dubbelt s} l}ngt bort som PUT slutade. 

WndPut:     LD    A,B 
            OR    C 
            RET   Z                ; Slut p} tecken => klart. No Carry. 
            PUSH  HL 
            PUSH  BC 
            CALL  NewLine? 
            CALL  CrtPos           ; DE <- Absolut bildsk{rmsposition. 
            CALL  CrtAdr           ; HL <- Adress med h{nsyn till WIDTH 40/80. 
            EX    DE,HL 
            POP   BC 
            POP   HL 
            LDI                    ; Skriv tecknet. 
            INC   (IX+LU.COL)      ; \ka positionen. 
            JR    WndPut 


; Huvudloop f|r PRINT. Anropar WndWr.1 f|r varje enskilt tecken, s} varje 
; delrutin l{tt kan komma tillbaks till huvudloopen med RET. Loopen kan inte 
; PUSH:a BC och HL runt anropet till WndWr.1, f|r tolkningen av ESC-sekvenser 
; beh|ver l{sa ytterligare tecken fr}n bufferten. 
; 
; Alla synliga tecken och maskinberoende styrtecken skrivs ut av 
; PROM-rutinerna, som f}r applicera r{tt attribut och tolkning p} dem. 
; Formatteringstecken som ju p}verkar data i LU-blocket tolkas av rutinerna 
; h{r nedan. 
; 
; Vid utskrift ev tecken i EL- och DBLE-mode (utom WIDTH 40), vilket bara kan 
; ske p} 806, kan h|gra eler undre halvan av dessa skrivas ut utanf|r f|nstret 
; om de blir olyckligt placerade. I v{rsta fall kan hela sk{rmen scrolla upp 
; en rad om DBLE skrivs l{ngst ned p} den. Att f|rebygga detta, kr{ver rutiner 
; som vet vilken maskin som anv{nds, vilka tecken som verkligen skrivs och 
; vilka som inte skrivs vilket varierar med ATTRIBUTE och tecknets egen 
; inverkan p} EL/DBLE-mode, vet om f|nstret alls rymmer stora tecken, och 
; liknande. Det blir s} komplicerat att jag har utel{mnat det i denna version. 
; I vilket fall som hellst, s} kan skadan {nd} inte n} l{ngre ut {n till 
; f|nstrets egen ram (utom vid scrollning). 

WndWrite:   LD    A,B 
            OR    C 
            RET   Z                ; Slut p} tecken => klart. No Carry. 
            LD    A,(HL)           ; Tecknet att behandla. 
            INC   HL 
            DEC   BC 
            CALL  WndWr.1          ; Behandla det. 
            JR    WndWrite 

; Skriv tecknet i A. 
; Tidigare anv{ndes denna rutin {ven av WNDINPUT. 

WndWr.1:    CP    8 
            JR Z  Pr.BS 
            CP    9 
            JR Z  Pr.FW 
            CP    10 
            JP Z  LFSCR            ; Ned 
            CP    11 
            JR Z  Pr.RLF 
            CP    12 
            JR Z  Pr.FF 
            CP    27 
            JP Z  Pr.ESC 
            CP    13 
            JR NZ Pr.X1 
Pr.CR:      LD    (IX+LU.COL),0    ; <-<- 
            RET 
Pr.FW:      INC   (IX+LU.COL)      ; -> 
            JP    NewLine? 
Pr.BS:      DEC   (IX+LU.COL)      ; <- 
            RET P 
            LD    A,(IX+LU.WID) 
            DEC   A 
            LD    (IX+LU.COL),A 
Pr.RLF:     CALL  AttrWrap 
            DEC   (IX+LU.LINE)     ; Upp 
            RET P 
            LD    (IX+LU.LINE),0 
            PUSH  HL 
            PUSH  BC 
            CALL  BackScroll 
            POP   BC 
            POP   HL 
            RET 
Pr.FF:      PUSH  BC               ; Blank sk{rm 
            PUSH  HL 
            CALL  AttrWrap 
            CALL  CLS 
            POP   HL 
            POP   BC 
            LD    (IX+LU.LINE),0 
            JR    Pr.CR 

; A (och (HL-1)) {r inte n}got tecken vi beh|ver ta hand om sj{lva. Anv{nd 
; PROM-rutinerna f|r utskrift, och justera positionen efter}t. Tecknet kan ta 
; 0 (styrtecken i ATTRIBUTE 1), 1 (vanligt tecken) eller 2 (EL) positioner. 
; Utskrift i WIDTH 40 tar bara 1 position. 

Pr.X1:      CALL  NewLine? 
            CALL  CrtPos 
            PUSH  DE 
            DEC   HL 
            CALL  CrtWr.1 
            INC   HL 
            POP   DE 
            LD    A,(CRT.LU+LU.COL) 
            SUB   E 
            RET Z                  ; Tecknet tog ingen plats. 
            INC   (IX+LU.COL)      ; Tecknet tog minst 1 position. 
            CP    2 
            RET NZ                 ; F|r s{kerhets skull, anta att om tecknet 
            INC   (IX+LU.COL)      ; inte tog exakt 0, 1 eller 2 pos, s} |ka 
            RET                    ; med bara 1. 


; ESC-kod har p}tr{ffats. Tolka den efterf|ljande sekvensen. Om ingen 
; fullst{ndig sekens ing}r i den aktuella str{ngen, struntar vi i den. 

Pr.ESC:     LD    A,B 
            OR    C 
            RET Z                  ; Ensam ESC-kod utan funktionsval. 
            LD    A,(HL) 
            INC   HL 
            DEC   BC 
            CP    "R"              ; "<ESC>R" har inga parametrar. 
            JR Z  ESC.Ram 

            ; Resterande sekvenser har allihop tv} bytes parametrar. 

            EX    DE,HL 
            LD    HL,-2 
            ADD   HL,BC 
            EX    DE,HL 
            RET   NC               ; Parametrar saknas.
            LD    E,(HL)           ; E <- F|rsta parametern. 
            INC   HL 
            DEC   BC 
            LD    D,(HL)           ; D <- Andra parametern. 
            INC   HL 
            DEC   BC 

            SUB   "S"              ; CP "S",   No Carry. 
            JR Z  ESC.Sav          ; Spara med ev attribut. 
            DEC   A                ; CP "T",   No Carry fr}n SUB. 
            JR Z  ESC.Res          ; ]terst{ll med ev attribut. 
            CP    "="-"T"          ; CP "=" 
            JR Z  ESC.CurPos
            SUB   "s"-"T"          ; CP "s" 
            SCF                    ; Carry -> Spara utan attribut. 
ESC.Sav:    JP Z  WndSave 
            DEC   A                ; CP "t" 
ESC.Res:    JP Z  WndRestore       ; Carry fr}n ovan->]terst{ll utan attribut. 
            RET                    ; Ok{nd ESC-sekvens. 

ESC.CurPos: LD    A,E              ; "<ESC>=<r><k>" Placera mark|ren. 
            LD    E,(IX+LU.HIGHT) 
            CALL  CUR.C1           ; Kolla rad-parametern. 
            LD    (IX+LU.LINE),A 
            LD    A,D 
            LD    E,(IX+LU.WID) 
            CALL  CUR.C1           ; Kolla kolumn-parametern. 
            LD    (IX+LU.POS),A 
            RET 

CUR.C1:     SUB   32               ; Kolla mark|rparameter. V{rdet i A har 
            JR NC  CUR.CX1         ; ett offset p} 32, och ska kollas mot 
            XOR   A                ; maxv{rdet i E, och min-v{rdet 0. 
CUR.CX1:    CP    E 
            RET   C 
            LD    A,E 
            DEC   A 
            RET 

ESC.Ram:    PUSH  HL               ; "<ESC>R" Omritning av ramen. 
            PUSH  BC 
            CALL  RitaRam 
            POP   BC 
            POP   HL 
            RET 


; Kolla om aktuell kolumn |verskrider h|gerkanten p} f|nstret. Om s} {r 
; fallet, s} g} ned till b|rjan av n{sta rad,med eventuell scrollning. 

NewLine?:   LD    A,(IX+LU.COL) 
            CP    (IX+LU.WID) 
            RET C 
            LD    (IX+LU.COL),0 

; G} rakt ned till n{sta rad, med eventuell scrollning och }terst{llning av 
; attribut p} 806. 

LFSCR:      CALL  AttrWrap 
            INC   (IX+LU.LINE) 
            LD    A,(IX+LU.HIGHT) 
            DEC   A 
            CP    (IX+LU.LINE) 
            RET NC 
            LD    (IX+LU.LINE),A 
            PUSH  HL 
            PUSH  BC 
            CALL  Scroll 
            POP   BC 
            POP   HL 
            RET 

; Skriv ut det tecken HL pekar p}, via PROM-rutinerna, p} fysisk rad D, 
; kolumn E. M}ste bevara alla register utom A. Anropas {ven f|r ramritning 
; i WNDOPEN. 

CrtWr.1:    LD    (CRT.LU+LU.POS),DE   ; D = Rad, E = Kolumn p} bildsk{rm 
            PUSH  HL 
            PUSH  DE 
            PUSH  BC 
            LD    BC,1 
            CALL  ConWrite 
            POP   BC 
            POP   DE 
            POP   HL 
            RET 


; ]terst{llning av attributkod till vitt p} svart bakgrund, p} 806, om 
; inte ATTRIBUTE 4 {r satt. Anropas vid explicit och implicit radbyte, ned}t 
; lika v{l som upp}t. F|rflyttning med CUR() har dock ingen s}dan h{r 
; }terst{llning. Stryks p} 800 och 802. M}ste bevara register HL och BC. 
; 
; Arbetar med LU.CSIZE och LU.OUT53 i CRT.LU, eftersom det {r den som i det 
; h{r l{get har de aktuella v{rdena. De {r inte tillbakalagda i IX-LU:n {n. 

AttrWrap:   BIT   2,(IX+LU.ATTR) 
            RET   NZ               ; ]terst{llning ej |nskad. 
            LD    A,(CRT.LU+LU.CSIZE) 
            AND   248              ; (1111 1000) EL, DBLE och grafik bort. 
            BIT   3,A 
            JR Z  AW.1 
            OR    4                ; Vid WIDTH 40, m}ste EL s{ttas. 
AW.1:       LD    (CRT.LU+LU.CSIZE),A 
            LD    A,7 
            LD    (CRT.LU+LU.OUT53),A
            OUT   (53),A 
            RET 
