1 REM Ins{nd av Kristoffer Eriksson <5357>    1988-06-21 19.04.00 (KERMIT)
; Fil: WNDOPEN.ASM 
; Av: Kristoffer Eriksson, "SKE" <5357>. 
; 
;-Ver--/-Datum----/-Sign-/-Kommentar---------------------------------- 
; X.00 / 84-12-03 / SKE  / WNDOPEN 
; 1.00 / 85-05-28 / SKE  / 
; 2.00 / 88-04-17 / SKE  / Mer kommentarer. Filen markeras inte som |ppen 
;                          n{r OPEN ger fel. Filer utan f|nsterparametrar 
;                          markeras inte som parmanenta, utom fil 0. 
;                          Aktuell sk{rmbredd anv{nds vid parameterkontroll 
;                          och ramritning, inte alltid 80. Mode "O". Ok{nd 
;                          mode ger fel. Ramens teckenupps{ttning v{ljs redan 
;                          vid inladdning. R{tt sk{rmvidd anv{nds vid 
;                          radering av ramen. 
; 
; Rutiner f|r OPEN/PREPARE och CLOSE av f|nster, inkl utritning av ramen. 


            EXTERN OPEN, OPENCON, CLOSE, RitaRam, $$ATTR.4 

LUS.WIN:    =     7                ; LU.STAT  Filen {r ett {kta f|nster. 
LUW.ERAS:   =     0                ; LU.WSTAT Radera f|nstret vid CLOSE. 


; --------- OPEN ------------------------------ 
; 
; Filnamnet kan vara tomt, varvid en vanlig sk{rmfil s{tts upp, eller 
; inneh}lla f|nsterparametrar enligt WND:RRKKHHBB.M (Rad, kolumn, h|jd, 
; bredd, mode) som avl{ses och skrivs in i LU-blockat. Mode-parametern 
; styr utritning av ramen vid |ppning och radering av f|nstret vid st{ngning. 
; F|nstrets utskriftsyta m}ste rymmas inom den 25 rader stora sk{rmen, medan 
; ramen f}r hamna utanf|r. 
; 
; Mode   Auto ram    Radering vid CLOSE 
;   N     Nej         Nej 
;   M     Nej         Ja 
;   O     Ja          Nej 
; Blank   Ja          Ja     (Default) 
; 
; Rutinen anropas ocks} f|r RENAME, varvid nya parametrar helt enkelt skriver 
; |ver de gamla i LU.blocket. 
; 
; Aktuellt globalt ATTRIBUTE-v{rde och sk{rmvidd "fryses" in i f|nstret, s} 
; att de hela tiden kan tempor{rt }terst{llas n{r f|nstret accessas. De kan 
; inte {ndras i efterhand (utom med POKE f|rst}s). 
; 
; F|nstrets attributkod och utskriftsmode (LU.OUT53, LU.CSIZE) initieras fr}n 
; senast anv{nda dito i CRT.LU (kan komma fr}n vilket f|nster som hellst). 
; Dessa kan senare {ndras genom utskrift av styrkoder till f|nstret. 
; 
; Vid OPEN fr}n Basics OPNX/OPNCMD-rutin, inneh}ller LU-blocket vid anrop 
; LU.RNDRC (LU.COL0, LU.LINE0)   = 0, 
; LU.RNDO  (LU.ATTR)             = 3, 
; LU.BUFN  (LU.OLDWID, LU.HIGHT) = -1, 
; LU.EOF   (LU.OUT53, LU.CSIZE)  = -1, 
; LU.STAT  = 0, 
; LU.DCB   = Adress till drivrutinadress. 
; 
; Om OPNX/OPNCMD i sin tur anropats fr}n Basic, {r resten av blocket 
; nollst{llt av ALLOZMEM. I annat fall kan det i princip inneh}lla vad som 
; hellst. Den som programmerar varsamt l{r nog se till att det {r nollst{llt 
; vanligtvis. 
; 
; Vid retur h{rifr}n f|rv{ntar sig OPNX/OPNCMD vissa v{rden i registren, som 
; stoppas in i LUblocket 
; LU.WID             <- C, 
; LU.BUFH (LU.WSTAT) <- D. 
; 
; Samt att LU.POS nollst{lls, och LUS.OPN i LU.STAT ettst{lls. LUS.OPN 
; beh|ver inte st{llas av den h{r OPEN-rutinen. Andra PROM-OPEN g|r det inte. 
; D{remot {r det l{mpligt att LUS.OPN inte {r ettst{lld om |ppningen ger fel. 
; 
; Vid RENAME, inneh}ller LU-blocket f|rutvarande parametrar, och inget {ndras 
; efter retur h{rifr}n. Dock anv{nder DOS:ets Basics NAME-instruktion B som 
; dosbuffert att st{nga, oavsett felstatus fr}n den h{r rutinen. F|r att 
; undvika det m}ste B vara 0 vid retur. 
; 
; Vid RENAME p} CON: g}r anropet till OPENCON, med andra default-flaggor. Om 
; omd|pningen ger fel, kommer filen (CON.LU) {nd} att h}llas |ppen, s} vi ser 
; till att den d} {r satt som vanlig sk{rmfil, som ju inte utnyttjar de ev 
; felaktiga f|nsterparametrarna. 
; 
; In: HL = Adress till n{sta l{nk i enhetslistan (om anrop fr}n OPNX/OPNCMD), 
;     DE = Adress till filnamnet utom enhetsnamn. 

OPN.ErrP:   POP   IX 
OPN.Err:    SCF 
            LD    A,21             ; Error 21 - hittar ej filen 
            LD    B,0              ; St{nga ingen dosbuffert. 
            RET 

OPEN:       LD    A,4              ; Inledande LU-status ifall inga f|nster- 
OPENCON:    LD    (IX+LU.STAT),A   ;   parametrar, eller om det blir fel: 
                                   ;   LUS.IACT. 
            LD    A,(CON.LU+LU.WID); Inledande vidd l{ggs i C, ifall inga 
            LD    C,A              ;   f|nsterparametrar. Ska vara fr}n CON.LU 
                                   ;   {ven om denna {r ett f|nster.Se CONWnd. 
            LD    B,0              ; St{ng ingen dosbuffert. 
            LD    A,(DE) 
            CP    " "              ; Inga parametrar angivna => vanlig CON: 
            RET Z                  ;  med bevarad bredd (C). D {r ointressant. 

            ; Unders|k parametrarna i filnamnet en efter en. Filen blir 
            ; antingen f|nster eller fel. 
 
            PUSH  IX 
            EX    DE,HL            ; HL <- Adress till filnamnet. 
            LD    B,3              ; De 3 f|rsta v{rdena. 
OPN.L:      CALL  ASCTal 
            JR C  OPN.ErrP 
            LD    (IX+LU.LINE0),A  ; Passerar LU.COL0 och LU.HIGHT ocks}. 
            DEC   IX 
            DJNZ  OPN.L 
            POP   IX 
            LD    A,(CRT.LU+LU.WID) 
            LD    (IX+LU.SWID),A   ; Notera aktuell sk{rmvidd f|r f|nstret. 
            LD    B,A              ; Anv{nds nedan. 
            CALL  ASCTal           ; Kolla sista v{rdet, vidden. 
            JR C  OPN.Err 
            LD    (IX+LU.WID),A 

            ; Kontrollera v{rdenas giltighet. 

            ADD   (IX+LU.COL0) 
            INC   B 
            CP    B                ; J{mf|r med aktuell sk{rmvidd. 
            JR NC OPN.Err 
            LD    A,(IX+LU.HIGHT) 
            ADD   (IX+LU.LINE0) 
            CP    26               ; J{mf|r med maximal sk{rmh|jd. 
            JR NC OPN.Err 

            ; Mode-parametern: Raderingsflaggan och utritning av ramen. 

            LD    (IX+LU.WSTAT),0  ; F|nstret raderas ej vid CLOSE. 
            LD    A,(HL) 
            CP    "N"              ; N - Ingen ram, ingen radering. 
            JR Z  OPN.X2 
            CP    "O"              ; O - Ram, ingen radering. 
            JR Z  OPN.X1 
            SET   LUW.ERAS,(IX+LU.WSTAT) ; F|nstret raderas vid CLOSE 
            CP    "M"              ; M - Ingen ram, radering 
            JR Z  OPN.X2 
            CP    " "              ; Default - Ram, radering 
            JR NZ OPN.Err 
OPN.X1:     CALL  RitaRam 

            ; Avslutande initieringar. Inga fler fel kan nu intr{ffa, s} 
            ; filen kan tryggt flaggas som {kta f|nster nu. 

OPN.X2:     LD    (IX+LU.STAT),10000111I ;LUS.WIN, LUS.PERM, LUS.IACT, LUS.OPN 
                                   ; Passar b}de omd|pt CON: och vanligt 
                                   ;   lyckligt |ppnat f|nster. 
$$ATTR.4:   LD    A,(0)            ; ATTRIBUTE-instruktionens v{rde 
            LD    (IX+LU.ATTR),A 
            XOR   A                ; A <- 0, No Carry. 
            LD    B,A              ; St{ng ingen dosbuffert. 
            LD    (IX+LU.COL),A    ; Nollst{ll koordinater. 
            LD    (IX+LU.LINE),A 
            LD    C,(IX+8)         ; L{ggs tillbaks av BASIC:s |ppningsrutin 
            LD    D,(IX+20)        ;            -"- 
            JP    LUINIT           ; Initiera LU.OUT53 o LU.CSIZE fr}n CRT.LU. 


; L{s tv} tecken p} adress HL, och tolka dem som ett decimalt tal i ASCII. 
; Returnera v{rdet i A, eller Carry vid fel, samt |ka HL. Utnyttjar D. 

ASCTal:     LD    A,(HL) 
            INC   HL 
            SUB   48 
            RET   C                ; Fel - ej siffra 
            LD    D,A 
            ADD   A                ; 2* 
            ADD   A                ; 4* 
            ADD   D                ; 5* 
            ADD   A                ;10* 
            LD    D,A 
            LD    A,(HL) 
            INC   HL 
            SUB   48 
            RET   C                ; Fel - ej siffra 
            ADD   D 
            RET 


; --------- Rita ut ram runt f|nster ---------- 
; 
; Anv{nds av OPEN och av PRINT-rutinen. 
; 
; Rita ram med l{mplig teckenupps{ttning f|r aktuell maskin. 

RitaRam:    LD    A,(CRT.LU+LU.CSIZE) 
            PUSH  AF 
            SET   0,A 
            LD    (CRT.LU+LU.CSIZE),A    ; St{ll grafik f|r ABC 806. 
            LD    HL,RamTkn 
            CALL  Ram                    ; Rita ramen runt f|nstret. 
            POP   AF 
            LD    (CRT.LU+LU.CSIZE),A    ; ]terst{ll f|r ev fortsatt utskr. 
            RET 

; Genomf|r sj{lva ritandet av ram med teckenupps{ttning enligt HL. 

Ram:        LD    E,(IX+LU.COL0)   ; HL=Tecken som ska anv{ndas i ramen. 
            DEC   E 
            CALL  Ram.Lodr{t       ; V{nster sida av ramen 
            INC   E 
            LD    D,(IX+LU.LINE0) 
            DEC   D 
            CALL  Ram.V}gr{t       ; Ovansidan 
            CALL  Ram.Lodr{t       ; H|ger sida 
            LD    E,(IX+LU.COL0) 
            ;(JP  Ram.V}gr{t)      ; Undersidan 

; Rita en horisontell kant av ramen, exkl h|rn, med kontroll av sk{rmens h|gra 
; och v{nstra gr{ns. D = Rad, E = Startkolumn, HL = Pekare till tecknet f|r 
; kanten. \ka HL och E. 

Ram.V}gr{t: LD    B,(IX+LU.WID) 
            LD    A,D              ; Rad. 
            AND   A 
            JP M  RM.X2            ; Ovanf|r bildsk{rmen 
            CP    25 
            JR NC RM.X2            ; Under bildsk{rmen 
            INC   B                ; Antal tecken i kanten = f|nstrets vidd. 
            JR    RM.X1 
RM.L1:      CALL  CrtWr.1 
            INC   E 
RM.X1:      DJNZ  RM.L1 
            INC   HL 
            RET 

RM.X2:      INC   HL 
            LD    A,E              ; \ka kolumnen, men rita inte ut kanten 
            ADD   B                ;   eftersom den ligger utanf|r sk{rmen. 
            LD    E,A 
            RET 

; Rita en lodr{t kant av ramen, inkl h|rnen, med kontroll av sk{rmens alla 
; gr{nser. E = Kolumn, HL = Pekare till tecken f|r |vre h|rn, kant och undre 
; h|rn. Internt: D = Aktuell rad, B = Loopr{knare rader. \ka HL och D, bevara
; E. 

Ram.Lodr{t: LD    D,(IX+LU.LINE0) 
            LD    B,(IX+LU.HIGHT) 
            LD    A,E              ; Kolumn. 
            AND   A 
            JP M  RL.X3            ; Till v{nster om bildsk{rmen. 
            CP    (IX+LU.SWID) 
            JR NC RL.X3            ; Till h|ger om bildsk{rmen. 
            DEC   D 
            JP M  RL.X1            ; Ovanf|r 
            CALL  CrtWr.1          ; \vre h|rnet. 
RL.X1:      INC   HL 
            INC   B 
            JR    RL.X2 
RL.L1:      CALL  CrtWr.1          ; Rita kanten. 
RL.X2:      INC   D 
            DJNZ  RL.L1 
            INC   HL 
            LD    A,D 
            CP    25 
            CALL C CrtWr.1         ; Undre h|rnet, om det syns. 
            INC   HL 
            RET 
 
RL.X3:      INC   HL               ; [ven om kanten hamnar utanf|r sk{rmen, 
            INC   HL               ;   m}ste HL och D |kas. 
            INC   HL 
            LD    A,D              ; Rad. 
            ADD   B 
            LD    D,A 
            RET 

RamTkn:     DEFM  "xxxxxxxx"       ; Initieras av initrutinen. 
RamTkn.Bort:DEFM  "        " 


; St{ngning. Endast f|r {kta f|nster (med LUS.WIN satt). 
; Nollst{llning av LUS.OPN {r inte en uppgift f|r den h{r rutinen. 

CLOSE:      BIT   LUW.ERAS,(IX+LU.WSTAT) 
            RET Z                  ; Ska ej raderas. 
            CALL  CrtInit          ; St{ll bl a r{tt sk{rmvidd. 
            CALL  CLS              ; T|m f|nstret. 
            LD    HL,RamTkn.Bort 
            CALL  Ram              ; Ers{tt ramen med blanktecken. 
            XOR   A                ; No Carry. 
            RET                    ; Tv}ngsanrop av CrtExit (Carry of|r{ndrad) 


; --------- Initiering ------------------------ 
; 
; V{lj teckenupps{ttning f|r f|nster-ram. Grafiska f|r 806, och vanliga f|r 
; |vriga modeller. 

Init:       LD    HL,RamTkn.802 
            LD    A,(BasicTyp) 
            CP    Typ.806 
            JR NZ I.X1 
            LD    HL,RamTkn.806 
I.X1:       LD    DE,RamTkn 
            LD    BC,RamTkn.806 - RamTkn.802 
            LDIR                   ; \verf|r |nskade upps{ttning. 
            RET 

RamTkn.802: DEFM  "+!+-+!+-"       ; V{nster,\ver,H|ger,Under 
RamTkn.806: DEFM  "hj*,lj.," 

            REL PUSH Init 
            REL CALL 
            ORG Init 
