1 REM Ins{nd av Kristoffer Eriksson <5357>    1988-06-21 19.00.48 (KERMIT)
; Fil: WNDMAIN.ASM 
; Av: Kristoffer Eriksson, "SKE" <5357>. 
; H|r till WINDOW. 
; 
;-Ver--/-Datum----/-Sign-/-Kommentar---------------------------------- 
; X.00 / 85-03-08 / SKE  / WNDMAIN 
; 1.00 / 85-05-28 / SKE  / 
; 2.00 / 88-04-17 / SKE  / Mer kommentarer. Url{nkningsrutin vid DELETE. 
;                          GET p} f|nster placerar nu mark|ren i r{tt f|nster. 
;                          LU.SWID inf|rd i CrtInit/Exit, s} f|nster bevarar 
;                          sin sk{rmvidd {ven om CON:s vidd {ndras. CONREAD 
;                          trappas nu {ven n{r CON: inte {r ett f|nster, s} 
;                          mark|rpositionen inte "f|rsvinner" efter}t. 
;                          Situationen med utskrift p} en sk{rmfil, n{r CON: 
;                          {r omd|pt, uppt{cks och hanteras nu. CrtInit fixar 
;                          tv}ngsanrop till CrtExit. 
; 
; Inneh}ller drivrutinentryt f|r enheterna WND: och CON:, delar av de rutiner 
; som anropas d{rifr}n, samt url{nkningsrutinen. Sk|ter {ven det mesta 
; skyfflandet av data fram och }ter mellan CRT.LU och |vriga f|nster-LU:er. 

            EXTERN $$Entry.CRT, $$ATTR.1, $$ATTR.2, $$ATTR.3 
            EXTERN $$CRTINPRET, $$ConsI, $$Dev.CRT 
            EXTERN Entry.WND, CrtPos, LUInit, ConsI.Ny, CrtInit 

LUS.WIN:    =     7      ; LU.STAT Filen {r ett {kta f|nster. 


; Operation: 0=OPEN, 1=PREPARE, 2=CLOSE, 3=INPUT, 4=PRINT, 5=GET, 6=PUT 
;            7=BLOCKIN, 8=BLOCKOUT, 9=DELETE, 10=RENAME 


; --------- Ing}ng till drivrutiner ----------- 

Entry.WND:  LD    (IX+LU.FC),A 
            CP    2                ; A=Operation 
            JP C  OPEN             ; 0=OPEN, 1=PREPARE 
            BIT   LUS.WIN,(IX+LU.STAT) 
            JP Z  NormCON          ; Inte n}got {kta f|nster. 
Entry2.WND: SUB   2 
            JP Z  CLOSE            ; 2=CLOSE 
            DEC   A 
            JP Z  INPUT            ; 3=INPUT 
            DEC   A 
            JR Z  PRINT            ; 4=PRINT 
            DEC   A 
            JR Z  GET              ; 5=GET, anv{nd vanliga drivrutinen. 
            DEC   A 
            JR Z  PUT              ; 6=PUT 
            SUB   4 
            JP Z  OPEN             ; 10 = RENAME (Omd|pning av f|nster {r dock 
                                   ;   inte speciellt meningsfullt.) 
                                   ; 7,8,9 = BLOCKIN/OUT, DELETE 
ERR52:      LD    A,52             ; Error 52 - Ej till denna enhet. 
            SCF 
            RET 


; --------- Rutiner f|r {kta f|nster. --------- 
; 
; F|r utskrift p} riktiga f|nster som inte omfattar hela sk{rmen. I huvudsak 
; kopieras aktuella attribut (LU.OUT53, LU.CSIZE) och position (LU.POS) fr}n
; f|nstrets LU till CRT.LU och till ATTRIBUTE-v{rdet (LU.ATTR), varefter 
; respektive f|nsterrutin anropas, f|r att till sist kopiera tillbaks LU-data. 

; CrtInit/Exit. ----- 
; 
; Kopiera n|dv{ndiga data mellan CRT.LU och f|nstrets LU, f|r PRINT/PUT/INPUT. 
; L{gger in tv}ngsanrop till CrtExit. 
; 
; LU.OUT53 och LU.CSIZE m}ste kopieras s} att utskrift sker med r{tt attribut 
; och teckenhantering. LU.OUT53 m}ste {ven l{ggas ut p} attributporten. De 
; m}ste {ven kopieras tillbaks eftersom de kan {ndras av styrkoder som skrivs 
; ut. Attributporten f}r beh}lla senast anv{nda v{rde. St{lls {ven av NormCon. 
; P} andra modeller {n 806 skulle kopieringen av dessa tv} variabler kunna 
; hoppas |ver. 
; 
; Sk{rmvidden m}ste st{llas s} att den alltid {r densamma f|r ett f|nster, 
; annars hamnar utskriften fel i sidled. PROM-rutinerna g}r efter LU.WID n{r 
; de ber{knar sk{rmadressen, inte b3 i LU.CSIZE. Vi st{llet {ven LU.OLDWID, 
; s} inte sk{rmen v{xlar mellan 40/80-mode p} 802 (om den nu g|r det?), n{r 
; man skriver i ett f|nster med annan sk{rmvidd {n sk{rmen. Bara om LU.OLDWID 
; <> LU.WID, unders|ker PROM-rutinerna om sk{rmmoden m}ste {ndras. 
; 
; Sk{rmens (CON:s) sk{rmvidden m}ste sparas och }terst{llas, s} aktuell 
; vidd finns kvar n}gonstanns {ven n{r CON: {r omd|pt till ett f|nster och 
; inte inneh}ller sk{rmens vidd. LU.OLDWID beh|ver inte n|dv{ndigtvis 
; }terst{llas, eftersom det g|rs av PROM-rutinerna om den skiljer sig. 
; 
; ATTRIBUTE-v{rdet m}ste st{llas s} utskriften hanteras r{tt, och sparas och 
; }terst{llas efter}t, s} att den vid |vriga tillf{llen inneh}ller sk{rmens 
; eget v{rde, som kan st{llas med ATTRIBUTE-instruktionen. 
; 
; CrtInit m}ste bevara BC och HL. LUInit, och d{rmed CrtExit m}ste bevara B, 
; C och D, och inte g|ra Carry sann. 
; 
; LUInit anropas av OPEN f|r att initiera LU.OUT53 och LU.CSIZE i ett nytt 
; f|nster fr}n CRT.LU. 

CrtInit:    LD    A,(IX+LU.OUT53)       ; St{ll attribut. 
            LD    (CRT.LU+LU.OUT53),A 
            OUT   (53),A 
            LD    A,(IX+LU.CSIZE)       ; St{ll f|nstrets utskriftsmode. 
            LD    (CRT.LU+LU.CSIZE),A 

            LD    A,(CRT.LU+LU.WID)     ; Spara sk{rmvidden p} s{ker plats. 
            LD    (CRT.LU+LU.SWID),A 
            LD    A,(IX+LU.SWID)        ; St{ll sk{rmvidden. 
            LD    (CRT.LU+LU.WID),A 
            LD    (CRT.LU+LU.OLDWID),A 

$$ATTR.1:   LD    A,(0)                 ; Adress till ATTRIBUTE-v{rde l{ggs in 
            LD    (CRT.LU+LU.ATTR),A    ; Spara det p} s{ker plats. 
            LD    A,(IX+LU.ATTR)        ; St{ll f|nstrets ATTRIBUTE i st{llet. 
$$ATTR.2:   LD    (0),A 

            EX    DE,HL                 ; L{gg in tv}ngsanrop till CrtExit, 
            LD    HL,CrtExit            ;   s} den anropas n{r den nu 
            EX    (SP),HL               ;   anropande rutinen returnerar. 
            PUSH  HL 
            EX    DE,HL 
            RET 


CrtExit:    LD    A,(CRT.LU+LU.ATTR)    ; ]terst{ll global ATTRIBUTE 
$$ATTR.3:   LD    (0),A 
            LD    A,(CRT.LU+LU.SWID)    ; ]terst{ll sk{rmvidd. 
            LD    (CRT.LU+LU.WID),A 
LUInit:     LD    A,(CRT.LU+LU.OUT53)   ; Kopiera tillbaks utskriftsattribut. 
            LD    (IX+LU.OUT53),A 
            LD    A,(CRT.LU+LU.CSIZE) 
            LD    (IX+LU.CSIZE),A 
            RET 


; DE <- Absolut position f|r f|nster. Addition av f|nstrets placering och 
; relativ position inom f|nstret. 

CrtPos:     LD    A,(IX+LU.COL0) 
            ADD   (IX+LU.COL) 
            LD    E,A 
            LD    A,(IX+LU.LINE0) 
            ADD   (IX+LU.LINE) 
            LD    D,A 
            RET 


; Interface till f|nsterrutinerna. 

PRINT: PUT: CALL  CrtInit 
            CALL  WndWr#Put 
            CALL  CrtPos               ; L}t PRINT/PUT alltid l{mna CRT.LU med 
            LD    (CRT.LU+LU.POS),DE   ;   aktuell mark|rplacering. 
            RET                        ; Tv}ngsanrop CrtExit (NC). 

GET:        CALL  CrtInit              ; St{ll bl a sk{rmvidd. 
            CALL  CrtPos               ; Placera mark|ren r{tt. 
            LD    (CRT.LU+LU.POS),DE 
            ;(JR  Ent.CRT)             ; Avslutas med tv}ngsanrop CrtExit. 


; --------- F|nster = Vanliga sk{rmen --------- 
; 
; F|r utskrift via CON.LU (om den inte {r omd|pt) och andra filer |ppnade 
; utan f|nsterparametrar. F|r de flesta rutiner kopieras n|dv{ndiga data fr}n 
; CON.LU till CRT.LU, varefter den gamla CON:s drivrutiner anropas, f|r att 
; till sist kopiera tillbaks LU-data. 
; 
; Man kunde t{nka sig att kopiera fram och }ter bara n{r access v{xlar fr}n 
; att g} till f|nster till att g} till sk{rmen och vice versa. Men d} kan 
; ev {ndringar i CON.LU (WIDTH eller POKE) medan det {r CRT.LU som g{ller, 
; bli effektl|sa. ] andra sidan skulle POKE i gamla program som g}r till 
; CRT.LU f} effekt, dock bara om det {r CRT.LU som g{ller d}. 

Ent.CRT:    LD    A,(IX+LU.FC)     ; F.d. CON: f}r sk|ta om inmatningen 
$$Entry.CRT:JP    0                ; Plats f|r dess drivrutinadress 


NormCON:    CP    2 
            RET Z                  ; 2=CLOSE. COPYLU f}r ej ske vid st{ngning. 
            SUB   9 
            JR Z  UnLink           ; 9 = DELETE. Url{nkning av WINDOW. 
            DEC   A 
            JR Z  CONRename        ; 10 = RENAME. Omd|pning av CON:. 
            LD    A,(CON.LU+LU.STAT) 
            BIT   LUS.WIN,A 
            JR NZ CONWin           ; CON.LU {r ett f|nster! 

; \vriga delrutiner. Kopiera alltid CON.LU, oavsett vilket LU-block som 
; anv{nds i anropet hit. [ven om det {r flera filer |ppnade mot sk{rmen, s} 
; {r det {nd} bara EN sk{rm. S} arbetar {ven PROM-rutinerna. 
; 
; Det anv{nda LU-blocket kommer inte att ha korrekta data om aktuell rad, 
; sk{rmbredd eller maskinberoende andra variabler, men s} {r det {ven utan 
; WINDOW. Aktuell kolumn uppdateras dock av PROM-rutinerna, s} att TAB p} fil 
; fungerar. Det f}r vi gratis eftersom vi skickar med IX of|r{ndrad. 
; 
; Not: Utskrift f|rst p} en sk{rmfil (t ex 0) och sedan TAB p} en annan (ej 0) 
; har alltid blivit fel, och blir det nu ocks}. 

            LD    A,(CON.LU+LU.OUT53) 
            OUT   (53),A           ; St{ll attributport. 
            AND   A 
            CALL  CopyLU           ; CRT.LU <- CON.LU 
            CALL  Ent.CRT          ; Utf|r operationen. 
            PUSH  AF 
            SCF 
            CALL  CopyLU           ; CON.LU <- CRT.LU 
            POP   AF 
            RET 


; Kopiera n|dv{ndiga delar av LU mellan CON.LU och CRT.LU, s} PROM-rutinerna 
; f}r r{tt data. Inga register p}verkas. 
; Carry => fr}n CRT.LU, No Carry => till CRT.LU 
; 
; Kopierar LU.POS, LU.WID, LU.SWID, LU.FC, LU.OUT53, LU.CSIZE. 
; Kopierar ej LU.OLDWID, LU.HIGHT, LU.COL0, LU.LINE0, LU.ATTR och LU.WSTAT. 
; 
; LU.SWID anv{nds inte av PROM-rutinerna, den r}kar bara ligga mitt emellan 
;   andra variabler som anv{nds. 
; LU.OLDWID anv{nds p} 806, men det {r rimligt att ha den kopplad till den 
;   fysiska sk{rmen (CRT.LU) i st{llet f|r till den "virtuella". I vilket fall 
;   s} h{nder inget skadligt {ven om den blir fel. Den bara signalerar 
;   omr{kning av vissa attribut. 
; \vriga variabler utnyttjas inte av PROM-rutinerna, och inte av WINDOW heller 
;   n{r filen inte {r ett {kta f|nster. (N}ja, CRT.LU.ATTR och SWID anv{nds 
;   tempor{rt av CrtInit/Exit till att spara v{rden i.) 

CopyLU:     PUSH  HL 
            PUSH  DE 
            PUSH  BC 
            LD    HL,CON.LU+LU.POS 
            LD    DE,CRT.LU+LU.POS 
            LD    BC,LU.CSIZE-LU.POS+1 
            JR NC CP.X1 
            EX    DE,HL 
CP.X1:      LDIR 
            POP   BC 
            POP   DE 
            POP   HL 
            RET 


; Utskrift p} fil |ppnad som bara "CON:" (ej fil 0) n{r CON.LU {r omd|pt till 
; f|nster. Nuvarande design till}ter inte att en s}dan fil forts{tter att 
; g{lla hela sk{rmen, eftersom den enda LU som brukar ha data f|r s}nt, 
; CON.LU, {r upptagen med annat. I st{llet sker - minst lika logiskt - 
; operationen i det f|nster som CON.LU {r omd|pt till. Liksom PROM-rutinerna 
; kopierar LU.COL n{r de anv{nds, g|r denna rutin det ocks}. 
; 
; En skillnad {r att om filen |ppnats innan CON.LU d|pts om, kommer den att 
; inneh}lla fel vidd. Att justera den n{r utskrift redan beordrats, {r f|r 
; sent f|r att undvika fel, s} vi f}r leva med det. Varf|r skulle n}gon f | 
; g|ra p} det viset? 

CONWin:     LD    A,(IX+LU.FC) 
            PUSH  IX 
            LD    IX,CON.LU        ; G|r utskriften p} CON.LU. 
            LD    (IX+LU.FC),A 
            CALL  Entry2.WND       ; Anropa f|nsterdrivrutinerna. 
            POP   IX 
            LD    A,(CON.LU+LU.COL); \verf|r kolumn. 
            LD    (IX+LU.COL),A 
            RET 

; Omd|pning av CON: (utan f|nsterparametrar). Byt till CON.LU s} r{tt LU 
; p}verkas, och inte UTTLLU som NAME-instruktionen |ppnat f|r omd|pningen. 
; \ppna sen om CON.LU med nya parametrar fr}n filnamnet. 
; 
; Kopiera vidden fr}n CRT.LU, s} vid omd|pning till vanlig sk{rm, aktuell 
; sk{rmvidd anv{nds, inte f|nstrets gamla smala bredd. N{r filnamnet {r 
; tomt i OPEN bevaras n{mligen LU.WID (liksom det mesta) of|r{ndrad. 
; CRT.LU.WID uppdateras endast vid access till hela sk{rmen, och d} fr}n 
; CON.LU (CopyLU), s} den inneh}ller senaste r{tta vidd. WIDTH till fil 0, 
; som st{lls medan den {r omd|pt till ett f|nster, kan inte g{lla hela 
; sk{rmen. 
; [r filnamnet inte tomt, initieras LU.WID enligt dess parametrar. 
; 
; Anropet sker till OPENCON i OPEN, d{r A indikerar initial LU-status. Detta 
; anv{nds f|r att se till att fil 0 f}r sina speciella flaggor, n{mligen 
; LUS.PERM och LUS.IACT samt markeras som |ppen {ven om f|nsterparametrarna 
; f|rorsakar fel (i s} fall blir det en vanlig sk{rmfil av den). (OPEN-rutinen 
; f|rv{ntas inte n}gon annanstanns anropas med CON.LU, och aldrig med CRT.LU, 
; s} man beh|ver inte ha en kr}nglig j{mf|relse av IX-v{rden i OPEN f|r att 
; best{mma LU.STAT i st{llet f|r den h{r enkla metoden.) 

CONRename:  LD    IX,CON.LU 
            LD    A,(CRT.LU+LU.WID) 
            LD    (IX+LU.WID),A 
            LD    A,00000111I      ; LU.STAT: LUS.OPN, LUS.PERM, LUS.IACT. 
            JP    OPENCON 


; --------- Ny CONSI-rutin -------------------- 
; 
; Denna rutin {r inl{nkad i CONSI-vektorn, och f}ngar upp alla anrop dit som 
; kommer fr}n den CONREAD-rutin som finns i PROM. N{r ett s}dant anrop 
; inf}ngas, byts den anropande CONREAD ut mot WINDOWs egen motsvarande rutin, 
; n}got olika beroende p} om CON: {r omd|pt till ett f|nster eller inte. 
; Kommer anropet inte fr}n CONREAD, forts{tter exekveringen med den vanliga 
; CONSI-rutinen.
; 
; Att CONREAD m}ste bytas ut n{r CON: g}r till ett f|nster, b|r vara 
; sj{lvklart. Anrop via IO till CON:s drivrutiner skickas f|rst}s direkt till 
; WINDOWs INPUT-rutin, men det kan ju {ven f|rekomma anrop direkt till 
; CONREAD i PROM. 
; 
; [ven om CON: inte {r omd|pt, m}ste CONREAD f}ngas upp, s} man kan kopiera 
; n|dv{ndiga data mellan CRT.LU och CON.LU. Annars kommer den rad som 
; inmatningen g|rs p}, att skrivas |ver vid n{sta utskrift p} fil 0. Basic 
; blandar tyv{rr anrop via filsystemet med anrop direkt till CONREAD, s{rskilt 
; vid editering av inmatning som gavfelmeddelande. 
; 
; WndInput anv{nder sig av CON.LU som kopieras till CRT.LU vid varje uppdate- 
; ring av sk{rmen, och tillbaks igen. Program som anv{nder direkt anrop till 
; CONREAD, anv{nder ofta ocks} direkt anrop till CONWRITE, som d} har {ndrat 
; data i CRT.LU utan att ha uppdaterat CON.LU. D{rf|r g|rs en s}dan 
; uppdatering h{r, om CON.LU inte {r ett f|nster. Har CONREAD anropats via 
; f|nsterdrivrutinerna, s} {r CRT.LU redan en kopia av CON.LU, s} inget 
; farligt h{nder. Har utskriften g}tt genom drivrutinerna, trots att inte 
; CONREAD g|r det, s} st{mmer CRT.LU i alla fall fortfarande, s}vida ingen 
; utskrift gjorts p} f|nster d{remellan, vilket inte {r speciellt troligt med 
; program som anv{nder CONREAD direkt. Och skulle det vara s} {nd}, s} kan 
; det kvitta. 

                             ;  ! 
ConsI.Ny:   EX    (SP),HL    ;==+  HL <- Returadress. 
            PUSH  DE         ;-,! 
$$CRTInpRet:LD    DE,0       ; !!  Den returadress som indikerar anrop fr}n 
            AND   A          ; !!    den inbyggda CONREAD l{ggs in h{r. 
            SBC   HL,DE      ; !! 
            ADD   HL,DE      ; !!  ]terst{ll HL utan att p}verka Z-flaggan. 
            POP   DE         ;-'!  Om anropet inte kommer innifr}n PROM- 
            JR NZ ConsI.X1   ;  !    CONREAD, s} forts{tt med normala CONSI. 
            POP   HL         ;--'  ]terst{ll HL, returadressen kasseras. 
            LD    IX,CON.LU  ;     Ers{tt CRT.LU med CON.LU. 
            BIT   LUS.WIN,(IX+LU.STAT) 
            SCF 
            CALL Z CopyLU    ;   ! Synca CON.LU med CRT.LU om ej f|nster. 
            CALL  WndInput   ;   ! 
            POP   IX         ;---' POP:a IX sparad av CONREAD. 
            RET              ;     Retur till den rutin som anropade CONREAD. 

                             ;  ! 
ConsI.X1:   EX    (SP),HL    ;==+  Normal CONSI utf|rs. 
$$ConsI:    JP    0          ;  !  Den gamla CONSI-adressen l{ggs in. 


; --------- Url{nkning av WINDOW. ------------- 
; 
; Kontrollera att vi befinner oss i ett k{nt l{ge, och i s} fall }terst{ll 
; alla systempekare somm de s}g ut innan WINDOW laddades in, utan att totalt 
; krascha eventuellt Basicprogram som beg{rt url{nkningen. 
; Anropas med No Carry fr}n Entry.WND. 

UnLink:     LD    HL,(ConsI+1)     ; Kolla att CONSI-pekaren inte har {ndrats. 
            LD    BC,ConsI.Ny      ;   I s} fall f}r allt den som {ndrat den, 
            SBC   HL,BC            ;   {ndra tillbaks den innan vi kan g|ra 
            JR NZ U.Err            ;   n}got }t saken. 
 
            LD    HL,(Y.Botm)      ; Kolla minnesbotten. 
            LD    BC,WndTop 
            SBC   HL,BC            ; (No Carry sen tidigare) 
            JR NZ U.Err 

            ; Kolla enhetslistan. D{r skulle man iofs kunna l{nka ur sig {ven 
            ; om n}got nytt dykt upp i b|rjan p} listan, men att n}got skulle 
            ; g|ra det utan att {ndra minnesbotten ocks} {r s} ovanligt att 
                                   ; det inte {r n}gon id` att sl|sa en massa 
            LD    HL,(DevTbA)      ; minne p} en rutin som klarar av en s}dan 
            LD    BC,DevL{nk2      ; url{nkning. 
            SBC   HL,BC            ; (No Carry sen tidigare) 
            JR NZ U.Err 
 
            ; Konvertera alla |ppna filer p} WINDOW:s enheter till normala 
            ; CON:, bl a det LU-block via vilken denna rutin sj{lv anropats. 
            ; L{nka dessutom ur CON.LU ur kedjan. 

            LD    HL,LUCh          ; B|rjan av LU-blocks-listan. 
U.L1:       LD    A,L 
            OR    H                ; (Ger No Carry) 
            JR Z  U.X3             ; 0 = Slut p} listan. 
            LD    E,(HL)           ; DE <- N{sta l{nk. 
            INC   HL 
            LD    D,(HL) 

            EX    DE,HL 
            LD    BC,CON.LU 
            SBC   HL,BC            ; (No Carry fr}n OR ovan) 
            ADD   HL,BC            ; ]terst{ll HL utan att p}verka Z-flaggan. 
            JR NZ U.X1 
            LD    A,(HL)           ; Url{nkning av CON.LU. Ers{tt vidarepe- 
            INC   HL               ;   karen som pekar p} CON.LU, med den som 
            LD    H,(HL)           ;   finns i CON.LU. 
            LD    L,A              ; HL <- N{sta vidarepekare. 
            DEC   DE 
            LD    (DE),A           ; Uppdatera vidarepekaren i aktuellt block. 
            INC   DE 
            LD    A,H 
            LD    (DE),A 

U.X1:       EX    DE,HL 
            INC   HL 
            INC   HL 
            INC   HL 
            PUSH  HL 
            LD    A,(HL)           ; HL <- Adress till enhetensl{nken, LU.DCB. 
            INC   HL 
            LD    H,(HL) 
            LD    L,A 
            LD    A,(HL)           ; HL <- Adress till drivrutinen. 
            INC   HL 
            LD    H,(HL) 
            LD    L,A 
            LD    BC,Entry.Wnd 
            AND   A 
            SBC   HL,BC 
            POP   HL 
            JR NZ U.X2 
$$Dev.CRT:  LD    BC,0             ; H{r l{ggs entry f|r normala CON: in. 
            LD    (HL),C 
            INC   HL 
            LD    (HL),B           ; Uppdatera LU.DCB till normala CON:. 
U.X2:       EX    DE,HL 
            JR    U.L1             ; N{sta LU. 

U.X3:       LD    HL,($$ConsI+1)   ; ]terst{ll CONSI. 
            LD    (ConsI+1),HL 
            LD    HL,WndBotm       ; ]terst{ll minnesbotten. 
            LD    (Y.Botm),HL 
            LD    (Y.ComTop),HL    ; Ta bort COMMON-variabler. De blir i alla 
                                   ;   fall f|rst|rda eftersom de adresseras 
                                   ;   relativt Y.Botm. 

            LD    HL,(DevL{nk1)    ; ]terst{ll enhetslistan. Vanliga CON: 
            LD    (DevTbA),HL      ;   finns kvar l{ngre in i listan. 
            RET                    ; Klart. No Carry fr}n "JR Z U.X3" ovan. 

U.Err:      LD    A,40             ; Error 40 - raderskyddat. Kan inte 
            SCF                    ; }terst{lla pekare korrekt om systemet 
            RET                    ; har {ndrats sen inl{nkningen. 
