1 REM Ins{nd av Kristoffer Eriksson <5357>    1987-12-11 19.45.38 (KERMIT)
; Fil: TRIBASC.ASM
; Av: Kristoffer Eriksson, "SKE" <5357>.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
; 1.00 / 87-10-30 / SKE  / TRIBASC
;
; Omvandla trebytes-tal till text. Talet placeras h|gerjusterat i utarean.
; Anv{nder AF, BC, DE, HL, C', DE', HL'.
;
; Bygger p} en rutin av Ulf Dahlen publicerad i ABC-bladet 2/1987.
;
; In TriBAsc: 
;   DE = Pekare till trebytes-tal med minst signifikant siffra f|rst.
;   HL = Pekare till area d{r resultattexten placeras.
;    B = L{ngd p} resultatarean. 0 betyder 256.
;    C = Bas (talsystem). I princip 2 -- 201.
;    A = Om 0, s} undertrycks inledande nollor i resultatet.
;
; In TriRegAsc: 
; CDE' = Ett trebytes-tal. C {r mest signifikant byte, E minst signifikant. 
;   HL = Pekare till area d{r resultattexten placeras.
;    B = L{ngd p} resultatarean.
;    C = Bas (talsystem).
;    A = Om 0, s} undertrycks inledande nollor i resultatet.
; 
; Ut:
;   DE = Om A var 0: Pekare till f|rsta siffra <> 0, annars skr{p.
;   HL = Pekare till sista siffran + 1, dvs HL + B.
;    C = Bas - 1.
;    B = 0.
;    A <> 0.


            EXTERN TriBAsc, TriRegAsc 

TriBAsc:    push   de 
            exx
            pop    hl                 ; L{s in talet i alternativregistren.
            ld     e,(hl)
            inc    hl
            ld     d,(hl)
            inc    hl
            ld     c,(hl) 
            exx

TriRegAsc:  push   af                 ; Spara indata fr}n A och HL. 
            push   hl 
            ld     e,b                ; Spara B i E en g}ng f|r alla.
            xor    a
ZLoop:      ld     (hl),a             ; Nollst{ll utarean, och sluta med att
            inc    hl                 ; l}ta HL peka p} sista sifferplatsen.
            djnz   ZLoop
            dec    hl
            ld     b,e
            dec    c                  ; Vi vill ha Bas - 1 i st{llet f|r Bas.
            ld     a,c                ; A <- Bas - 1.
                                      ; Halvera talet med rest i carry. 
            exx 
            ld     b,3*8              ; Loopr{knare <- Antal bittar i talet.
BitLoop:    sla    e                  ; carry <- E <- 0.
            rl     d                  ; carry <- D <- carry.
            rl     c                  ; carry <- C <- carry. 
            exx 
                                      ; F|rdubbla resultatet och addera carry.
            push   hl
DigLoop:    rl     (hl)               ; Siffra * 2 + carry.
            cp     (hl)               ; [r Siffra > Bas-1 ?
            jr nc  NextDig            ; Om ej, forts{tt med n{sta, och carry=0
            sub    (hl)               ; Dra Bas ifr}n siffran, och g|r carry=1
            cpl    a                  ;   NOT(Bas-1-Siffra) = -(Bas-Siffra) =
            ld     (hl),a             ;   = Siffra - Bas.
            ld     a,c                ; ]terst{ll A till Bas - 1.
NextDig:    dec    hl
            djnz   DigLoop            ; N{sta siffra. Minnesbitt i carry.
            ld     b,e                ; ]terst{ll B och HL.
            pop    hl

            exx
            djnz   BitLoop            ; N{sta bitt.
            exx

            pop    hl
            pop    af
            and    a                  ; A=0 inneb{r att inledande nollor ska
            jr nz  AscLoop2           ; skrivas som blanktecken.
AscLoop1:   ld     a,(hl)
            and    a                  ; S|k efter siffra <> 0, och skriv alla
            jr nz  EndZero            ; nollor f|re som blanktecken.
            ld     (hl)," "
            inc    hl
            djnz   AscLoop1           ; Var alla siffror noll, s} g|r om sista
            dec    hl                 ; siffran utan undertryckning.
            inc    b
            xor    a
EndZero:    ld     e,l                ; DE <- Pekare till 1:a icke-noll-siffra
            ld     d,h
            jr     DoAsc

AscLoop2:   ld     a,(hl)
DoAsc:      add    "0"                ; G|r till ASCII-siffra.
            cp     "9"+1
            jr c   NextAsc
            add    "A"-"9"-1          ; Addera s} siffror > 9 blir ABCDE...
NextAsc:    ld     (hl),a
            inc    hl
            djnz   AscLoop2
            ret
