1 REM Ins{nd av Lars Davidsson <7020>    1986-09-28 19.16.21 (SEND)
          TITLE 'Rutiner f|r REMOTERM.BAC'
;
;----------------------------------------------------------------------
;
;     Program REMOTERM.ASM version 1.0 1986-09-06
;
;     Konstrukt|r     : Lars Davidsson
;     P}b|rjat        : 1986-09-07
;     Senaste {ndring : 1986-09-19
;
;     Programmet {r ett speciellt terminal program f|r k|rning
;     mot en ABC800 i remote-mod.
;
;     XON,XOFF hantering underst|ds f|r mottagning av tecken.
;
;----------------------------------------------------------------------
;
BEG_LOC   EQU   63232           ; Programmets startadress.
COM_BUF   EQU   64256           ; Adress till mottagarbuffert.
DARVEK    EQU   65456
SIOVEK    EQU   65472
KEYFLG    EQU   65506
KEYCHR    EQU   65507
;
DARADA    EQU   32
DARACO    EQU   33
DARBDA    EQU   34
DARBCO    EQU   35
CRTCCO    EQU   56
CRTCDA    EQU   57
SIOADA    EQU   64
SIOACO    EQU   65
SIOBDA    EQU   66
SIOBCO    EQU   67
CTC0      EQU   96
CTC1      EQU   97
CTC2      EQU   98
CTC3      EQU   99
;
BEL       EQU   7
BS        EQU   8
LF        EQU   10
FF        EQU   12
CR        EQU   13
ESC       EQU   27
US        EQU   31
SPACE     EQU   32
XON       EQU   17
XOFF      EQU   19
PF1       EQU   192
;
QUEUE     EQU   224             ; Anger hur m}nga k|ade tecken som
                                ; f}r finnas i mottagarbufferten utan
                                ; att XOFF skickas.
;
;----------------------------------------------------------------------
;     Initierings rutiner.
;----------------------------------------------------------------------
;
          ORG   BEG_LOC

          JP    PRG_INI
          JP    REMOTERM
;
PRG_INI   DI

          LD    HL,DB_RCA
          LD    (DARVEK+4),HL

          LD    HL,SA_TBE
          LD    (SIOVEK+8),HL
          LD    HL,SA_EXT
          LD    (SIOVEK+10),HL
          LD    HL,SA_RCA
          LD    (SIOVEK+12),HL
          LD    HL,SA_SPC
          LD    (SIOVEK+14),HL

          EX    DE,HL
          LD    A,(HL)
          INC   HL
          LD    (STATUS),A
          CALL  COM_INI

          EI

          RET

COM_INI   LD    A,(HL)
          AND   A
          RET   Z
          LD    C,(HL)
          INC   HL
          LD    A,(HL)
          INC   HL
          OUT   (C),A
          JR    COM_INI

REMOTERM  PUSH  IY
          LD    IY,SYS_VAR
          CALL  MAIN
          POP   IY
          RET

MAIN      LD    (SP_SAVE),SP

LP300     CALL  GET_GX
          CALL  DISP_CH
          JR    LP300
;
;     / DISP_CH /
;
;     Skriver ut ett tecken p} sk{rmen och uppdaterar mark|ren.
;
;     In :
;     A skall inneh}lla tecknet.
;
DISP_CH   CP    SPACE
          RET   C
          LD    B,A
          LD    C,49
          LD    A,15
          OUT   (CRTCCO),A
          IN    L,(C)
          DEC   A
          OUT   (CRTCCO),A
          IN    H,(C)
          SET   6,H
          LD    (HL),B
          CALL  CUR_RI
          RET   C
          LD    A,CR
          CALL  ABC_CON
          LD    A,LF
          CALL  ABC_CON
          RET
;
;     / GET_GX /
;
;     Returnerar f|rsta tecken fr}n datorn som inte var kontrolltecken.
;
;     Ut :
;     A inneh}ller tecknet.
;
GET_GX    LD    HL,(LINE)
          LD    C,L
          LD    B,H
          ADD   HL,HL
          ADD   HL,HL
          ADD   HL,BC
          ADD   HL,HL
          ADD   HL,HL
          ADD   HL,HL
          ADD   HL,HL
          LD    A,(COLUMN)
          LD    C,A
          LD    B,120
          ADD   HL,BC

          LD    A,14
          LD    C,CRTCDA
          OUT   (CRTCCO),A
          OUT   (C),H
          INC   A
          OUT   (CRTCCO),A
          OUT   (C),L

LP400     LD    A,(KEYFLG)
          AND   128
          CALL  NZ,KEY_CH
          LD    HL,(READ_PEK)
          LD    A,(WRT_PEK)
          SUB   L
          JR    Z,LP400
          CP    128
          CALL  Z,IF_XOFF
          LD    A,(HL)
          INC   L
          LD    (READ_PEK),HL
          CALL  ABC_CON
          JR    GET_GX

IF_XOFF   LD    A,(X_FLOW)
          CP    XOFF
          RET   NZ
          LD    A,SPACE
          LD    (32640+79),A
          LD    A,XON
          LD    (X_FLOW),A
          JP    SND_SIO

KEY_CH    XOR   A
          LD    (KEYFLG),A
          LD    A,(KEYCHR)
          CP    PF1
          JP    NZ,SND_SIO
          CALL  GET_CH
          CP    PF1
          JP    Z,SND_SIO
          LD    SP,(SP_SAVE)
          RET
;
;     / ABC_CON /
;
;     Tar hand om kontrolltecken som vid PRINT,PUT.
;
;     In :
;     A inneh}ller tecknet.
;
ABC_CON   CP    BEL
          JR    Z,BEL_C
          CP    BS
          JR    Z,BS_C
          CP    LF
          JR    Z,LF_C
          CP    FF
          JR    Z,FF_C
          CP    CR
          JR    Z,CR_C
          CP    ESC
          JR    Z,ESC_C
          POP   BC
          RET

BEL_C     LD    B,200
LP900     DEC   A
          JR    NZ,LP900
          IN    A,(5)
          DJNZ  LP900
          RET

BS_C      CALL  CUR_LE
          RET   P
          CALL  CUR_UP
          LD    (IY+INCOLUMN),79
          RET   P
          LD    (IY+INLINE),23
          RET

LF_C      CALL  CUR_DO
          RET   C
          LD    HL,30720+80
          LD    DE,30720
          LD    BC,1840
LP500     LDI
          JP    PE,LP500
          LD    B,80
LP600     DEC   HL
          LD    (HL),SPACE
          DJNZ  LP600
          RET

FF_C      XOR   A
          LD    (LINE),A
          LD    (COLUMN),A
          LD    HL,30720
          LD    BC,1920
LP700     LD    (HL),SPACE
          INC   HL
          DEC   BC
          LD    A,B
          OR    C
          JR    NZ,LP700
          RET

CR_C      XOR   A
          LD    (COLUMN),A
          RET

ESC_C     CALL  GET_GX
          CP    '='
          JR    Z,CUR_POS
          POP   BC
          RET

CUR_POS   CALL  GET_GX
          SUB   SPACE
          CP    24
          RET   NC
          LD    (LINE),A
          CALL  GET_GX
          SUB   SPACE
          CP    80
          RET   NC
          LD    (COLUMN),A
          RET
;
;     / SND_SIO /
;
;     Skickar ett tecken till SIO.
;
;     In :
;     A skall inneh}lla tecknet.
;
SND_SIO   PUSH  AF
LP100     IN    A,(SIOACO)
          AND   00000100B
          JR    Z,LP100
          POP   AF
          OUT   (SIOADA),A
          RET
;
;     Subrutiner.
;
;     / GET_CH /
;
;     V{ntar p} tangent nedtryckning.
;
;     Ut :
;     A inneh}ller tecknet.
;
GET_CH    LD    A,(KEYFLG)
          AND   128
          JR    Z,GET_CH
          XOR   A
          LD    (KEYFLG),A
          LD    A,(KEYCHR)
          RET
;
;     / CUR_UP /
;
;     Flyttar mark|ren en rad upp}t.
;
CUR_UP    DEC   (IY+INLINE)
          RET   P
          LD    (IY+INLINE),0
          RET
;
;     / CUR_DO /
;
;     Flyttar mark|ren en rad ned}t.
;
CUR_DO    INC   (IY+INLINE)
          LD    A,(LINE)
          CP    24
          RET   C
          LD    (IY+INLINE),23
          RET
;
;     / CUR_LE /
;
;     Flyttar mark|ren ett steg }t v{nster.
;
CUR_LE    DEC   (IY+INCOLUMN)
          RET   P
          LD    (IY+INCOLUMN),0
          RET
;
;     / CUR_RI /
;
;     Flyttar mark|ren ett steg }t h|ger.
;
CUR_RI    INC   (IY+INCOLUMN)
          LD    A,(COLUMN)
          CP    80
          RET   C
          LD    (IY+INCOLUMN),79
          RET
;
;     Interrupt rutiner.
;
;     DART-B.
;
DB_RCA    DI 
          PUSH  AF
          IN    A,(DARBDA)
          LD    (KEYCHR),A
          LD    A,128
          LD    (KEYFLG),A
          POP   AF
          EI
          RETI
;
;     SIO-A.
;
SA_TBE    RETI

SA_EXT    RETI

SA_RCA    DI
          PUSH  AF
          IN    A,(SIOADA)
          PUSH  HL
          LD    HL,(WRT_PEK)
          LD    (HL),A
          INC   L
          LD    (WRT_PEK),HL
          LD    A,(READ_PEK)
          SUB   L
          CP    256-QUEUE
          CALL  Z,STOP_FLOW
          POP   HL
          POP   AF
          EI
          RETI

STOP_FLOW LD    A,127
          LD    (32640+79),A
          LD    A,XOFF
          LD    (X_FLOW),A
          JP    SND_SIO

SA_SPC    DI
          PUSH  AF
          LD    A,00110000B
          OUT   (SIOACO),A
          POP   AF
          EI
          RETI
;
; Systemvariabler.
;
SYS_VAR   EQU   $
LINE      DEFW  0
COLUMN    DEFW  0
STATUS    DEFB  0
WRT_PEK   DEFW  COM_BUF
READ_PEK  DEFW  COM_BUF
X_FLOW    DEFB  XON
SP_SAVE   DEFW  0

INLINE    EQU   LINE-SYS_VAR
INCOLUMN  EQU   COLUMN-SYS_VAR
INSTATUS  EQU   STATUS-SYS_VAR
;
          END
