; *************************************************
; *
; * REMOTE ABC800    (c) LID@N DATA  850412
; *

                ORG     64000                   ; Laddrutinens plats
START           EQU     0

INIT            EQU     $

                LD      HL,00D80H               ; S|k adress till fast CR LF
                LD      (65506),HL              ; Ladda KEY-buf med RET
                LD      HL,INIT                 ; Adress att l{gga motag str{ng 
                LD      BC,4                    ; Max str{ng l{ngd
                CALL    5                       ; L{s en rad
                LD      HL,(65504)              ; Ladda HL med DE save adr till 
                LD      (CRLF),HL               ; CR LF i tolken

                LD      HL,TKNIN                ; L{nka in l{s ett tecken fr}n
                LD      (65484),HL              ; SIO:n. (interrupt)

                LD      HL,TKNUT                ; L{nka in skriv ett tecken
                LD      (65480),HL              ; till SIO:n  (interrupt)

                LD      HL,EXTCH                ; L{nka in INT f|r extern
                LD      (65482),HL              ; signalf|r{ndring

                LD      HL,0                    ; L{nka ur filmapp (V24)
                LD      (65356),HL              ; Tar bort |pnnade filer !

                LD      HL,(65360)              ; L{nka ny CON rutin i filmapp
                LD      A,(HL)                  ; L{s nuvarande vidarepekare
                INC     HL
                LD      H,(HL)
                LD      L,A
                LD      (CON2),HL               ; L{gg ut gamla vidarepekaren
                LD      HL,NYCON+5              ; Vid.pekare + dev namn
                LD      (65360),HL              ; dvs adress till nya CON rut.

                LD      HL,(65403)              ; L{nka om enhetslistan s}
                LD      (NYCON),HL              ; att nya CON rutinen kommer
                LD      HL,NYCON                ; f|rst i listan
                LD      (65403),HL

                LD      HL,(65425)              ; Ny l{s ett tecken
                LD      (GET),HL
                LD      HL,CONSI
                LD      (65425),HL

                LD      A,0                     ; Initiera interrupt
                OUT     (65),A                  ; Se SIO manual f|r
                LD      A,16                    ; n{rmare detaljer
                OUT     (65),A
                LD      A,1
                OUT     (65),A
                LD      A,27
                OUT     (65),A

                RET

                ORG     32768

; *************************************
; *
; * CONSI
; *

CONSI           EQU     $
GET             EQU     $+1
                CALL    0                       ; Anropa l{s ett tecken
                PUSH    AF                      ; Dessa register anv{nds
                PUSH    HL
                PUSH    DE
CRLF            EQU     $+1
                LD      HL,0                    ; Initieras med adr till CR LF
                LD      DE,(65504)              ; DE-save
                XOR     A                       ; Nollst{ll carry
                SBC     HL,DE                   ; Test om HL=DE
                POP     DE
                POP     HL
                JR      Z,FORTS1
                POP     AF                      ; HL <> DE
                PUSH    AF                      ; Det finns tecken i ed.buffert 
                CP      9                       ; Testa om h|ger pil anv{nds
                JR      NZ,FORTS2               ; Om ej A=9 forts{tt
                PUSH    DE
                LD      DE,(65504)              ; DE-save
                LD      A,(DE)                  ; Ladda A med tecken fr}n
                POP     DE                      ; editeringsbuffert
                JR      ATEST

FORTS1          EQU     $
                LD      A,(INPFLAG)             ; Test om inputflagga satt
                AND     255
                JR      Z,EJEKO                 ; Flagga=0 inget eko ges

FORTS2          EQU     $
                POP     AF
                CP      8                       ; Test om backspace
                JR      Z,BACKSP
                CP      12                      ; Test om FF
                CALL    Z,TKUT
                CP      24                      ; Test om Clear Entry
                JR      Z,CLENTRY
                PUSH    AF

ATEST           EQU     $                       ; Test om ASCII tkn 32-127
                CP      32
                JR      C,EJEKO                 ; Mindre {n 32 ?
                CP      128
                JR      NC,EJEKO                ; St|trre {n 127 ?
                CALL    TKUT                    ; S{nd tecken
                LD      A,1                     ; Test om inputbuffert full
                CP      B
                CALL    Z,BACK                  ; I s}dana fall backa ett steg

EJEKO           EQU     $
                POP     AF
                RET                             ; Klart

BACKSP          EQU     $                       ; Backspace
                PUSH    AF
                LD      A,B                     ; Test om tecken finns i
                CP      C                       ; inputbuffert
                JR      Z,EJEKO
                POP     AF

BACK            EQU     $                       ; Backa ett steg (med radering) 
                PUSH    HL
                PUSH    BC
                LD      BC,3
                LD      HL,DATA
                CALL    V24UT                   ; S{nd 8,32,8
                POP     BC                      ; Se dataarean DATA
                POP     HL
                RET

CLENTRY         EQU     $                       ; Clear Entry (Ce)
                PUSH    AF
                PUSH    BC
LOOP4           EQU     $ 
                LD      A,C                     ; LOOP tills B=C
                SUB     B                       ; C=max antal tkn i inbuffert
                JR      Z,KLART3                ; B=buffert pos
                CALL    BACK
                INC     B
                JR      LOOP4
KLART3          EQU     $
                POP     BC
                POP     AF
                RET

TKUT            EQU     $                       ; S{nd ut tkn i A
                PUSH    BC
                PUSH    HL
                LD      (DATA+3),A              ; Ladda dataarea med tkn
                LD      BC,1                    ; Antal tecken
                LD      HL,DATA+3               ; Adress till data
                CALL    V24UT                   ; Anropa s{nd rutinen
                POP     HL
                POP     BC
                RET

DATA            DEFB    8                       ; Dataarea
                DEFB    32
                DEFB    8
                DEFB    0

; *****************************************
; *
; *  INT RUTIN ifall DCD faller
; *

EXTCH           EQU     $
                DI
                PUSH    AF
                LD      A,0                     ; Peka ut register 0
                OUT     (65),A
                LD      A,16
                OUT     (65),A                  ; Nollst{ll latch
                IN      A,(65)                  ; L{s reg 0 i SIO
                AND     8                       ; Titta om DCD finns
                JR      NZ,RET1
                LD      HL,0                    ; Laddas med RET adress
                PUSH    HL                      ; Adress 0 p} stack
                LD      A,1
                OUT     (65),A                  ; Peka ut register 0
                DEC     A
                OUT     (65),A                  ; Nollst{ll INT i SIO
                EI
                RETI

RET1            EQU     $
                POP     AF
                EI
                RETI

; ***********************************
; *
; *  INTERRUPT RUTIN (Recive)
; *

TKNIN           EQU     $
                DI
                PUSH    AF
                PUSH    HL
                IN      A,(64)                  ; Tag emot tecken
                LD      (65507),A               ; Tangentbordsbuffert
                CP      3                       ; Test om CTRL+C
                JR      NZ,KLART
                LD      HL,(65413)              ; CTRL+C pekare
                SET     0,(HL)                  ; S{tt CTRL flagga
KLART           EQU     $
                LD      A,128                   ; S{tt tangentbordsflagga
                LD      (65506),A
                POP     HL
                POP     AF
                EI
                RETI


; **********************************
; *
; *  INTERRUPT RUTIN (Transmit)
; *

TKNUT           EQU     $                       ; Rutin s{nder 1 tkn fr}n
                DI                              ; s{ndbuffert & {ndrar buf
                PUSH    AF                      ; pekare.
                PUSH    HL
                LD      HL,(ANT)                ; Antal tecken i buffert
                LD      A,H
                OR      L
                JR      NZ,S[ND                 ; Finns tecken i buffert ?
INTAV           EQU     $                       ; Inga tecken i buffert !
                LD      A,0                     ; Peka ut register 0
                OUT     (65),A
                LD      A,40                    ; St{ng av transmit INT
                OUT     (65),A
                LD      A,255
                LD      (FLAG),A                ; S{tt flagga buffert=tom
                JR      KLART2

S[ND            EQU     $
                DEC     HL                      ; Minska ant tecken
                LD      (ANT),HL                ; L{gg tillbaks
                LD      HL,(PEKARE)             ; HL=Pekare till tecken
                LD      A,(HL)
                INC     HL                      ; \ka pos pekare
                LD      (PEKARE),HL             ; L{gg tillbaks
                OUT     (64),A                  ; S{nd tecken

KLART2          EQU     $                       ; ]terst{ll
                POP     HL
                POP     AF
                EI
                RETI

PEKARE          DEFW    0                       ; Pos i buffert
ANT             DEFW    0                       ; Antal i buffert
FLAG            DEFB    0                       ; Flagga att tkn i Tx buffert
INPFLAG         DEFB    0                       ; INPUT flagga


; ************************************
; *
; * CONRUTIN f|r hantering av utskrift
; *

NYCON           EQU     $
                DEFW    0
                DEFM    'CON'                   ; Enhetsnamn
                DEFW    CONRUT                  ; Adress till rutin
CONRUT          EQU     $
                CP      4                       ; Test om PRINT
                CALL    Z,S[NDV24
                CP      6                       ; Test om PUT
                CALL    Z,S[NDV24
                CP      3                       ; Test om INPUT
                JR      NZ,ORGCON
                LD      A,255
                LD      (INPFLAG),A             ; S{tt input flagga
                LD      A,3

ORGCON          EQU     $
CON2            EQU     $+1
                CALL    0                       ; Anrop av original CON rutin
                PUSH    AF
                LD      A,0
                LD      (INPFLAG),A             ; Nollst{ll inputflagga
V[NTA           EQU     $                       ; Ev. inmatning klar nu
                LD      A,(FLAG)                ; Test Tx buffert {r tom
                AND     255
                JR      Z,V[NTA                 ; V{nta p} att buffert blir tom 
                POP     AF
                RET

V24UT           EQU     $                       ; Rutin som s{nder str{ng p}
                CALL    S[NDV24                 ; V24 HL=adr BC=ant
                PUSH    AF
                JR      V[NTA

; *********************************
; *
; * INIT s{ndning av str{ng
; *


S[NDV24         EQU     $
                PUSH    AF
                LD      A,B                     ; Titta om det skall s{ndas
                OR      C                       ; dvs om BC=0
                JR      Z,V24KLART

                PUSH    HL
                INC     HL                      ; \ka POS pekare
                LD      (PEKARE),HL             ; L{gg ut pekare
                LD      H,B
                LD      L,C                     ; HL=BC (dvs ant tecken)
                DEC     HL                      ; Minska antal tecken
                LD      (ANT),HL                ; L{gg ut antal
                POP     HL                      ; HL=pekare

                LD      A,0                     ; Nollst{ll Tx buf flagga
                LD      (FLAG),A
                LD      A,(HL)
                OUT     (64),A                  ; S{nd tecken
V24KLART        EQU     $                       ; Nu startas Tx INT automatiskt 
                POP     AF
                RET
SLUT            EQU     $                       ; Anv{nds f|r H|ja golvet


                END     START

