1 REM Ins{nd av Kristoffer Eriksson <5357>    1987-12-11 19.43.54 (KERMIT)
; Fil: OPENFILE.ASM
; Av:  Kristoffer Eriksson, "SKE" <5357>, 1987.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
;      / 87-08-02 / SKE  /
; 1.00 / 87-11-13 / SKE  / Klart.
;
; Dessa rutiner ers{tter OPNX i Basic-prommen. Skillnaden {r att de h{r
; rutinerna returnerar en felkod vid fel i st{llet f|r att hoppa raka v{gen
; till SOFTNOCO. Tillsamman med WORDSPLT.ASM kan de {ven ers{tta OPNCMD.
; Rutinerna {r i huvudsak avskrifter av OPNX. Till{gg av default-filtyp
; hanteras dock inte.

            EXTERN OpenFile, OpenUnForm, FNamebuf

IO:         =  90
Unpfd:      =  99
DevTba:     =  65403

LU.Stat:    =  +3
LU.Dcb:     =  +4
LU.Pos:     =  +6
LU.Wid:     =  +8
LU.Eof:     =  +13
LU.Bufn:    =  +15
LU.Rndrc:   =  +17
LU.Rndo:    =  +19
LU.Bufh:    =  +20
LUS.Opn:    =  0

                                      ; Startv{rden f|r del av LU-blocket.
LU.Init:    DEFW   -1                 ; LU.Eof
            DEFW   -1                 ; LU.Bufn
            DEFW   0                  ; LU.Rndrc
            DEFB   3                  ; LU.Rndo
LU.InitEnd:


; OpenFile |ppnar en fil vars namn {r f{rdiguppdelat s} som Unpfd g|r.
; Den initierar vissa f{lt i LU-blocket, letar upp enheten i enhetslistan,
; och anropar dess OPEN- eller PREPARE-rutin med hj{lp av IO.
;
; In:     IX = Pekare till ledigt LU-block.
;         HL = Pekare till formaterat filnamn.
;          A = 0: OPEN, 1: PREPARE.
; Ut:  Carry = Sann: Fel uppt{ckt, Falsk: OK.
;          A = Felkod om sann Carry.
; Endast IX och IY bevaras op}verkade.

OpenFile:   PUSH   AF                 ; Spara operationsvalet.
            PUSH   HL                 ; Spara filnamnspekaren.
            PUSH   IX                 ; Initiera del av LU-blocket.
            POP    HL
            LD     BC,LU.Eof
            ADD    HL,BC
            EX     DE,HL
            LD     HL,LU.Init
            LD     BC,LU.InitEnd-LU.Init
            LDIR
            POP    DE                 ; Filnamnet.
            LD     HL,(DevTba)        ; HL <- B|rjan av enhetslistan.
DevLoop:    LD     A,H
            OR     L
            JR Z   Err21P             ; Om listan {r slut, {r enhetsnamnet fel
            LD     C,(HL)             ; BC <- Adress till n{sta enhet.
            INC    HL
            LD     B,(HL)
            INC    HL
            PUSH   BC
            PUSH   DE
            EX     DE,HL
            LD     BC,11
            ADD    HL,BC              ; HL <- Adress till filens enhetsnamn.
            LD     C,3                ; 3 tecken att j{mf|ra i namnet.
CmpLoop:    LD     A,(DE)
            INC    DE
            CPI
            JR NZ  NextDev            ; Avbryt om tecken ej lika.
            JP PE  CmpLoop            ; J{mf|r n{sta tkn om BC<>0.
            EX     DE,HL
            LD     (IX+LU.Dcb),L      ; Lagra pekare till drivrutinadress.
            LD     (IX+LU.Dcb+1),H
NextDev:    POP    DE                 ; DE <- Filnamnet igen.
            POP    HL                 ; HL <- N{sta enhet i listan.
            JR NZ  DevLoop
            POP    AF
            AND    A
            JR Z   DoIO
            LD     (IX+LU.Eof),0      ; St{ll fill{ngden till noll vid PREPARE
            LD     (IX+LU.Eof+1),0
DoIO:       CALL   IO                 ; Anropa drivrutin, A = Op, DE = Namn.
            RET C                     ; Fel uppt{ckt.
            SET    LUS.Opn,(IX+LU.Stat)
            LD     (IX+LU.Pos),0
            LD     (IX+LU.Wid),C
            LD     (IX+LU.Bufh),D
            RET

Err21P:     POP    AF
            SCF
Err21:      LD     A,21
            RET


; OpenUnForm |ppnar en fil med friformatsnamn. Unpfd anropas f|r att
; kontrollera och dela upp filnamnet i dess delar, varefter OpenFile
; anropas f|r att |ppna filen. Samma anropsparametrar som f|r OPNX.
; En fast filnamnsbuffert anv{nds till skillnad fr}n OPNX som l{gger
; upp den p} stacken. Det h{r {r effektivare och g|r att man kan inspektera
; det uppdelade filnamndet i FNameBuf i efterhand.
;
; In:     IX = Pekare till ledigt LU-block.
;         HL = Pekare till ej formaterat filnamn.
;         BC = L{ngd av filnamnet.
;          A = 0: OPEN, 1: PREPARE.
; Ut:  Carry = Sann: Fel uppt{ckt, Falsk: OK.
;          A = Felkod om sann Carry.
; Endast IX och IY bevaras op}verkade.

OpenUnForm: LD     DE,FNameBuf
            PUSH   AF
            PUSH   DE
            CALL   Unpfd              ; Formatera filnamn fr}n HL till DE.
            POP    HL                 ; HL <- B|rjan av buffert med filnamnet.
            JR C   Err21P
            POP    AF                 ; A <- Operationsvalet.
            JP     OpenFile

FNameBuf:   DEFS   14
