1 REM Ins{nd av Per Svebeck <2635>    1985-05-17 15.52.37
;*******************************************************************************
;*******************************************************************************
;**                                                                           **
;** PROGRAM OMRVAL           J FORNAEUS        VER 1.4    DECEMBER 1982       **
;**                                                                           **
;*******************************************************************************
;*******************************************************************************
;
; Programmet l}ter anv{ndaren med hj{lp av en ruta markera den del av sk{rmen
; som skall skrivas ut. Sifferknapparna flyttar aktuellt h|rn. Siffra 5 byter
; h|rn mellan |vre v{nstra och nedre h|gra. Valet avslutas d} man trycker p}
; return.
;
        ORG 59500        ;Programmets startadress
;
;
;
;****** KONSTANTER *************************************************************
;
HR      EQU 07FFDH       ;Adress till rutin som flyttar data till&fr}n HR-minne 
TGFLAG  EQU 0FFE2H       ;Adress till tangentbordsflagga
TGBUF   EQU 0FFE3H       ;Adress till tangentbordsbuffert
XCUR    EQU 0FF52H       ;Adress till cursorns kolumn
YCUR    EQU 0FF53H       ;Adress till cursorns rad
OUTTXT  EQU 0000BH       ;Adress till rutin som skriver ut text p} sk{rm
;
;
;
;****** VARIABLER **************************************************************
;
XZOOM  DEFB 0            ;XZOOM
RUT\X  DEFB 0            ;\vre h|rnets x-koordinat 
RUT\Y  DEFB 0            ;\vre h|rnets y-koordinat
RUTNX  DEFB 0            ;Nedre h|rnets x-koordinat
RUTNY  DEFB 0            ;Nedre h|rnets y-koordinat
X      DEFB 0            ;X-koordinat f|r aktuellt h|rn
Y      DEFB 0            ;Dito y
H\NVAL DEFB 0            ;[r 0 om aktuellt h|rn {r |vre, 1 annars
;
;
;
;****** V[NTLOOP ***************************************************************
;
OMRVAL LD   A,0          ;St{ll in H\NVAL: |vre h|rnet b|rjar
       LD   (H\NVAL),A
       LD   A,(RUT\X)    ;St{ll in f|rsta x-koordinat |vre h|rn
       LD   (X),A
;
       LD   A,(RUT\Y)    ;St{ll in f|rsta y-koordinat |vre h|rn
       LD   (Y),A
;
       CALL RITRUT       ;Rita ut f|rsta rutan
;
V[LOOP CALL BERZOM       ;Ber{kna max till}ten XZOOM med nuvarande inst{llning
       LD   HL,TGFLAG    ;HL pekar p} tangentbordsflagga
       LD   A,(HL)       ;Tangentbordsflagga
       AND  128
       JR   NZ,KNAPP     ;]tg{rda om knapp nedtryckts
;
       CALL CURSOR       ;Rita cursor
       CALL CURSOR       ;Sudda cursor
;
       JR   V[LOOP
;
;
;
;****** Vilken knapp har nedtryckts? *******************************************
;
KNAPP  LD   A,0          ;Nollst{ll tangentbordsflagga
       LD   HL,TGFLAG
       LD   (HL),A
;
       LD   HL,TGBUF     ;HL pekar p} tangentbordsbuffert
       LD   A,(HL)       ;L{s in tecknet fr}n tangentbordsbuffert
;
       SUB  13
       JR   NZ,NEXT1
       CALL RITRUT       ;Sudda ut rutan om return nedtryckts
       RET               ;OMRVAL SLUT
;
NEXT1  SUB  36           ;1
       JR   NZ,NEXT2
       CALL NED
       CALL V[NTER
       CALL RUTA
       JP   V[LOOP
;
NEXT2  DEC  A            ;2
       JR   NZ,NEXT3
       CALL NED
       CALL RUTA
       JP   V[LOOP
;
NEXT3  DEC  A            ;3
       JR   NZ,NEXT4
       CALL NED
       CALL H\GER
       CALL RUTA
       JP   V[LOOP
;
NEXT4  DEC  A            ;4
       JR   NZ,NEXT5
       CALL V[NTER
       CALL RUTA
       JP   V[LOOP
;
NEXT5  DEC  A            ;5
       JR   NZ,NEXT6
       CALL BYTH\N
       JP   V[LOOP
;
NEXT6  DEC  A            ;6
       JR   NZ,NEXT7
       CALL H\GER
       CALL RUTA
       JP   V[LOOP
;
NEXT7  DEC  A            ;7
       JR   NZ,NEXT8
       CALL UPP
       CALL V[NTER
       CALL RUTA
       JP   V[LOOP
;
NEXT8  DEC  A            ;8
       JR   NZ,NEXT9
       CALL UPP
       CALL RUTA
       JP   V[LOOP
;
NEXT9  DEC  A            ;9
       JP   NZ,V[LOOP    ;Inget giltigt tecken inl{st
       CALL UPP
       CALL H\GER
       CALL RUTA
       JP   V[LOOP
;
;
;
;****** BER[KNA MAX TILL]TEN XZOOM *********************************************
;
ASCZOM DEFB 2             ;Variabel d{r xzoom lagras som ASCII
       DEFB 7             ;Bell dvs signal n{r zoomv{rdet {ndras
FGZOOM DEFB 0             ;H{r lagras f|reg}nde zoom
;
BERZOM LD   A,(RUTNX)     ;A=RUTNX
       LD   HL,RUT\X      ;HL pekar p} RUT\X
       SUB  (HL)          ;A=RUTNX-RUT\X
       LD   E,A           ;DE=A
       LD   D,0
;
       LD   B,8           ;B=8 dvs max till}ten zoom {r 8 g}nger
       LD   A,0           ;A=0
       LD   HL,576        ;HL=576 dvs max bredd f|r en rad
;
LOOP30 SBC  HL,DE         ;HL=HL-DE
       JP   M,EXIT30      ;L{mna om negativt
       INC  A
       DJNZ LOOP30
;
EXIT30 LD   (XZOOM),A     ;A=INT(576/(RUTNX-RUT\X))
       ADD  A,48          ;G|r om A till ASCII
       LD   (ASCZOM),A
;
       LD   A,23          ;St{ll cursor p} rad 23
       LD   HL,YCUR
       LD   (HL),A
;
       LD   A,78          ;St{ll cursor i kolumn 78
       LD   HL,XCUR
       LD   (HL),A
;
       LD   A,(FGZOOM)    ;Skiljer sig gamla och nya zoomv{rdet?
       LD   HL,XZOOM
       CPI
       JR   Z,EJSKRV      ;Skriv inget om nya zoomv{rdet {r samma som gamla
;
       LD   HL,ASCZOM     ;HL pekar p} ASCII-tecken som skall skrivas
       LD   BC,2          ;2 tecken skrivs, zoomv{rde och tutning
       CALL OUTTXT
;
EJSKRV LD   A,(XZOOM)     ;Skriv in nya zoomv{rdet i "f|reg}ende zoomv{rde"
       LD   (FGZOOM),A
;
       RET                ;Berzom slut
;
;
;
;******  [NDRA H\RNETS KOORDINATER *********************************************
;
H\GER  LD   A,239        ;A=239
       LD   HL,X         ;HL pekar p} X
       CPI               ;[r X=239?
       RET  Z            ;Om X=239 |kas ej X
;
       LD   A,0          ;Nedre h|rnet f}r alltid flyttas }t h|ger
       LD   HL,H\NVAL    ;men om H\NVAL=0 m}ste avst}ndet mellan de
       CPI               ;de vertikala linjerna kontrolleras
       JR   NZ,OKAX
;
       LD   A,(RUTNX)    ;Om avst}ndet mellan v{nster och h|ger kant {r
       LD   HL,RUT\X     ;mindre {n 4 f}r inte |vre h|rnet f|ras }t h|ger
       SUB  (HL)
       SUB  5            ;A=RUTNX-RUT\X-5
       RET  Z
;
OKAX   LD   A,(X)        ;\ka X
       INC  A
       LD   (X),A
       RET               ;H|ger slut
;
;
V[NTER LD   A,0
       LD   HL,X
       CPI
       RET  Z            ;Om X=0 minskas ej X
;
       LD   A,0          ;\vre h|rnet f}r alltid flyttas }t v{nster
       LD   HL,H\NVAL
       CPI
       JR   Z,MINKAX     ;Om H\NVAL=0 (|vre) minska X
;
       LD   A,(RUTNX)    ;Om avst mellan h|ger och v{nster kant {r mindre
       LD   HL,RUT\X     ;{n 4 f}r inte nedre h|rnet f|ras }t v{nster
       SUB  (HL)
       SUB  5
       RET  Z
;
MINKAX LD   A,(X)        ;Minska X
       DEC  A
       LD   (X),A
       RET               ;V{nter slut
;
;
NED    LD   A,239
       LD   HL,Y
       CPI
       RET  Z            ;Om Y=239 |kas ej Y
;
       LD   A,0          ;Nedre h|rnet f}r alltid f|ras ned}t
       LD   HL,H\NVAL
       CPI
       JR   NZ,OKAY
;
       LD   A,(RUTNY)    ;Om avst}ndet mellan |vre och undre kant {r mindre
       LD   HL,RUT\Y     ;{n 4 f}r inte |vre h|rnet f|ras ned}t
       SUB  (HL)
       SUB  5
       RET  Z
;
OKAY   LD   A,(Y)        ;\ka Y
       INC  A
       LD   (Y),A
       RET               ;Ned slut
;
;
UPP    LD   A,0
       LD   HL,Y
       CPI
       RET  Z            ;Om Y=0 minskas ej Y
;
       LD   A,0          ;\vre h|rnet f}r alltid f|ras upp}t
       LD   HL,H\NVAL
       CPI
       JR   Z,MINKAY
;
       LD   A,(RUTNY)    ;Om avst}ndet mellan |vre och undre kant {r mindre
       LD   HL,RUT\Y     ;{n 4 f}r inte nedre h|rnet f|ras upp}t
       SUB  (HL)
       SUB  5
       RET  Z
;
MINKAY LD   A,(Y)        ;Minska Y
       DEC  A
       LD   (Y),A
       RET               ;Upp slut
;
;
;
;****** BYT H\RN ***************************************************************
;
BYTH\N LD   A,0          ;Vilket h|rn g{ller f|re byte
       LD   HL,H\NVAL
       CPI
       JR   Z,NEDRE      ;Om H\NVAL=0 sker byte till nedre h|rn
;
       LD   A,(RUT\X)    ;L}t X och Y f} |vre h|rnets koordinater
       LD   (X),A
       LD   A,(RUT\Y)
       LD   (Y),A
;
       LD   A,0          ;L}t H\NVAL indikera att |vre h|rnet g{ller
       LD   (H\NVAL),A
;
       RET               ;Byth|n slut
;
;
NEDRE  LD   A,(RUTNX)    ;L}t X och Y f} nedre h|rnets koordinater
       LD   (X),A
       LD   A,(RUTNY)
       LD   (Y),A
;
       LD   A,1          ;L}t H\NVAL indikera att nedre h|rnet g{ller
       LD   (H\NVAL),A
;
       RET               ;Byth|n slut
;
;
;
;****** RITA RUTAN *************************************************************
;
RUTA   CALL RITRUT       ;Sudda gamla rutan
;
       LD   A,0
       LD   HL,H\NVAL
       CPI
       JR   Z,OH\RN      ;Om H\NVAL=0 {r det |vre h|rnet som {ndrats
;
       LD   A,(X)        ;Ladda koordinater f|r nedre h|rn
       LD   (RUTNX),A
       LD   A,(Y)
       LD   (RUTNY),A
       CALL RITRUT       ;Rita rutan
       RET               ;Rita slut
;
OH\RN  LD   A,(X)        ;Ladda koordinater f|r |vre h|rn
       LD   (RUT\X),A
       LD   A,(Y)
       LD   (RUT\Y),A
       CALL RITRUT
       RET               ;Rita slut
;
;
;
;****** RITA CURSOR I AKTUELLT H\RN ********************************************
;
CURX   DEFB 0            ;Cursorns x-koordinat
CURY   DEFB 0            ;Cursorns y-koordinat
;
CURSOR LD   HL,H\NVAL    ;Cursorns x och y beror av vilket h|rn den skall ritas 
       LD   A,0
       CPI
       JR   Z,UPPE       ;Om H\NVAL=0 g{ller |vre h|rn
;
NERE   LD   A,(X)        ;CURX=X-4
       SUB  4
       LD   (CURX),A
       LD   A,(Y)        ;CURY=Y-4
       SUB  4
       LD   (CURY),A
       JR   PASSER
;
UPPE   LD   A,(X)        ;CURX=X+1
       INC  A
       LD   (CURX),A
       LD   A,(Y)        ;CURY=Y+1
       INC  A
       LD   (CURY),A
;
PASSER LD   A,4          ;Linjer{knare, cursorn best}r av 4 vertikala linjer
       LD   B,A
       LD   A,(CURX)     ;X-koordinat
       LD   C,A
;
CULOOP LD   A,(CURY)     ;Ladda koordinater f|r en horisontell linje
       LD   (VERY1),A
       ADD  A,3          ;Linjerna {r 4 pixels h|ga
       LD   (VERY2),A
       LD   A,C
       LD   (VERX),A
;
       PUSH BC           ;Spara BC
       CALL VERLIN       ;Rita en linje
       POP  BC           ;]terkalla BC
;
       INC  C            ;Tag n{sta linje i y-led
       DJNZ CULOOP
;
       RET               ;Cursor slut
;
;
;
;*******************************************************************************
;*                                                                             *
;* PROCEDUR RITRUT                                                             *
;*                                                                             *
;* Ritar ruta med |vre v{nstra h|rn i RUT\X,RUT\Y och nedre h|gra h|rn         *
;* i RUTNX,RUTNY. Rutan {r komplementerad.                                     *
;*                                                                             *
;*******************************************************************************
;
;
;
RITRUT LD   A,(RUT\X)    ;Rita |vre horisontella linjen
       LD   (HORX1),A
       LD   A,(RUTNX)
       LD   (HORX2),A
       LD   A,(RUT\Y)
       LD   (HORY),A
;
       CALL HORLIN
;
;
       LD   A,(RUTNX)    ;Rita h|gra vertikala linjen
       LD   (VERX),A
       LD   A,(RUT\Y)
       LD   (VERY1),A
       LD   A,(RUTNY)
       LD   (VERY2),A
;
       CALL VERLIN
;
;
       LD   A,(RUTNY)     ;Rita nedre horisontella linjen
       LD   (HORY),A
       LD   A,(RUT\X)
       LD   (HORX1),A
       LD   A,(RUTNX)
       LD   (HORX2),A
;
       CALL HORLIN
;
;
       LD   A,(RUT\X)     ;Rita v{nstra vertikala linjen
       LD   (VERX),A
;
       CALL VERLIN
;
;
       RET                ;RITRUT slut
;
;
;
;*******************************************************************************
;*                                                                             *
;* PROCEDUR VERLIN                                                             *
;*                                                                             *
;* Ritar vertikal linje mellan VERX,VERY1 och VERX,VERY2                       *
;*                                                                             *
;*******************************************************************************
;
;
;
;****** VARIABLER **************************************************************
;
VERY1  DEFB  1              ;Linjens koordinater
VERY2  DEFB  2
VERX   DEFB  3
ANDORD DEFB  4              ;Ord som utv{ljer de 2 bitar som skall komplementer 
ORD    DEFB  5              ;Lagringsplats f|r ordet d} det bearbetas
VRVR[K DEFB  6              ;Varvr{knare
STAORD DEFW  7              ;F|rsta ord som skall bearbetas
;
;
;
;****** BER[KNA VARIABLERS STARTV[RDEN *****************************************
;
VERLIN LD    A,(VERX)       ;A=VERX
       AND   3              ;A=MOD(VERX/4)
       SLA   A              ;A=2*MOD(VERX/4)
       INC   A              ;A=2*MOD(VERX/4)+1
       LD    B,A            ;B=A varvr{knare
       LD    A,192          ;Ettst{ll 2 v{nstraste bitarna i ordet
;
LOOP16 DEC   B              ;Skifta de 2 bitarna }t h|ger s} att de
       JR    Z,EXIT6        ;utv{ljer de bitar som ska komplementeras
       SRL   A
       JR    LOOP16
;
EXIT6  LD    (ANDORD),A
;
       LD    HL,0           ;Nollst{ll STAORD
       LD    (STAORD),HL
;
       LD    A,(VERY1)      ;A=VERY1
       LD    (STAORD),A     ;STAORD=VERY1
       LD    IX,STAORD      ;IX pekar p} STAORD
       LD    B,6            ;B {r varvr{knare
;
LOOP17 SLA   (IX)           ;STAORD=64*VERY1
       RL    (IX+1)
       DJNZ  LOOP17
;
       LD    A,(VERX)       ;A=VERX
       SRL   A              ;A=INT(VERX/2)
       SRL   A              ;A=INT(VERX/4)
       LD    E,A            ;DE=INT(VERX/4)
       LD    D,0
;
       LD    HL,(STAORD)    ;HL=64*VERY1
       ADD   HL,DE          ;HL=64*VERY1+INT(VERX/4)
       LD    (STAORD),HL
;
;
;
;****** KOMPLEMENTERA DE AKTUELLA ORDEN ****************************************
;
       LD    A,(VERY2)      ;A=VERY2
       LD    HL,VERY1       ;HL pekar p} VERY1
       SUB   (HL)           ;A=VERY2-VERY1
       INC   A              ;A=VERY2-VERY1+1
       LD    (VRVR[K),A     ;VRVR[K=A
       LD    HL,STAORD      ;HL pekar p} STAORD
       LD    IX,ANDORD      ;IX pekar p} ANDORD
;
LOOP18 LD    HL,(STAORD)    ;HL=STAORD
       LD    DE,ORD         ;DE pekar p} ORD
       LD    BC,1           ;Bytecounter
;
       CALL  HR             ;H{mta 1 ord
;
       LD    A,(ORD)        ;A=ORD
       XOR   (IX)           ;Komplementera de 2 bitar som ANDORD utpekar
       LD    (ORD),A        ;L{gg komplementerade ordet i ORD
;
       LD    HL,ORD         ;L{gg tillbaka det komplementerade ordet i HR-minnet
       LD    DE,(STAORD)
       LD    BC,1
;
       CALL  HR
;
       LD    HL,(STAORD)    ;STAORD=STAORD+64
       LD    DE,64
       ADD   HL,DE
       LD    (STAORD),HL
;
       LD    A,(VRVR[K)     ;\ka varvr{knare
       DEC   A
       LD    (VRVR[K),A
;
       JR    NZ,LOOP18      ;Tag n{sta ord
;
       RET                  ;VERLIN slut
;
;
;
;*******************************************************************************
;*                                                                             *
;*  PROCEDUR HORLIN                                                            *
;*                                                                             *
;* Ritar horisontell linje mellan HORX1,HORY och HORX2,HORY                    *
;*                                                                             *
;*******************************************************************************
;
;
;
;****** VARIABLER **************************************************************
;
HORY   DEFB 1            ;Y-koordinat
HORX1  DEFB 2            ;1:a x-koordinat
HORX2  DEFB 3            ;2:a x-koordinat
STAXOR DEFB 4            ;Utv{ljer de bitar i startordet som ska komplementeras 
STOXOR DEFB 5            ;Utv{ljer de bitar i stoppordet som ska komplementeras 
ORDR[K DEFB 6            ;Antal hela ord som ska komplementeras
LINADR DEFW 7            ;Adress i bildminnet till aktuell linje
STOORD DEFW 8            ;Linjens sista ord   (STAORD och ORD finns i VERLIN)
LINJE  DEFS 64           ;Databuffert f|r linjen medan den bearbetas
;
;
;
;****** BER[KNA VARIABLERS STARTV[RDEN *****************************************
;
HORLIN LD   HL,0         ;Nollst{ll STAORD, STOORD OCH LINADR
       LD   (STAORD),HL
       LD   (STOORD),HL
       LD   (LINADR),HL
;
       LD   A,(HORX1)    ;Linjen m}ste kortas f|r att inte krocka med den
       INC  A            ;vertikala
       LD   (HORX1),A
;
       LD   A,(HORY)     ;A=HORY                         ***LINADR
       LD   (LINADR),A   ;LINADR=HORY
       LD   IX,LINADR    ;IX pekar p} LINADR
       LD   B,6          ;R{knare f|r multiplikation
;
LOOP1  SLA  (IX)         ;Linadr=HORY*64
       RL   (IX+1)
       DJNZ LOOP1
;
       LD   A,(HORX1)    ;A=HORX1                        ***STAORD
       SRL  A            ;A=INT(HORX1/2)
       SRL  A            ;A=INT(HORX1/4)
       LD   HL,(LINADR)  ;HL=LINADR
       LD   E,A          ;DE=INT(HORX1/4)
       LD   D,0
       ADD  HL,DE        ;HL=HORY*64+INT(HORX1/4)
       LD   (STAORD),HL  ;STAORD=HL
;
       LD   A,(HORX2)    ;Ber{kna p} samma s{tt STOORD   ***STOORD
       SRL  A
       SRL  A
       LD   HL,(LINADR)
       LD   E,A
       LD   D,0
       ADD  HL,DE
       LD   (STOORD),HL  ;STOORD=64*HORY+INT(HORX2/4)
;
       LD   A,(HORX1)    ;A=HORX1                        ***STAXOR
       AND  3            ;A=MOD(HORX1/4)
       SLA  A            ;A=2*MOD(HORX1/4)
       INC  A            ;A=A+1
       LD   B,A          ;B=A
       LD   A,255        ;Alla bitar i A ettst{lls
;
LOOP2  DEC  B            ;Skifta in nollor fr}n v{nster
       JR   Z,EXIT7
       SRL  A
       JR   LOOP2
;
EXIT7  LD   (STAXOR),A
;
       LD   A,(HORX2)    ;Ber{kna STOXOR             ***STOXOR
       AND  3
       SLA  A            ;A=2*MOD(HORX2/4)
       INC  A
       LD   B,A
       LD   A,0
;
LOOP3  DEC  B            ;Skifta in ettor fr}n v{nster
       JR   Z,EXIT8
       SCF               ;Ettst{ll carry-flagga
       RR   A            ;Skifta in en etta
       JR   LOOP3
;
EXIT8  LD   (STOXOR),A
;
;
;
;****** BEARBETA F\RSTA ORDET **************************************************
;
       LD   HL,(STAORD)  ;H{mta f|rsta ordet i HR-minnet p} adress STAORD
       LD   DE,ORD       ;L{gg det i ORD
       LD   BC,1         ;Bytecounter
;
       CALL HR
;
       LD   A,(ORD)      ;A=ORD
       LD   HL,STAXOR    ;HL pekar p} STAXOR
       XOR  (HL)         ;A=ORD XOR STAXOR
       LD   (ORD),A      ;ORD=A
;
       LD   HL,ORD       ;]terl{mna ordet till HR-minnet
       LD   DE,(STAORD)
       LD   BC,1
;
       CALL HR
;
       LD   HL,(STOORD)  ;HL=STOORD
       LD   DE,(STAORD)  ;DE=STAORD
       SBC  HL,DE        ;HL=STOORD-STAORD
       LD   (ORDR[K),HL  ;ORDR[K=STOORD-STAORD
;
       RET  Z            ;Avsluta HORLIN om endast ett ord ingick i linjen
;
;
;
;****** BER[KNA SISTA ORDET I LINJEN *******************************************
;
       LD    HL,(STOORD)  ;H{mta sista ordet i HR-minnet
       LD    DE,ORD       ;L{gg det i ORD
       LD    BC,1         ;Bytecounter
;
       CALL  HR
;
       LD    A,(ORD)      ;A=ORD
       LD    HL,STOXOR    ;HL pekar p} STOXOR
       XOR   (HL)         ;A=ORD XOR STOXOR
       LD    (ORD),A      ;A=ORD
;
       LD    HL,ORD       ;]terl{mna bearbetade ordet till HR-minnet
       LD    DE,(STOORD)
       LD    BC,1
;
       CALL  HR
;
       LD    HL,(ORDR[K)  ;Minska ordr{k med 1 (det sista ordet) 
       LD    DE,1
       SBC   HL,DE
       LD    (ORDR[K),HL
;
       RET   Z            ;Avsluta HORLIN om endast f|rsta och sista ordet
                          ;ingick i linjen
;
;
;
;****** KOMPLEMENTERA ALLA HELA ORD MELLAN F\RSTA OCH SISTA ********************
;
       LD    HL,(STAORD)  ;H{mta orden i linjen. B|rja p} ordet efter STAORD
       INC   HL
       LD    DE,LINJE     ;L{gg orden i databuffert LINJE
       LD    BC,(ORDR[K)  ;ORDR[K stycken ord skall h{mtas
;
       CALL  HR
;
       LD    HL,LINJE     ;HL pekar p} ord 1 i databufferten LINJE
       LD    A,(ORDR[K)   ;A=ORDR[K
       LD    B,A          ;B=ORDR[K
;
LOOP6  LD    A,(HL)       ;L{gg aktuellt ord i A
       CPL                ;Komplementera A
       LD    (HL),A       ;L{gg A i aktuellt ord
       INC   HL           ;Tag n{sta ord
       DJNZ  LOOP6
;
       LD    DE,(STAORD)  ;L{mna tillbaka de komplementerade orden
       INC   DE
       LD    HL,LINJE
       LD    BC,(ORDR[K)
;
       CALL  HR
;
       RET                ;HORLIN slut
;
       END                ;TILLF[LLIG F\R TEST

















































