1 REM Ins{nd av Lars Davidsson <7020>    1986-09-28 18.57.43 (SEND)
          TITLE 'Multiuser till ABC800-serien'
;
;----------------------------------------------------------------------
;
;     Program MULTUSER.ASM version 1.0 1986-08-24
;
;     Konstrukt|rer  : Lars Davidsson och Tomas Enblom
;     P}b|rjat       : 1986-08-24
;     Senste {ndring : 1986-09-13
;
;     Programmet initierar datorn f|r tv} stycken anv{ndare
;     d{r den andra anv{ndaren anv{nder datorn i remote.
;
;     OBS !! version f|r Luxor's 128 kbytes ramkort.
;
;----------------------------------------------------------------------
;
COPY_SYS  EQU   0
CONREAD   EQU   5
BEG_LOC   EQU   32768
CON_MAP   EQU   65356
DEVTBA    EQU   65403
CTRLCPTR  EQU   65413
HRCLR1    EQU   65421
CONSI     EQU   65424
DARTVEK   EQU   65456
SIOVEK    EQU   65472
CTCVEK    EQU   65488
TABPTR    EQU   65504
KEYFLG    EQU   65506
KEYCHR    EQU   65507
SPT_TIC   EQU   65525
DARBDA    EQU   34
SIOADA    EQU   64
SIOACO    EQU   65
SIOBDA    EQU   66
SIOBCO    EQU   67
DATA_OUT  EQU   0
CARD_SEL  EQU   1
CARD_NMB  EQU   52
CTC0      EQU   96
CTC1      EQU   97
CTC3      EQU   99
CON_ROM   EQU   399
READ_CH   EQU   832
ETX       EQU   3
BEL       EQU   7
BS        EQU   8
HT        EQU   9
LF        EQU   10
FF        EQU   12
CR        EQU   13
XON       EQU   17
XOFF      EQU   19
CAN       EQU   24
ESC       EQU   27
SPACE     EQU   32
PRINT     EQU   4
PUT       EQU   6
;
;----------------------------------------------------------------------
;     Initierings rutiner.
;----------------------------------------------------------------------
;
          ORG   63232
;
;     / SYS_INI /
;
;     Initierar arbetsminnena.
;
SYS_INI   DI
          PUSH  AF
          PUSH  BC
          PUSH  DE
          LD    (COM_DAT),DE
          PUSH  HL
          PUSH  IX
          PUSH  IY
          EX    AF,AF'
          PUSH  AF
          EXX
          PUSH  BC
          PUSH  DE
          PUSH  HL

          LD    (SP_SAVE),SP

          LD    HL,CHANGE
          LD    (CTCVEK+6),HL

          LD    HL,TBE_INT
          LD    (SIOVEK+8),HL
          LD    HL,EXT_INT
          LD    (SIOVEK+10),HL
          LD    HL,RKEY_INT
          LD    (SIOVEK+12),HL
          LD    HL,SPC_INT
          LD    (SIOVEK+14),HL

          LD    A,CARD_NMB
          OUT   (CARD_SEL),A

          LD    A,00000001B
          OUT   (DATA_OUT),A
          LD    HL,COPY_PRG
          LD    DE,COPY_SYS
          LD    BC,COPY_LEN
          LDIR
          CALL  COPY_SYS

          LD    A,11110000B
          OUT   (DATA_OUT),A
          CALL  REM_INI
          XOR   A
          OUT   (DATA_OUT),A

          LD    A,11111000B
          LD    (MEM_MASK),A

          POP   HL
          POP   DE
          POP   BC
          EXX
          POP   AF
          EX    AF,AF'
          POP   IY
          POP   IX
          POP   HL
          POP   DE
          POP   BC
          POP   AF
          EI
          RET
;
;     / COPY_SYS /
;
;     Kopierar BASIC-arbetsminnet till ram-kortet.
;
COPY_PRG  LD    BC,40960
          LD    HL,24576
          LD    IX,24576

LP321     LD    A,B
          OR    C
          RET   Z

          LD    E,(HL)

          LD    A,11111001B
          OUT   (DATA_OUT),A

          LD    (IX+0),E

          LD    A,00000001B
          OUT   (DATA_OUT),A

          INC   HL
          INC   IX
          DEC   BC

          JR    LP321

COPY_LEN  EQU   $-COPY_PRG
;
;     / REM_INI /
;
;     Initierar remote-programmet.
;
REM_INI   LD    HL,RETURN
          LD    (HRCLR1+1),HL

          LD    HL,(CONSI+1)
          LD    (HL_SAVE),HL
          LD    HL,GET_ADR
          LD    (CONSI+1),HL
          LD    IX,65356
          LD    HL,SLASK
          LD    BC,1
          CALL  CONREAD
          LD    HL,(HL_SAVE)
          LD    (CONSI+1),HL

          LD    IX,(CON_MAP+4)
          LD    L,(IX+0)
          LD    H,(IX+1)
          LD    (TO_ROM+1),HL
          LD    HL,CON_UNIT+5
          LD    (CON_MAP+4),HL

          LD    HL,(CONSI+1)
          LD    (WRT_CH+1),HL
          LD    HL,WRT_CH
          LD    (CONSI+1),HL

          LD    HL,(DEVTBA)
          LD    (CON_UNIT),HL
          LD    HL,V24_UNIT
          LD    (DEVTBA),HL

          LD    HL,RCA_INT
          LD    (SIOVEK+12),HL
          LD    HL,CKEY_INT
          LD    (DARTVEK+4),HL

          LD    HL,(COM_DAT)
COM_INI   LD    C,(HL)
          INC   HL
          XOR   A
          OR    C
          RET   Z
          OUTI
          JR    COM_INI

GET_ADR   EX    (SP),HL
          LD    (RET_ADR+1),HL
          EX    (SP),HL
          LD    A,CR
          RET

COM_DAT   DEFW  0
HL_SAVE   DEFW  0
SLASK     EQU   $
;
;----------------------------------------------------------------------
;     Multiuser rutiner.
;----------------------------------------------------------------------
;
          ORG   BEG_LOC

MEM_MASK  DEFB  0

          JP    PUT_CH
          JP    PUT_SEQ
          JP    BIN_V24
CLS       JP    U_CLS
CUR       JP    U_CUR
;
;     / CHANGE /
;
;     Byter arbetsminne vid interrupt.
;
CHANGE    DI
          EX    (SP),HL
          LD    (PC_SAVE),HL
          EX    (SP),HL
          PUSH  AF
          PUSH  BC
          PUSH  DE
          PUSH  HL
          PUSH  IX
          PUSH  IY
          EX    AF,AF'
          PUSH  AF
          EXX
          PUSH  BC
          PUSH  DE
          PUSH  HL

          CALL  CLOCK

          LD    A,(PC_SAVE+1)
          AND   240
          CP    96
          JR    Z,NO_CHANGE

          LD    (SP_SAVE),SP
          LD    A,CARD_NMB
          OUT   (CARD_SEL),A
          LD    A,(MEM_MASK)
          OUT   (DATA_OUT),A
          LD    SP,(SP_SAVE)

NO_CHANGE POP   HL
          POP   DE
          POP   BC
          EXX
          POP   AF
          EX    AF,AF'
          POP   IY
          POP   IX
          POP   HL
          POP   DE
          POP   BC
          POP   AF
          EI
          RETI

CLOCK     LD    HL,SPT_TIC

          INC   (HL)
          LD    A,(HL)
          CP    100
          RET   C
          LD    (HL),0
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    60
          RET   C
          LD    (HL),0
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    60
          RET   C
          LD    (HL),0
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    24
          RET   C
          LD    (HL),0
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    31
          RET   C
          LD    (HL),1
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    13
          RET   C
          LD    (HL),1
          DEC   HL

          INC   (HL)
          LD    A,(HL)
          CP    100
          RET   C
          LD    (HL),0

          RET

SP_SAVE   DEFW  0
PC_SAVE   DEFW  0
;
;     Remote programmet.
;
;     Nya remote enheter.
;
V24_UNIT  DEFW  PR_UNIT
          DEFM  'V24'
          DEFW  NOT_VALID

PR_UNIT   DEFW  CON_UNIT
          DEFM  'PR '
          DEFW  NOT_VALID

CON_UNIT  DEFW  0
          DEFM  'CON'
          DEFW  BETWEEN

NOT_VALID SCF
          LD    A,51
          RET
;
;     G|r samma sak p} terminalen som p} CON:.
;
BETWEEN   PUSH  AF
          PUSH  HL
          PUSH  BC
          CALL  IF_DISP
          POP   BC
          POP   HL
          POP   AF
TO_ROM    JP    CON_ROM

IF_DISP   CP    PRINT
          JP    Z,WRT_SEQ
          CP    PUT
          JP    Z,WRT_SEQ
          RET
;
;     Tar hand om tecken fr}n CONSI.
;
WRT_CH    CALL  READ_CH
          EX    (SP),HL
          LD    (RET_VAL),HL
          EX    (SP),HL
          PUSH  AF
          PUSH  HL
          PUSH  DE
          PUSH  BC
          CALL  HAND_CH
          POP   BC
          POP   DE
          POP   HL
          POP   AF
          RET

HAND_CH   LD    HL,(RET_VAL)
RET_ADR   LD    DE,0
          AND   A
          SBC   HL,DE
          RET   NZ
          CP    BS
          JR    Z,RUB_CH
          CP    HT
          JR    Z,TAB_CH
          CP    FF
          JP    Z,CLS
          CP    CAN
          JR    Z,RUB_LINE

          DEC   B
          RET   Z

IF_GCH    CP    SPACE
          RET   C
          CP    128
          RET   NC
;
;     / PUT_CH /
;
;     S{nder ett tecken till terminalen.
;
;     In :
;     A skall inneh}lla tecknet.
;
PUT_CH    PUSH  AF
LP5       LD    A,(X_FLOW)
          CP    XON
          JR    NZ,LP5
LP2       IN    A,(SIOACO)
          AND   00000100B
          JR    Z,LP2
          POP   AF
          OUT   (SIOADA),A
          RET
;
;     / PUT_SEQ /
;
;     S{nder en sekvens med tecken till terminalen.
;
;     In :
;     HL pekar p} tecken sekvensen.
;     BC inneh}ller antal tecken.
;
PUT_SEQ   LD    A,B
          OR    C
          RET   Z
          LD    A,(HL)
          INC   HL
          DEC   BC
          CALL  PUT_CH
          JR    PUT_SEQ
;
;     Tar hand om HT i en INPUT-sats.
;
TAB_CH    LD    HL,(TABPTR)
          LD    A,(HL)
          JR    IF_GCH
;
;     Tar hand om BS i en INPUT-sats.
;
RUB_CH    LD    A,C
          CP    B
          RET   Z
          LD    A,BS
          CALL  PUT_CH
          LD    A,SPACE
          CALL  PUT_CH
          LD    A,BS
          CALL  PUT_CH
          RET
;
;     Tar hand om CAN i en INPUT-sats.
;
RUB_LINE  CALL  RUB_CH
          RET   Z
          INC   B
          JR    RUB_LINE
;
;     / WRT_SEQ /
;
;     Rutin som utf|r instruktionerna PRINT,PUT p} terminalen.
;
;     In :
;     HL pekar p} texten.
;     BC inneh}ller l{ngden.
;
WRT_SEQ   LD    A,B
          OR    C
          RET   Z
          LD    A,(HL)
          INC   HL
          DEC   BC
          CALL  SHOW_CH
          JR    WRT_SEQ

SHOW_CH   CP    BEL
          JR    Z,PUT_CH
          CP    BS
          JR    Z,PUT_CH
          CP    LF
          JR    Z,PUT_CH
          CP    FF
          JR    Z,FF_C
          CP    CR
          JR    Z,PUT_CH
          CP    ESC
          JR    Z,ESC_C

          AND   127
          CP    SPACE
          RET   C
          JP    PUT_CH

FF_C      PUSH  HL
          PUSH  BC
          CALL  CLS
          POP   BC
          POP   HL
          RET

ESC_C     LD    A,(HL)
          CP    '='
          RET   NZ
          EX    DE,HL
          LD    HL,65533
          ADD   HL,BC
          EX    DE,HL
          RET   NC
          INC   HL
          DEC   BC
          LD    A,(HL)
          SUB   SPACE
          CP    24
          RET   NC
          INC   A
          LD    D,A
          INC   HL
          DEC   BC
          LD    A,(HL)
          SUB   SPACE
          CP    80
          RET   NC
          INC   A
          LD    E,A
          INC   HL
          DEC   BC
          PUSH  HL
          PUSH  BC
          CALL  CUR
          POP   BC
          POP   HL
          RET
;
;     / BIN_V24 /
;
;     Konverterar bin{rt till ascii-tecken,som skickas direkt till
;     terminalen.
;
;     In :
;     A inneh}ller talet.
;
BIN_V24   PUSH  BC
          LD    B,255
          LD    C,100
          CALL  CNV_DIG
          LD    C,10
          CALL  CNV_DIG
          OR    48
          CALL  PUT_CH
          POP   BC
          RET

CNV_DIG   INC   B
          SUB   C
          JR    NC,CNV_DIG
          ADD   A,C
          DEC   B
          RET   M

          PUSH  AF
          INC   B
          LD    A,B
          OR    48
          CALL  PUT_CH
          LD    B,47
          POP   AF
          RET

RET_VAL   DEFW  0
X_FLOW    DEFB  XON
;
;     Interrupt rutiner.
;
;     / CKEY_INT /
;
;     Tar hand om tangentnedtryckning i fel arbetsminne.
;
CKEY_INT  DI
          EX    (SP),HL
          LD    (PC_SAVE),HL
          EX    (SP),HL
          PUSH  AF
          PUSH  BC

          IN    A,(DARBDA)
          LD    C,A

          LD    A,(PC_SAVE+1)
          AND   240
          CP    96
          JR    Z,QUIT_KH

          LD    (SP_SAVE),SP
          LD    A,CARD_NMB
          OUT   (CARD_SEL),A
          LD    A,(MEM_MASK)
          OUT   (DATA_OUT),A
          LD    SP,(SP_SAVE)

          LD    A,C
          CALL  CKEY_HANT

          LD    A,(MEM_MASK)
          OUT   (DATA_OUT),A
          LD    SP,(SP_SAVE)

          POP   BC
          POP   AF
          EI
          RETI

CKEY_HANT LD    (KEYCHR),A
          CP    ETX
          CALL  Z,SET_CF
          LD    A,128
          LD    (KEYFLG),A
          RET
;
;     / RKEY_INT /
;
;     Tar hand om tangentnedtryckning i fel arbetsminne.
;
RKEY_INT  DI
          EX    (SP),HL
          LD    (PC_SAVE),HL
          EX    (SP),HL
          PUSH  AF
          PUSH  BC

          IN    A,(SIOADA)
          LD    C,A

          LD    A,(PC_SAVE+1)
          AND   240
          CP    96
          JR    Z,QUIT_KH

          LD    (SP_SAVE),SP
          LD    A,CARD_NMB
          OUT   (CARD_SEL),A
          LD    A,(MEM_MASK)
          OUT   (DATA_OUT),A
          LD    SP,(SP_SAVE)

          LD    A,C
          CALL  RKEY_HANT

          LD    A,(MEM_MASK)
          OUT   (DATA_OUT),A
          LD    SP,(SP_SAVE)

QUIT_KH   POP   BC
          POP   AF
          EI
          RETI
;
;     Service-rutiner f|r SIO-A interrupt.
;
TBE_INT   RETI

EXT_INT   DI
          PUSH  AF
          LD    A,00010000B
          OUT   (SIOACO),A
          POP   AF
          EI
          RETI

RCA_INT   DI
          PUSH  AF
          IN    A,(SIOADA)
          CALL  RKEY_HANT
          POP   AF
          EI
          RETI

RKEY_HANT CP    XON
          JR    Z,LD_FCH
          CP    XOFF
          JR    Z,LD_FCH
          LD    (KEYCHR),A
          CP    ETX
          CALL  Z,SET_CF
          LD    A,128
          LD    (KEYFLG),A
          RET

LD_FCH    LD    (X_FLOW),A
          RET

SET_CF    PUSH  HL
          LD    HL,(CTRLCPTR)
          SET   0,(HL)
          POP   HL
          RET

SPC_INT   DI
          PUSH  AF
          LD    A,48
          OUT   (SIOACO),A
          POP   AF
          EI
          RETI
;
;     G|r endast return.
;
RETURN    RET
;
;     Interface rutin f|r rensning av sk{rmen och mark|rplacering f|r
;     terminalen vid uppkopplingen.
;
          ORG   BEG_LOC+896

U_CLS     LD    A,CR
          CALL  PUT_CH
          LD    B,32
LP915     LD    A,LF
          CALL  PUT_CH
          DJNZ  LP915
          RET

U_CUR     RET
;
ZLUT_ADR  EQU   $
;
          END   SYS_INI
