1 REM Ins{nd av Per Svebeck <2635>    1985-05-17 18.31.02
;*****************************************************************************
;*****************************************************************************
;**                                                                         **
;** PROCEDUR HRTILLPR VER 2.8                J. FORNAEUS     JANUARI 1983   **
;** Ins{nd till ABCKLUBBEN av P Svebeck <2635>                               *
;*****************************************************************************
;*****************************************************************************
;
;
;
;****** INITIERA PROCEDUREN **************************************************
;
        ORG   59500   ;Procedurens startadress (direktiv till assemblern)
;
;
;
;****** GLOBALA VARIABLER ****************************************************
;
XZOOM   DEFB  1    ;F|rstoring i x-led
;
YZOOM   DEFB  2    ;F|rstoring i y-led
;
FYLL    DEFB  3    ;Antal linjer som skall fyllas med blanka om raden har
;                   f{rre {n 8 linjer
;
BORT    DEFB  4    ;Antal bitar som skall skiftas bort f|rst i varje linje
;                   om startpixel inte sammanfaller med hel byte
;
LNR[K   DEFB  5    ;Antal linjer p} sk{rmen som motsvarar en rad till skrivare
;
BREDD   DEFW  6    ;Den p} sk{rmen avs|kta bildens bredd i pixels
;
;
;
;****** HUVUDPROGRAM *********************************************************
;
;*****************************************************************************
;
;
;
NYRAD   LD     (START),DE  ;Ladda startadress i HR-minne
;
        CALL   L[SIHR      ;Bearbeta raden
;
        RET                ;]terv{nd till BASIC
;
;
;
;*****************************************************************************
;*                                                                           *
;*          PROCEDUR L[SIHR                                                  *
;*                                                                           *
;* Proceduren l{ser i HR-minnet angivet antal linjer av angiven bredd och    *
;* lagrar grafikdata i en str{ng p} s}dant s{tt att den kan skickas till     *
;* skrivaren MX-82F/T och d{r skrivas ut i grafikmod.                        *
;*                                                                           *
;*****************************************************************************
;
;
;
;****** VARIABLER ************************************************************
;
XZOMR  DEFB 17      ;R{knare f|r zoomning i x-led
;
START  DEFW 17      ;Startpunkt i HR-minne=64*Startlinje+Startkolumn/4
;
BUFSIZ DEFW 17      ;Storlek p} DABUF, ber{knas nedan
;
;
;
;****** BUFFERTAR ************************************************************
;
HRBUF  DEFS 70      ;Databuffert f|r tempor{r lagring av data fr}n HR-minnet
DABUF  DEFS 1200    ;Databuffert f|r data som skall bearbetas
SKRBUF DEFS 210     ;Databuffert f|r data som {r bearbetade och skall
;                    skrivas ut
;
;
;****** KONSTANTER ***********************************************************
;
HR     EQU  7FFDH   ;Adress till subrutin som h{mtar data i HR-minnet
;
;
;
;****** BER[KNA STORLEK P] DABUF *********************************************
;
L[SIHR LD   HL,(BREDD)     ;HL=BREDD
       ADD  HL,HL          ;HL=2*BREDD
;
       LD   A,(XZOOM)      ;Ladda register f|r multiplikation
       LD   DE,0           ;DE=0
       EX   DE,HL          ;HL=0, DE=2*BREDD
;
MULT   ADD  HL,DE          ;HL=HL+BREDD*2
;
       DEC  A
       JR   NZ,MULT
;
       LD   (BUFSIZ),HL    ;BUFSIZ=2*BREDD*XZOOM
;
;
;
;****** FLYTTA DATA FR]N HRMINNE TILL HRBUF **********************************
;
NYLIN  LD   HL,(START) ;H{mtadress
       LD   BC,64      ;Antal bytes
       LD   DE,HRBUF   ;Flytta till tempor{r dataarea
;
       CALL HR         ;Verkst{ll
;
       LD   (START),HL ;Spara adressen f|r data till n{sta linje
;
;
;
;****** F\RBERED NY LINJE ****************************************************
;
       LD   A,(BORT)   ;Ladda A med antal pixels som skall skiftas bort
       LD   HL,HRBUF   ;HL pekar p} f|rsta ordet
       LD   B,4        ;Ladda pixelr{knare
       INC  A          ;Skifta bort bitar f|rst i varje linje om den inte
V[CK   DEC  A          ;b|rjar p} hel byte
       JR   Z,UTHOP
       SLA  (HL)
       SLA  (HL)
       AND  255
       DEC  B          ;Minska pixelr{knaren motsv de bitar som skiftas bort
       JR   V[CK
;
UTHOP  LD   IX,DABUF   ;]terst{ll pekaren till DABUF
;
       LD   A,(YZOOM)    ;Ladda D med YZOOM
       LD   D,A
;
       LD   A,(XZOOM)    ;Ladda xzoomr{knare
       LD   (XZOMR),A
;
       LD   A,(BREDD)   ;]terst{ll kolumnr{knare dvs C=BREDD
       LD   C,A
;
;
;
;****** BEARBETA N[STA PIXEL *************************************************
;
NYPIX  RLC  (HL)      ;Bit 1 till carryflagga
       RL   (IX)      ;Carryflaggans inneh}ll till aktuellt tecken i UTBUF
       AND  255
;
       INC  IX        ;Tag n{sta tecken i UTBUF
;
       RLC  (HL)      ;Bit 2 till carryflaggan
       RL   (IX)      ;Carryflaggans inneh}ll till aktuellt tecken i UTBUF
;
       RRC  (HL)      ;]terst{ll byten s} att den kan anv{ndas vid ev zoom
       RRC  (HL)
       AND  255
;
       DEC  IX        ;Tillbaka till det f|rsta av de 2 tecken denna pixel
                      ;skall l{ggas i
       DEC  D         ;Minska yzoomr{knare
;
       JR   NZ,NYPIX  ;Tag n{sta punkt i y-led
;
       LD   A,(YZOOM) ;]terst{ll D, dvs y-zoomr{knare
       LD   D,A
;
       INC  IX        ;\ka pekaren i DABUF dvs tag n{sta punkt i x-led
       INC  IX
;
       LD   A,(XZOMR) ;Xzoomr{knare minskas
       DEC  A
       LD   (XZOMR),A
;
       JR   NZ,NYPIX  ;Tag n{sta punkt i x-led
;
       LD   A,(XZOOM) ;]terst{ll x-zoomr{knare
       LD   (XZOMR),A
;
       DEC  C         ;Minska breddr{knaren
       JR   Z,N[LIN   ;Tag n{sta linje om denna klar
;
       SLA  (HL)      ;Databitar f|r denna pixel f|rbrukade,
       SLA  (HL)      ;stega fram i byten
       AND  255
;
       DJNZ NYPIX     ;Tag n{sta pixel om inte byten slut
;
;
;
;****** F\RBERED N[STA DATAORD ***********************************************
;
       LD   B,4      ;]terst{ll pixelr{knaren
       INC  HL       ;\ka pekaren i HRBUF dvs tag n{sta ord
;
       JR   NYPIX    ;Tag n{sta pixel
;
;
;
;****** F\RBERED N[STA LINJE *************************************************
;
N[LIN  LD   A,(LNR[K)  ;Minska linjer{knaren
       DEC  A
       LD   (LNR[K),A
;
       JP   NZ,NYLIN  ;Tag n{sta linje om inte alla radens linjer klara
;
;
;
;****** FYLL UT RADEN OM DEN EJ INNEH]LLER 8 LINJER **************************
;
       LD   A,(FYLL)   ;Ladda  fyllr{knare
;
NYLN   DEC  A
       JP   M,KLAR     ;Avsluta proceduren om alla linjer fyllda
;
       LD   HL,DABUF      ;]terst{ll pekaren till DABUF
       LD   BC,(BUFSIZ)   ;]terst{ll kolumnr{knare
;
NYKOL  SLA  (HL)       ;Skifta in en nolla i aktuellt tecken
;
       CPI             ;Tag n{sta kolumn om inte alla kolumner klara, HL=HL+1,
       JP   PE,NYKOL   ;BC=BC-1, hoppa om BC-1<>0
;
       JR   NYLN       ;Tag n{sta linje
;
;
;
;****** AVSLUTA PROCEDUREN ***************************************************
;
KLAR   CALL SKRIVUT    ;Skriv ut inneh}llet i DABUF
;
       RET             ;Return
;
;
;
;*****************************************************************************
;*                                                                           *
;*        PROCEDUR SKRIVUT                                                   *
;*                                                                           *
;* En databuffert bearbetas s} att 48 blanka grafiktecken ers{tts av 4 ASCII *
;* tecken 32 (blank) varefter dittills inkomna tecken skrivs ut som grafik   *
;* och de 4 blanka skrivs ut som ASCII-tecken. D{refter nollst{lles          *
;* utskriftsbufferten och bearbetningen forts{tter.                          *
;*                                                                           *
;*****************************************************************************
;
;
;
;****** INITIERA PEKARE, LADDA VARIABLER  ************************************
;
SKRIVUT LD   HL,DABUF    ;Pekar p} 1:a tecken i databuffert
        LD   BC,(BUFSIZ) ;R{knare f|r antal tecken som skall bearbetas
;
;
;
;****** KAPA BORT ALLA BLANKA SIST I DATABUFFERTEN ***************************
;
       ADD  HL,BC        ;L}t HL peka p} databuffertens sista tecken
       DEC  HL
       LD   A,0          ;A anv{nds f|r compare
;
KAPA   CPD               ;[r tecknet=0 ?  Dessutom DEC HL; DEC BC
       JP   PO,KAPEND    ;Om hela databufferten genomg}ngen avslutas kapningen
       JR   Z,KAPA       ;Om tecknet blankt kapas n{sta
;
KAPEND JP   Z,SLUT       ;Avsluta skrivut om bara blanka i DABUF
  rNC  BC           ;Kompensera f|r DEC BC
       LD   HL,DABUF     ;Pekaren pekar p} databuffertens 1:a tecken
       LD   (BUFSIZ),BC  ;Ladda nya buffertstorleken
;
;
;
;****** KLARG\R UTSKRIFTSBUFFERT *********************************************
;
NYBUF  LD   DE,SKRBUF    ;Pekar p} 1:a tecknet i utkriftsbuffert
       INC  DE           ;De 4 f|rsta tecknen i utskriftsbufferten {r styr-
       INC  DE           ;tecken till skrivaren och d{r skall inte de bear-
       INC  DE           ;betade tecknen fyllas p} varf|r pekaren |kas med 4
       INC  DE
;
       LD   A,0          ;Teckenr{knaren f|r utskriftsbufferten nollst{lles
       LD   (ANTAL),A
;
       LD   A,24         ;Blankr{knare=24, dvs den nollst{lles
       LD   (BLANKR),A
;
       LD   A,100        ;Maximalt antal tecken i utskriftsbuffert {r 200
       LD   (MAXTKN),A   ;Tecknen bearbetas 2 och 2 allts} 100
;
;
;
;****** BEARBETA 2 TECKEN I TAGET ********************************************
;
N[TKN  LD   A,(MAXTKN)   ;Kontrollera om utskriftsbufferten {r full
       DEC  A
       LD   (MAXTKN),A
       JR   NZ,FORTS     ;Forts{tt om utskriftsbufferten inte full
;
       LD   (HLCELL),HL  ;Spara register
       LD   (DECELL),DE
       LD   (BCCELL),BC
       CALL PRINT        ;Om utskriftsbufferten full: skriv ut den
       LD   HL,(HLCELL)  ;]terst{ll
       LD   DE,(DECELL)
       LD   BC,(BCCELL)
       JP   NYBUF        ;G|r iordning ny utskriftsbuffert och forts{tt
;                         bearbeta
FORTS  LD   A,(ANTAL)    ;\ka teckenr{knaren f|r utskriftsbufferten
       INC  A            ;2 steg eftersom tecknen bearbetas 2 och 2
       INC  A
       LD   (ANTAL),A
;
       LDI               ;Flytta tecknet fr}n databuffert till
                         ;utskriftsbuffert |ka pekaren till utskriftsbuffert,
                         ;INC HL, DEC BC
;
       JP   PO,F[RDIG    ;Om BC-1=0 {r alla tecken i databufferten bearbetade
                         ;och proceduren skall avslutas
;
       LDI               ;Upprepa detta f|r det andra tecknet
       JP   PO,F[RDIG
;
       DEC  HL           ;]terst{ll HL efter LDI
       DEC  HL
;
       LD   A,0          ;A anv{nds f|r COMPARE
;
       CPI               ;[r tecknet blankt? \ka pekare i DABUF (HL), minska
                         ;datar{knaren (BC)
;
       INC  BC           ;]terst{ll BC efter CPI
;
       INC  HL           ;\ka HL s} att detta inte missas vid ev hopp n{sta rad 
;
       JR   NZ,NOBLA     ;Om tecknet inte var blankt unders|ks inte det andra
;
;
       DEC  HL           ;[ndra tillbaka HL ty |kningen sk|ts h{r av CPI
;
       CPI               ;[r det andra tecknet blankt? INC HL, DEC BC
;
       INC  BC           ;]terst{ll BC efter CPI
;
       JR   NZ,NOBLA
;
;
       JR   BLANK        ;Eftersom b}da tecknen var blanka |kas
                         ;blankr{knaren mm
;
NOBLA  LD   A,24         ;Om n}got av tecknen var ickeblankt nollst{lles
       LD   (BLANKR),A   ;blankr{knaren dvs s{ttes till 24
;
       JR   N[TKN        ;Bearbeta n{sta tecken
;
;
;
;****** REGISTRERA EV BLANKTECKEN ********************************************
;
BLANK  LD   A,(BLANKR)   ;Minska blankr{knaren dvs registrera att ytterligare
       DEC  A            ;blanktecken inkommit
       LD   (BLANKR),A
;
       JR   NZ,N[TKN     ;Har 48 blanka i rad inkommit? Om inte bearbeta n{sta
                         ;tecken
;
;
;
;****** SKRIV UT 4 ASCII-TECKEN BLANK (32) ***********************************
;
       LD   A,(ANTAL)    ;Minska teckenr{knaren dvs tag bort 48 blanka
       SUB  48           ;grafiktecken ur utskriftsbufferten
       LD   (ANTAL),A
;
       LD   (HLCELL),HL  ;Spara register
       LD   (DECELL),DE
       LD   (BCCELL),BC
;
       CALL PRINT        ;Skriv ut det som eventuellt finns i utskrifts-
                         ;bufferten
;
       CALL SKRBL        ;Skrivrutinen anropas via l{get SKRBL som {r avsett
                         ;f|r utskrift av blanka ASCII-tecken. (PRINT skriver
                         ;normalt grafiktecken)
;
       LD   HL,(HLCELL)  ;]terst{ll
       LD   DE,(DECELL)
       LD   BC,(BCCELL)
;
       JP   NYBUF        ;Forts{tt bearbeta databufferten. Utskriftsbufferten
                         ;{r nu tom.
;
;
;
;****** AVSLUTA PROCEDUREN ***************************************************
;
F[RDIG LD   (HLCELL),HL  ;Spara register
       LD   (DECELL),DE
       LD   (BCCELL),BC
       CALL PRINT        ;Skriv ut ev kvarvarande tecken i utskriftsbufferten
       LD   HL,(HLCELL)  ;]terst{ll
       LD   DE,(DECELL)
       LD   BC,(BCCELL)
;
SLUT   RET               ;SKRIVUT slut
;
;
;
;*********** VARIABLER *******************************************************
;
BLANKR DEFB 0          ;Blankr{knare
MAXTKN DEFB 0          ;R{knare f|r max antal tecken i skrivarbuffert
HLCELL DEFW 0          ;Minnesutrymme f|r sparade register
DECELL DEFW 0
BCCELL DEFW 0
;
BLANKA DEFB 32         ;4 st ASCII-tecken 32 (blank)
       DEFB 32
       DEFB 32
       DEFB 32
;
;
;
;*****************************************************************************
;*                                                                           *
;*       PROCEDUR PRINT                                                      *
;*                                                                           *
;* Skriver de tecken som finns i utskriftsbufferten SKRBUF.                  *
;* Inhopp finns ocks} f|r utskrift av enstaka ASCII-tecken.                  *
;*                                                                           *
;*****************************************************************************
;
;
;
ANTAL  DEFB  0           ;Variabel som anger antal tecken som ska skrivas ut
PRINT  PUSH  BC          ;Spara HL & BC
       PUSH  HL
;
;
;*************** L[GG UPP UTSKRIFTSBUFFERT ***********************************
;
       LD    HL,SKRBUF   ;HL pekar p} utskriftsbuffertens 1:a byte
       LD    (HL),27     ;L{gg in 1:a styrtecknet i buffertens 1:a byte
       INC   HL          ;HL pekar p} n{sta byte i bufferten
       LD    (HL),76     ;L{gg in styrtecken 2
;
       INC   HL          ;HL pekar p} byte 3
       LD    A,(ANTAL)   ;Antal tecken som skall skrivas ut l{ggs in
       LD    (HL),A
;
       LD    A,0        ;A anv{nds f|r compare.
       CPI              ;[r ANTAL=0 ? Dessutom |kas HL och pekar d} p} byte 4
       JR    Z,SIST     ;Avsluta i s} fall rutinen direkt
;
       LD    (HL),0     ;Ladda 0 eftersom mindre {n 256 tecken ska skrivas ut
;
       LD    A,(ANTAL)  ;Antal tecken som ska skickas ber{knas (inkl kontroll)
       ADD   A,4        ;Till skrivaren skall f|rutom de tecken som skall
       LD    B,A        ;skrivas ut {ven skickas 4 styrtecken. B {r r{knare.
;
       LD    DE,3       ;Eftersom HL pekar p} de tecken som skall matas ut
       SBC   HL,DE      ;m}ste den minskas s} att HL pekar p} 1:a styrtecknet
;
       JR    UTSKR      ;Hoppa f|rbi l{get avsett f|r utskrift av blanka ASCII
;
;
;
;******** L[GE AVSETT F\R UTSKRIFT AV BLANKA ASCII ***************************
;
SKRBL  PUSH BC          ;Spara BC och HL eftersom de f|rst|rs av rutinen
       PUSH HL
;
       LD   A,4         ;F|rbered register f|r utskriftsrutinen
       LD   B,A         ;B {r teckenr{knare (4 blanka ska skrivas ut)
       LD   HL,BLANKA   ;HL pekar p} 4 st 32 (ASCII-kod f|r blank)
;
;
;
;**************** SKICKA TECKNEN I UTSKRIFTSBUFFERTEN 1 EFTER 1 **************
;
UTSKR  LD    C,32       ;C pekar p} utport nr 32
;
NYTKN  CALL  DELAY      ;Pga assemblerns snabbhet m}ste programmet v{nta 900
                        ;varv i en v{nteloop mellan varje tecken som skickas
;
       LD    A,16       ;A anv{nds f|r att st{lla in port 33
       OUT   (33),A     ;St{ll in port f|r inl{sning av status
       IN    A,(33)     ;L{s in status
       AND   32         ;Om status {r 32 s} {r skrivaren ledig
       XOR   32
       JR    NZ,NYTKN   ;V{nta om skrivaren upptagen
;
       OUTI             ;Mata ut det tecken i utskriftsbuffert som HL pekar p}
                        ;dessutom g|rs INC HL, DEC B
;
       JR    Z,SIST     ;Om B=0 {r alla tecken utskrivna och rutinen avslutas
       JR    NYTKN      ;Om inte klar: tag n{sta tecken
;
;
;
;****************** AVSLUTA PROCEDUREN ***************************************
;
SIST   LD    A,0        ;Nollst{ll antal
       LD    (ANTAL),A
       POP   HL         ;]terst{ll HL och BC
       POP   BC
;
       RET              ;Return
;
;
;
;*****************************************************************************
;*                                                                           *
;* PROCEDUR DELAY                                                            *
;*                                                                           *
;* F|rdr|jning                                                               *
;*                                                                           *
;*****************************************************************************
;
;
;
DELAY  PUSH  DE           ;Spara DE
;
       LD    D,40
;
DR\J1  LD    A,40         ;Yttre v{nteloop
DR\J2  DEC   A            ;Inre v{nteloop
       JR    NZ,DR\J2
       DEC   D
       JR    NZ,DR\J1
;
       POP   DE           ;]terst{ll DE
;
       RET                ;Return
;
;
;
       END              ;Direktiv till assemblern




















