1 REM Ins{nd av Kristoffer Eriksson SYSOP <5357>    1987-01-05 00.59.28 (DUMP)
; Fil: ENDINIT(1).ASM
; Av:  Kristoffer Eriksson, "SKE", 1986
;
;-Ver--/-Datum----/-Sign-/-Kommentar-----------------------------
; 1.00 / 86-05-24 / SKE  /
; 1.10 / 86-12-12 / SKE  / Accepterar ytterligare text efter filnamnet,
;                          Pekare i st{llet f|r kopiering av str{ngen,
;                          Ingen felindikering om namnet avslutas med blanka.
;
; Anv{nds tillsammans med ENDREL.ASM V1.6 och CLINEPAR.ASM f|r att
; administrera programl{nkning. Kontrollerar och iordningst{ller filnamn
; till avslutande CHAIN i ENDREL. Pekare till filnamnet placeras i CHAINFILE.
; Rutiner f|r att nollst{lla CHAINFILE, och f|r att st{lla den till ett
; kontrollerat filnamn h{mtat fr}n kommandoraden.
;
; CHAINFILE definieras i ENDREL, och {r adressen f|r en pekare (2 byte)
; till filnamnstr{ngen, en l{ngdangivelse (1 byte) f|r densamma, och ett
; kontrolltal (1 byte). Normalt {r CHAINFILE placerat p} n}gon fast adress,
; f|r den h{ndelse att ENDREL och ENDINIT skulle ligga i olika
; laddningsmoduler.

; CHAINFILE: DEFW Pointer to text
;            DEFB Length of text
;            DEFB Magic check-number

SOFTNOCO:   =     18               ; Feluthopp.
SKIPSP:     =     24               ; Skippa blanktecken.

            EXTERN CHAIN.CLR, CHAIN.LOAD

;*   Blankst{ll filnamnet.
;*
CHAIN.CLR:  LD    A,CHAINCHECK     ; Indikera korrekt initiering.
            LD    (CHAINFILE+3),A
            XOR   A                ; Om l{ngden {r noll, finns inget filnamn.
            LD    (CHAINFILE+2),A
            RET

;*  H{mta ev filnamn fr}n kommandoraden.
;*
;*  Adress och kontroll av kommandoraden kan f}s av CLINEPAR.ASM.
;*  De parametrar som g{ller f|r det aktuella programmet antas redan ha l{sts
;*  f|rbi, s} HL nu pekar p} slutet av raden, d{r filnamnet ev kan finnas.
;*  Filnamnet f|reg}s av ";" och ska avslutas med CR. Finns inget filnamn
;*  ska CR komma direkt. \vriga tecken ger retur med Carry, som l{mpligen
;*  f|ljs upp med ett hopp till error 221 "otill}tet tecken". Efter filnamnet
;*  p} max 16 tecken, kan ytterligare data komma, om dessa f|reg}s av ett
;*  kommatecken.
;*  Pekare och l{ngd f|r denna str{ng placeras i CHAINFILE. Str{ngen blir
;*  kvar i input-bufferten som inte f}r {ndras. Avslutande blanktecken r{knas
;*  inte in i l{ngden.
;*
;*  \kar HL, F|rst|r A, B och DE.
;*
CHAIN.LOAD: CALL  CHAIN.CLR
            DEC   HL
            RST   SKIPSP
            CP    13               ; Raden slut, inget filnamn.
            RET Z
            CP    ";"
            SCF
            RET NZ
            LD    BC,17 << 8 + 0   ; B <- 17, C <- 0
            RST   SKIPSP
            LD    (CHAINFILE),HL   ; Str{ngens startadress.
CL.LOOP:    LD    A,(HL)
            CP    13
            JR Z  CL.END
            CP    " "
            JR Z  CL.ENDS
            CP    ","
            JR Z  CL.EXTRA
            INC   C
            INC   HL
            DJNZ  CL.LOOP
            SCF                    ; F|r l}ngt namn.
            RET

CL.EXTRA:   INC   C                ; Acceptera (och r{kna) text efter komma.
            INC   HL
            LD    A,(HL)
            CP    13
            JR NZ CL.EXTRA
            JR    CL.END

CL.ENDS:    RST   SKIPSP           ; Ta bort avslutande blanka, och kolla att
            CP    13               ; raden sen {r slut.
            SCF
            RET NZ
CL.END:     LD    A,C              ; Lagra l{ngd.
            LD    (CHAINFILE+2),A
            XOR   A
            RET                    ; Korrekt retur med falsk carry.
