1 REM Ins{nd av Kristoffer Eriksson SYSOP <5357>    1987-01-05 01.01.58 (DUMP)
; Fil: DOTOPT.ASM                    F|r: ABC800-serien
; Av Kristoffer Eriksson "SKE", ABC-klubben <5357>, 1984
;
;-Ver--/-Datum----/-Sign-/-Kommentar----
; 1.00 / 84-10-16 / SKE  / Start.
; 2.00 / 86-12-16 / SKE  / Kommandoradsparametrar (modul DOTPARS),
;                          Inl{nkningen moderniserad,
;                          Rutinval mellan 802/806 g|rs direkt vid inladdning,
;                          [ndrade namn p} k{llkodsfilerna.
; 2.01 / 86-12-23 / SKE  / Fungerar }ter p} ABC802.
;
; Hade det varit m|jligt hade BASIC-koderna bytts till samma som de inbyggda,
; men ej implementerade, koderna, men tyv{rr {r dessa helt o}tkomliga (utom
; m|jligen genom att agera n{r felmeddelandetext f|r error 200 s|ks).
;
; CmplTop och NewBotm {r tv} alternativa nya Y.Botm, se DOTPARS.ASM.

            INCLUDE DOTCMPL      ; Kompilering och instruktionstabell.
CmplTop:    INCLUDE DOTEXEC      ; Exekvering SET DOT, CLR DOT, DOT
NewBotm:    INCLUDE CLINEPAR     ; Hitta kommandoraden.
            INCLUDE ENDINIT      ; Initiering av filnamn }t ENDREL.
            INCLUDE I2ASC        ; Omvandla heltal i DE till ASCII vid HL
            INCLUDE DOTPARS      ; Parameterstyrning. Ska ligga sist.
            ORG     NewBotm
            INCLUDE ENDREL       ; CHAIN
            END

;---------------------------------------------------------------------------

; Fil: DOTCMPL.ASM                   H|r till: DOTOPT.ASM
; F|r: ABC800-serien
;
;-Ver--/-Datum----/-Sign-/-Kommentar----
; 1.00 / 84-10-16 / SKE  / Start
; 2.00 / 86-12-12 / SKE  / Inl{nkningen flyttad till annan modul,
;                          Exekveringstabellerna flyttade till DOTEXEC.ASM.
;
; Kompilering och kontroll av de nya BASIC-instruktionerna. Inl{nkingen
; av instruktionslistan g|rs i DOTPARS.ASM.
;

Rst.Err:    =     16
SkipSp:     =     24
StrComp:    =     27
TypComp:    =     29
StmTbA:     =     65405
FnkTbA:     =     65407
Y.Botm:     =     65292              ; Botten av BASIC-minnet
Y.ComTop:   =     65328              ; Toppen av COMMON-variablerna

            ; Anv{nder ExecTab och FExecTab fr}n DOTEXEC.ASM.

            EXTERN L{nk.StmTab, L{nk.FnkTab, PtrSav.Bt, StmTOffs, FnkTOffs
            EXTERN TextTab, TextTab.Len, ExecPtr, FExecPtr

PtrSav.Bt:  DEFW  0                  ; H{r sparas gamla Y.Botm vid inl{nkning,
                                     ; s} den g}r att }terfinna f|r url{nkn.

L{nk.StmTab:DEFW  0                  ; Utrymme f|r gammal STMTBA
StmTOffs:   DEFB  128                ; F|rsta kod (l{gsta m|jliga vald)
            DEFB  2                  ; 2 instruktioner
ExecPtr:    DEFW  ExecTab
            DEFW  TextTab
            DEFW  CmplTab

TextTab:    DEFB  80H
            DEFM  "SET DOT"
            DEFB  81H
            DEFM  "CLR DOT"
            DEFB  0FFH
TextTab.Len:=     * - TextTab

CmplTab:    DEFW  Cmpl.DOT           ; %, %
            DEFW  Cmpl.DOT

L{nk.FnkTab:DEFW  0                  ; Utrymme f|r gammal FNKTBA.
FnkTOffs:   DEFB  160                ; Kod f|r funktionen (ocks} l{gsta m|jl).
            DEFB  1                  ; 1 funktion
FExecPtr:   DEFW  FExecTab
            DEFW  FTextTab
            DEFW  FSntxTab

FTextTab:   DEFB  80H
            DEFM  "DOT"
            DEFB  0FFH

FSntxTab:   DEFB  80H, 81H           ; DOT
            DEFB  01H, 01H, 21H      ; Resultat %, arg %, %
            DEFB  0FFH

Cmpl.I1K:   CALL  Cmpl.I1            ; "% ,"
            RET   C
Cmpl.Komma: LD    A,(HL)
            XOR   ","
            LD    A,227              ; ERROR 227 - "," saknas.
            SCF
            RET   NZ
            LDI
            DEC   HL
            RST   SkipSp
            RET

Cmpl.DOT:   CALL  Cmpl.I1K           ; %, %
            RET   C
Cmpl.I1:    LD    B,1
            JP    TypComp
;---------------------------------------------------------------------------

; Fil: DOTEXEC.ASM                   H|r till: DOTOPT.ASM.
; F|r: ABC800-serien
;
;-Ver--/-Datum----/-Sign-/-Kommentar----
; 1.00 / 84-10-16 / SKE  / Start
; 2.00 / 86-12-11 / SKE  / Val av rutiner redan vid laddningen,
;                          Exekveringstabellerna flyttade hit.
; 2.01 / 86-12-23 / SKE  / Fungerar p} ABC802 igen.
;
; Exekvering av SETDOT-instruktionerna.
;

Evalu:      =  32
MaskinTyp:  =  39
Typ.806:    =  4
SoftCont:   =  51
ConLu.Wid:  =  65364                   ; Bildsk{rmsbredd.
ConLu.Attr: =  65369                   ; Aktuell attributkod i ABC 806.
AttrPort:   =  53

            EXTERN  ExecTab, FExecTab

ExecTab:    DEFW    Exec.SETDOT
            DEFW    Exec.CLRDOT

FExecTab:   DEFW    Exec.DOT

Exec.SETDOT:CALL    EvalKoor
            CALL    Adress           ; 80 tkn/rad
            JR NC   ESD.X1
            LD      A,C              ; Gammalt v{rde
            OR      B
            LD      (HL),A
            INC     HL
            CALL    F|rBehandla
ESD.X1:     LD      A,C
            OR      B
            LD      (HL),A
            RET

Exec.CLRDOT:CALL    EvalKoor
            CALL    Adress
            JR NC   ESC.X1
            LD      A,B              ; Mask
            CPL     A
            AND     C
            LD      (HL),A
            INC     HL
            CALL    F|rBehandla
ESC.X1:     LD      A,B
            CPL     A
            AND     C
            LD      (HL),A
            RET

Exec.DOT:   POP     HL               ; Y-koordinat (Rad)
            POP     BC               ; X-koordinat (Kolumn)
            CALL    Adress
            LD      HL,0
            LD      A,C              ; Tecken
            AND     B                ; Mask
            JR Z    ED.]
            DEC     HL
ED.]:       PUSH    HL
$$Attr:     LD      A,(ConLu.Attr)   ; ]terst{ll attribute.
            OUT     (AttrPort),A
$$Ret:      RST     40

EvalKoor:   RST     Evalu            ; Y-koordinat (Rad).
            PUSH    HL
            INC     DE
            RST     Evalu            ; X-koordinat (Kolumn).
            POP     BC               ; BC = Y, HL = X.
            RET

ERR:        LD      A,176          ; ERROR 176 - Grafisk punkt utanf|r sk{rmen
            POP     HL               ; Eliminera RET-adress.
            JP      SoftCont

Adress:     LD      A,H
            OR      B
            JR NZ   ERR              ; Negativa koordinater.
            LD      A,C
            CP      3*25
            JR NC   ERR              ; Y > 24
            LD      A,L
            LD      B,1
            SRL     L                ; 0>>c, X/2
            JR NC   AD.X2
            LD      B,2              ; H|gerhalvan av tecknen.
AD.X2:      CALL    Bredd?
            LD      A,L
            JR NC   AD.X1
            ADD     A                ; 40 tkn/rad => X * 2
            LD      L,A
AD.X1:      CP      80
            JR NC   ERR              ; X  >  Radbredd * 2
            LD      A,C              ; Y
            LD      C,-1             ; C <- C / 3
AD.L1:      SUB     3
            INC     C
            JR NC   AD.L1
            ADD     3
            JR Z    AD.X3
AD.L2:      RLC     B                ; c<<, B <- r{tt bit
            RLC     B
            DEC     A
            JR NZ  AD.L2
AD.X3:      LD      A,B

            LD      B,H              ; B <- 0
            PUSH    HL
            LD      L,C              ; 1x
            ADD     HL,HL            ; 2x
            ADD     HL,HL            ; 4x
            ADD     HL,BC            ; 5x
            ADD     HL,HL            ; 10x
            ADD     HL,HL            ; 20x
            ADD     HL,HL            ; 40x
            ADD     HL,HL            ; 80x, Radens startadress.
            POP     BC               ; Kolumn.
            ADD     HL,BC
            LD      BC,30720         ; Bildsk{rmens startadress.
            ADD     HL,BC

            CP      00100000I
            JR NZ   AD.X4
$$H|gBit:   LD      A,01000000I      ; ABC 802-varianten visas.
AD.X4:      LD      B,A

F|rBehandla:
            LD      A,(HL)
$$Rutinval: JR      AD.X5            ; Hopp till 802-rutin, som tas bort om
            AND     255-32-64        ;  detta {r en 806:a.
            LD      C,A              ; F|r ABC 806.
            CALL    Bredd?
            LD      A,(ConLu.Attr)
            JR NC   AD.X6            ; 80 tkn/rad.
            BIT     0,L
            JR NZ   AD.X6            ; H|gerhalvan av EL.
            LD      A,255            ; EL Elongated.
AD.X6:      OUT     (AttrPort),A
            RET                      ; True Carry.

AD.X5:      OR      32               ; F|r ABC 802.
            LD      C,A              ; HL = Adress, B = Mask, C = Nu-v{rde.
Bredd?:     LD      A,(ConLu.Wid)
            CP      41
            RET                      ; cflg sann om <= 40 tkn/rad.

;_ Initiering             _
; V{lj bitkod f|r "h|gsta" dotten i blockgrafiktecken.
Init:       LD      A,(MaskinTyp)
            CP      Typ.806
            LD      A,01000000I      ; F|r ABC 802.
            JR NZ   Init.X1
            LD      A,10000000I      ; F|r ABC 806.
Init.X1:    LD      ($$H|gBit+1),A
            LD      A,(MaskinTyp)
            CP      Typ.806
            JR Z    Init.806
            LD      A,($$Ret)        ; Skippa en }terst{llning av attribut
            LD      ($$Attr),A       ;  n{r det bara {r en 802.
            RET
Init.806:   LD      HL,0
            LD      ($$Rutinval),HL  ; Ta bort JR, s} 806:ans rutin anv{nds.
            RET

            REL PUSH Init
            REL CALL
            ORG Init
;---------------------------------------------------------------------------

; Fil: DOTPARS.ASM                    H|r till: DOTOPT.ASM
; F|r: ABC800-serien
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------
; 2.00 / 86-12-16 / SKE  / Denna modul tillkom f|rst i ver 2.
; 2.01 / 86-12-23 / SKE  / Versionsnr "2.01".
;
; Behandlar parametrar fr}n kommandoraden, patchade parametrar,
; kontroll av dubbelladdning, inladdningsmeddelande, och sj{lva inl{nkningen.
;
; Modulen utnyttjar CLINEPAR.ASM, ENDINIT.ASM, I2ASC.ASM, och
; indirekt FINDDEV.ASM vilka inneh}ller de externa rutinerna
; Clinepar, Chain.Clr, Chain.Load, I2ASC samt FindDev.
;
; Fr}n DOTEXEC.ASM anv{nds L{nk.StmTab, L{nk.FnkTab och PtrSav.Bt, StmTOffs
; och FnkTOffs. Fr}n DOPTCMPL.ASM anv{nds ExecPtr och FExecPtr. Fr}n
; huvudmodulen anv{nds NewBotm och CmplTop.
;
; Att byta till de normala BASIC-koderna f|r SET/CLR-DOT g}r inte, eftersom
; dessa enbart s|ks i den prommade tabellen.

Rst.Err:    =     16
SkipSp:     =     24
Evalu:      =     32
MaskinTyp:  =     39
ChkLU:      =     43
IO:         =     90
IO.Print:   =     4
Y.Botm:     =     65292               ; Botten av BASIC-minnet
Y.Top:      =     65294               ; Minnestak.
Y.Comtop:   =     65328               ; Toppen av COMMON-variablerna
ConLu.Wid:  =     65364
StmTba:     =     65405
FnkTba:     =     65407

Opt.Old:    =     1                   ; Gamla BASIC-koder,
;Opt.New:   =     2                   ; ej f|reg}ende,
Opt.DWid:   =     4                   ; v{xla till dubbel teckenbredd,
Opt.EWid:   =     8                   ; ej f|reg}ende,
Opt.Nopr:   =     16                  ; ingen utskrift av startmeddelande,
Opt.Err:    =     32                  ; syntaxfel i kommandorad,
OptBit.Err: =     5
Opt.Help:   =     64                  ; hj{lptext |nksas,
Opt.Nch:    =     128                 ; kontrollera ej dubbelladdning.

;_ Initiering                             _
Init:       CALL   Chain.Clr
            CALL   HardPar
            CALL   Clinepar           ; C = L{ngd, A = F|rsta tecken, Carry
            JR     C,ActOnPars
            CALL   ParDelim           ; Om optionsstr{ngen {r tom, kommer
            JR     Z,Par.Chain        ;   patch-parametrarna att g{lla.

            ; Loop f|r att unders|ka optioner angivna p} kommandoraden.
            LD     D,0                ; D f}r ackumulera optionsbittarna.
ParLoop:    LD     E,Opt.Nch
            CP     '!'                ; ! - F|rhindra inte dubbelladdning.
            JR     Z,Par.OR
            LD     E,0
            CP     '-'                ; - - Dummy.
            JR     Z,Par.OR
            LD     E,Opt.Help
            CP     '?'                ; ? - Hj{lp.
            JR     Z,Par.Or
            CP     'A'                ; F|rkasta nu andra tecken {n bokst{ver.
            JR     C,Par.Err
            CP     '`'
            JR     C,Par.X1
            SUB    'a'-'A'            ; Konvertera gemener till versaler.
Par.X1:     LD     E,Opt.Help
            CP     'H'                ; H - Hj{lp (enbart hj{lp om inga andra
            JR     Z,Par.OR           ;            optioner anges).
            LD     E,Opt.DWid
            CP     'D'                ; D - Dubbel bredd.
            JR     Z,Par.OR
            LD     E,Opt.EWid
            CP     'E'                ; E - Ej dubbel bredd.
            JR     Z,Par.OR
;           LD     E,Opt.Old
;           CP     'G'                ; G - Gamla koder.
;           JR     Z,Par.OR
;           LD     E,Opt.New
;           CP     'N'                ; N - Nya koder.
;           JR     Z,Par.OR
            LD     E,Opt.Nopr
            CP     'T'                ; T - Tyst inladdning, ingen utskrift.
            JR     Z,Par.OR
Par.Err:    LD     A,Opt.Err + Opt.Help
            JR     Par.Next

Par.OR:     LD     A,E
            OR     D
Par.Next:   LD     D,A
            RST    SkipSp             ; L{s n{sta oblanka tecken p} raden.
            CALL   ParDelim
            JR     NZ,ParLoop
Par.Finish: LD     A,D
            LD     (Option),A
Par.Chain:  CALL   Chain.Load         ; Ta hand om chain-fil sist p} raden.
            JR NC  ActOnPars
            LD     HL,Option
            SET    OptBit.Err,(HL)
            AND    A                  ; No carry.
            JP     Meddelande

            ; Ska n}gon inl{nkning alls g|ras den h{r g}ngen?
ActOnPars:  LD     A,(Option)
            LD     C,A
            CP     Opt.Help
            JP     Z,Meddelande       ; Hj{lp som enda angivna option.
            AND    Opt.Err
            JP     NZ,Meddelande      ; N}got fel - ingen inladdning. (NC)

            ;*  V{xla till 40-teckensbild om s} |nskas.
Bredd:      LD     A,C
            AND    Opt.DWid
            JR     Z,J{mfE
            LD     A,(MaskinTyp)      ; Mixtra inte med radl{ngden p} ABC800,
            CP     10                 ;  }tminstone vissa ABC800M t}l det inte
            JR     Z,J{mfE            ;  och p} ABC800C {r beh|vs det ju inte.
            LD     A,40
            LD     (ConLu.Wid),A
;           LD     A,1+128            ; Bredd p} radstart i 806, men
;           OUT    (54),A             ; }terst{lls inte av WIDTH 80.

J{mfE:      LD     A,C
            AND    Opt.Nch            ; Option f|r att slippa f|ljande kollar.
            JR     NZ,L{nkain

            ; Kontrollera att det inte redan finns laddat en instruktions-
            ; tabell med exakt samma instruktioner.
J{mf:       LD     IX,Stmtba
J{mf.L1:    LD     L,(IX+0)
            LD     H,(IX+1)
            LD     A,H
            OR     L                 ; (Carry <- 0)
            JR Z   L{nkain           ; Inga fler l{nkar, och ingen lik v}ran.
            PUSH   HL
            POP    IX
            LD     L,(IX+6)          ; TextTab
            LD     H,(IX+7)
            LD     DE,TextTab
            LD     BC,TextTab.Len
J{mf.L2:    LD     A,(DE)
            INC    DE
            CPI
            SCF
            JP PO  Meddelande        ; Hela text-tabellen finns redan.
            JR Z   J{mf.L2           ; Ett tecken lika, j{mf|r n{sta.
            JR     J{mf.L1           ; Texten i l{nken ej lik. J{mf|r n{sta.

            ; Nu kan vi tryggt {ndra systempekare och l{nka in listan.
L{nkaIn:    LD     HL,(StmTbA)
            LD     (L{nk.StmTab),HL
            LD     HL,L{nk.StmTab
            LD     (StmTbA),HL

            LD     HL,(FnkTbA)
            LD     (L{nk.FnkTab),HL
            LD     HL,L{nk.FnkTab
            LD     (FnkTbA),HL

            LD     HL,(Y.Botm)
            LD     (PtrSav.Bt),HL
            LD     HL,NewBotm         ; Skydda det minne programmet tar upp.
            LD     (Y.Botm),HL
            LD     (Y.Comtop),HL

            ;*  [ndra instruktionskoderna till de normala inbygda.
;           LD     A,(Option)
;           AND    Opt.New
;           JR     Z,L{nka800C
;           LD     A,22               ; Instruktionskod 22 o 23 enligt stndrd.
;           LD     (StmTOffs),A
;           LD     A,53               ; Funktionskod 53. (Riktigt on|digt,
;           LD     (FnkTOffs),A       ; eftersom den inte ing}r i XFN-listan)

            ;* Specialhantering av ABC800C. Byt ut exekveringsrutinerna mot de
            ;* vanliga prommade, eftersom v}ra inte klarar av bildsk{rmsadres-
            ;* seringen, och rutinerna {nd} alltid finns klara i ABC800C. Bara
            ;* instruktionstabellerna med de nya BASIC-koderna blir kvar.
L{nka800C:  LD     A,(MaskinTyp)
            CP     10
            JR     NZ,MedOK           ; N}got annat {n ABC800.
            LD     A,(ConLu.Wid)
            CP     41                 ; ABC800C k{nns igen p} 40-teckensrader.
            JR     NC,MedOK
            CALL   BuiltInI           ; Instruktionerna SET/CLR DOT
            JR     C,MedOK
            PUSH   HL
            CALL   BuiltInF           ; Funktionen DOT
            POP    DE
            JR     C,MedOK
            LD     (ExecPtr),DE
            LD     (FExecPtr),HL
            LD     HL,CmplTop         ; Skydda enbart kompileringen, inte
            LD     (Y.Botm),HL        ; exekveringen.
            LD     (Y.Comtop),HL
MedOK:      AND    A                  ; Ingen carry, lyckad laddning.

            ;*  Meddela hur inladdningen gick (eller snarare g}r).
            ;*  Om options-byten anger fel, g}r rutinen direkt till
            ;*  utskriften av hj{lptexten.
            ;*  Annars, om Carry-flaggan {r sann skrivs "Finns redan" ut,
            ;*  annars blir det ett positivt meddelande.
Meddelande: EXX
            PUSH   HL                 ; Skydda relokeringsv{rdena.
            PUSH   DE
            PUSH   BC
            EX     AF,AF'          ;--,
            XOR    A               ;  ! Hitta LU-blocket f|r fil nr 0. Det {r
            CALL   ChkLU           ;  !   d{r utskrifterna ska g|ras.
            JP     C,Pr.Ret        ;  !
            LD     A,(Option)      ;  !
            AND    Opt.Nopr+Opt.Help+Opt.Err
            CP     Opt.Nopr        ;  !   Opt.Nopr => Ingen utskrift av
            JR     Z,Pr.Ret        ;  !     enbart inladdningsresultat.
            EX     AF,AF'          ;--'
            JR     NC,Pr.X1

Pr.Redan:   LD     HL,Itext1
            LD     BC,Itext2 - Itext1
            CALL   Write              ; "DOTOPT finns redan." (Sann Carry)
            JR     Pr.Help?

Pr.X1:      LD     HL,Itext2
            LD     BC,Itext3 - Itext2
            CALL   Write              ; "DOTOPT Ver ..., av ..."
            LD     A,(Option)
            CP     Opt.Help
            JR     Z,Pr.Help          ; Enbart hj{lp, inget inladdat.
            AND    Opt.Err
            JR     NZ,Pr.Help         ; Fel - hj{lp.

Pr.Mem:     LD     DE,(PtrSav.Bt)
            LD     HL,(Y.Botm)
            XOR    A                  ; Nolla carry, och signalera undertryck-
            SBC    HL,DE              ;   ning av inledande nollor i I2ASC.
            EX     DE,HL
            LD     HL,Itext4n
            CALL   I2ASC              ; F|rbrukat minne.
            LD     DE,(Y.Botm)
            LD     HL,(Y.Top)
            XOR    A                  ; Nolla carry osv.
            SBC    HL,DE              ; Ber{kna kvarvarande minnesutrymme.
            EX     DE,HL
            LD     HL,Itext5n
            CALL   I2ASC
            LD     HL,Itext3
            LD     BC,Itext6 - Itext3
            CALL   Write              ; "Det tar ...., det finns .... kvar."

Pr.Help?:   LD     A,(Option)
            AND    Opt.Err + Opt.Help
            JR     Z,Pr.Ret
Pr.Help:    LD     HL,Itext6          ; Hj{lptext.
            LD     BC,ItextEnd - Itext6
            CALL   Write
            LD     A,(Option)
            AND    Opt.Err
            JR     Z,Pr.Ret
            RST    Rst.Err
            DEFB   221                ; Error 221 - Otill}tet tecken.

Pr.Ret:     POP    BC
            POP    DE
            POP    HL
            EXX
            RET                       ; Initieringen klar. (Puh!)

Write:      LD     A,IO.Print         ; Utskrift p} aktuell "IX-map".
            JP     IO

Itext1:     DEFM  "DOTOPT finns redan."
            DEFB  10,13
Itext2:     DEFM  "DOTOPT Ver 2.01, Av Kristoffer Eriksson 1986."
            DEFB  10,13
Itext3:     DEFM  "Det tar "
Itext4n:    DEFM  "    bytes.   Du har "
Itext5n:    DEFM  "      bytes kvar."
            DEFB  10,13
Itext6:     DEFB  10,13
            DEFM  "Syntax: RUN DOTOPT(,(-)(optioner)(;n{staprogram))"
            DEFB  10,13
            DEFM "Optioner: D - Dubbel teckenbredd    E - Of|r{ndrad bredd"
            DEFB  10,13
;           DEFM "          G - Gamla BASIC-koder     N - Normala BASIC-koder"
;           DEFB  10,13
            DEFM '          T - "Tyst" inladdning'
            DEFB  10,13
            DEFM "          ?, H - Hj{lp              "
            DEFM  "! - Ladda {ven om det redan finns"
            DEFB  10,13
ItextEnd:

;*  Testa om tecknet i A avslutar optionsstr{ngen i kommandot.
;*  G|r i s} fall Z-flaggan sann.
;*
ParDelim:   CP     ";"
            RET    Z
            CP     ","
            RET    Z
            CP     13
            RET

;*  L{ser av de patchbara parametrarna, och l{gger resultatet i Option.
;*
HardPar:;   LD     A,(HPar.Old)
        ;   CP     "J"
            LD     D,Opt.Old
        ;   JR     Z,HP.X1
        ;   LD     D,Opt.New
HP.X1:      LD     A,(HPar.Pr)
            CP     "J"
            JR     Z,HP.X2
            LD     A,Opt.NoPr
            OR     D
            LD     D,A
HP.X2:      LD     A,(HPar.DWid)
            CP     "J"
            LD     A,Opt.DWid
            JR     Z,HP.X3
            LD     A,Opt.EWid
HP.X3:      OR     D
            LD     (Option),A
            RET

Option:     DEFB   0

;           DEFB   255
;           DEFM   "PARM:Samma BASIC-koder som i ver 1?"
;           DEFB   0,4,"J","N",1      ; Typ=4 (Teckenval), J/N, L{ngd=1.
;HPar.Old:  DEFB   "N"                ; Default.
            DEFB   255
            DEFM   "PARM:V{xling till 40 tecken/rad vid inladdning?"
            DEFB   0,4,"J","N",1      ; Typ=4 (Teckenval), J/N, L{ngd=1
HPar.DWid:  DEFB   "N"
            DEFB   255
            DEFM   "PARM:Meddelande vid inladdning?"
            DEFB   0,4,"J","N",1      ; Typ=4 (Teckenval), J/N, L{ngd=1
HPar.Pr:    DEFB   "J"

;*  Letar upp exekveringsadresserna f|r de normala SET DOT och CLR DOT, och
;*  returnerar adressen till i HL deras plats i exekveringstabellen, eller
;*  carry.
;*
;*  Egentligen borde man leta upp XSTM-rutinen f|rst (via RUN och den f|rsta
;*  exekveringstabellen), och d{rifr}n f} adressen till den r{tta
;*  exekveringstabellen, men eftersom alla tabellerna ligger efter varandra,
;*  och det annars skulle bli s} komplicerat, g}r jag direkt p}.
;*
BuiltInI:   LD     DE,5            ; Tabellen f|r "osynliga" funktioner.
            LD     BC,246          ; Pekar p} adresserna f|r SETDOT och
            JR     BuiltIn         ; CLRDOT i den normala exekveringstabellen.

;*  Letar upp exekveringsadresserna f|r den normala DOT(), och returnerar
;*  i HL adressen till dess plats i exekveringstabellen, eller carry.
;*
BuiltInF:   LD     DE,36           ; Funktionstabellen.
            LD     BC,2*53         ; DOT().

;*  Plockar en tabelladress ur EVALU-rutinen (start+DE), och en pekare in i
;*  tabellen + BC konstrueras samt tabellposten kontrolleras.
;*
BuiltIn:    LD     HL,(Evalu+1)
            ADD    HL,DE
            LD     A,(HL)
            CP     33                 ; 33 = "LD HL,..."
            SCF
            RET NZ
            INC    HL
            LD     A,(HL)
            INC    HL
            LD     H,(HL)             ; Tabellens startadress.
            LD     L,A
            ADD    HL,BC              ; Tabellpost.
            INC    HL
            LD     A,(HL)             ; Kolla h|g-byten.
            DEC    HL
            AND    A
            SCF
            RET Z                     ; Exekveringsadr < 256 (ofta 54=NOTYET)
            AND    A                  ; No carry.
            RET

            REL PUSH Init
            REL CALL
            ORG Init
;---------------------------------------------------------------------------
