1 REM Ins{nd av Kristoffer Eriksson <5357>    1987-12-11 19.37.54 (KERMIT)
; Fil: DEFEXT.ASM
; Av:  Kristoffer Eriksson, "SKE" <5357>.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
; 1.00 / 87-08-20 / SKE  / DEFEXT.ASM
; 1.01 / 87-11-13 / SKE  / DefDev
;

            EXTERN ENamBuf, DefExt, NewExt, DefDev

;*  L{gg till default filnamnsextension om s}dan saknas. Filnamnet kopieras
;*  till en privat buffert och extensionen l{ggs till p} slutet om filnamnet
;*  inte inneh}ller n}gon punkt. Filnamnet {r i textform. Om filnamnet inte
;*  rymms i bufferten med tillagd extension, g|rs ingen kopiering, utan
;*  rutinen returnerar anropsparametrarna. Extensionsstr{ngen ska inledas
;*  med en byte som anger dess l{ngd, inklusive punkten. Denna l{ngd f}r inte 
;*  vara noll. 
;* 
;*  In: HL = Pekare till filnamnet.
;*      BC = Filnamnets l{ngd.
;*      DE = Pekare till default extension, inledd med en byte l{ngdangivelse.
;*  Ut: HL = Pekare till filnamn med ev tillagd extension.
;*      BC = Filnamnets nya l{ngd.

BufLen:     =      16
ENamBuf:    DEFS   BufLen             ; Buffert f|r filnamn+default extension

DefExt:     INC    B
            DEC    B
            RET NZ
            LD     A,(DE)
            NEG
            ADD    BufLen
            RET NC                    ; Avbryt om inte extension rymms i buf.
            CP     C
            RET C                     ; Avbryt om inte filnamn rymms i resten.
            PUSH   HL
            PUSH   BC
            PUSH   DE
            LD     DE,ENamBuf 
            INC    C 
            DEC    C 
            JR Z   DE.Ext             ; Kopiera inte om filnamnet {r tomt. 
            LD     A,"."
DE.Loop:    CP     (HL)
            JR Z   DE.Dot             ; Kopiera till bufferten, tills antingen
            LDI                       ; filnamnet {r slut, eller en punkt
            JP PE  DE.Loop            ; p}tr{ffas.
            DEC    HL
            LD     A,(HL)
            CP     ":"
            JR Z   DE.Dot             ; Avbryt {ven n{r sista tkn {r kolon.
DE.Ext:     POP    HL                 ; HL <- Default extension. 
            LD     C,(HL)             ; C <- Extensionens l{ngd.
            LD     A,C
            INC    HL
            LDIR                      ; Kopiera in extensionen.
            POP    BC
            POP    HL
            ADD    C                  ; Ber{kna ny l{ngd.
            LD     C,A
            LD     HL,ENamBuf         ; Returnera pekare till nytt filnamn.
            RET

NE.Full:
DE.Dot:     POP    DE                 ; Punkt p}tr{ffades, eller sista
            POP    BC                 ; tecknet var kolon: Ge upp.
            POP    HL
            RET

;*  Byt till ny filnamnsextension, oavsett om filnamnet redan har n}gon
;*  extension, men f|rutsatt att det rymms i den privata bufferten.
;*  I |vrigt som DefExt.

NewExt:     PUSH   HL
            PUSH   BC
            PUSH   DE
            LD     DE,ENamBuf
            LD     A,BufLen-3         ;Det 13:e tkn {r sista som f}r vara ".".
            EX     AF,AF' 
            INC    C 
            DEC    C 
            JR Z   NE.Dot             ; Kopiera inte filnamnet om det {r tomt. 
NE.Loop:    LD     A,"."
            CP     (HL)
            JR Z   NE.Dot             ; Avbryt kopieringen vid punkt.
            EX     AF,AF'
            DEC    A
            JR Z   NE.Full            ; Kopiera till bufferten, tills antingen
            EX     AF,AF'             ; filnamnet eller bufferten {r slut.
            LDI
            JP PE  NE.Loop
NE.Dot:     POP    HL                 ; HL <- Extension.
            LD     C,(HL)             ; C <- Extensionens l{ngd.
            LD     B,0                ; Det {r inte helt s{kert att B var 0.
            PUSH   BC
            INC    HL
            LDIR                      ; Kopiera in extensionen.
            POP    BC                 ; C <- Extensionens l{ngd.
            POP    HL                 ; Gl|m originalets l{ngd.
            POP    HL
            EX     AF,AF'
            NEG                       ; Ber{kna ny l{ngd: C <- -A + 13 + C.
            ADD    BufLen-3
            ADD    C
            LD     C,A
            LD     B,0                ; Det {r inte helt s{kert att B var 0.
            LD     HL,ENamBuf         ; Returnera pekare till nytt filnamn.
            RET


;*  L{gg till default enhetsnamn om s}dant saknas. Filnamnet kopieras till
;*  en privat buffert med enhetsnamnet f|rst om filnamnet inte inneh}ller
;*  n}got kolon. Filnamnet {r i textform. Om filnamn och enhet inte rymms
;*  i bufferten, g|rs ingen kopiering, utan rutinen returnerar anrops-
;*  parametrarna. Enhetsstr{ngen inneh}ller bara namnet och avslutas av
;*  kolonet.
;*
;*  In: HL = Pekare till filnamnet.
;*      BC = Filnamnets l{ngd.
;*      DE = Pekare till default enhetsnamn avslutat med kolon.
;*  Ut: HL = Pekare till filnamn med ev tillagt enhetsnamn.
;*      BC = Filnamnets nya l{ngd.

DefDev:     INC    B                  ; [r BC>255 finns ingen chans att
            DEC    B                  ; rymmas i bufferten.
            RET    NZ
            INC    C                  ; [r BC=0, s} g|r inget.
            DEC    C
            RET    Z
            PUSH   HL
            PUSH   BC
            LD     A,":"              ; S|k eventuellt kolon i filnamnet.
            CPIR
            JR Z   DD.Ret             ; Finns kolon, s} returnera direkt.
            LD     L,E
            LD     H,D
            LD     C,BufLen           ; (B {r noll).
            CPIR                      ; S|k slutet av enhetsnamnet (kolon).
            LD     A,C                ; A <- Buflen - Len(Enhetsnamn).
            JR NZ  DD.Ret             ; Finns ej kolon inom vad som rymms
            POP    BC                 ; i bufferten, s} {r det ingen id`.
            PUSH   BC
            CP     C
            JR C   DD.Ret             ; Avbryt om inte filnamn rymms i resten.
            NEG
            ADD    BufLen             ; A <- Enhetens l{ngd.
            EX     DE,HL              ; HL <- Enhetsnamn.
            LD     C,A                ; Enhetens l{ngd. B {r redan noll.
            LD     DE,ENamBuf
            LDIR                      ; Kopiera enhetsnamnet till bufferten.
            POP    BC
            POP    HL
            PUSH   BC
            LDIR                      ; Kopiera ursprungliga filnamnet.
            POP    BC
            ADD    C
            LD     C,A                ; Ny l{ngd.
            LD     HL,ENamBuf         ; Ny adress.
            RET

DD.Ret:     POP    BC                 ; Returnera med inparametrarna.
            POP    HL
            RET
