1 REM Ins{nd av Kristoffer Eriksson SYSOP <5357>    1986-09-28 05.08.16 (DUMP)
; Fil: CD.ASM
; Av:  Kristoffer Eriksson, "SKE" <5357>, 1986.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
; 1.00 / 86-08-12 / SKE  / CD
; 1.01 / 86-08-20 / SKE  / Skriver CR LF efter startmeddelandet.
; 1.20 / 86-08-24 / SKE  / FILESTAT, optioner, olika modeller, CD "..".
;
; L{nkar in instruktionen CD, med vilken man l{tt kan byta UFD, och FILESTAT
; s} man l{ttare kan hantera LUX-NET-program.
; LUX-NET-kompatibelt.
; Endast f|r vanligt stand-alone UFD-DOS. Ej ABC/CAT/LUX-NET.
;
; Ing}ende moduler:
;   A. L{nk till instruktionslistan.
;   B. Initieringsrutiner som fixar A., och best{mmer hur f|ljande moduler
;      ska laddas.
;   C. Exekveringsrutin f|r FILESTAT.
;   D. Kompileringsrutin f|r FILESTAT.
;   E. Exekveringsrutin f|r CD n{r CD inte anv{nds.
;   F. Fullst{ndig exekveringsrutin f|r CD (CDK.ASM).
;   G. Ytterligare rutin till CD f|r att tolka namnet "..".
;
; Observera att B:s funktion {r avh{ngig ordningen mellan de |vriga rutinerna,
; och i viss m}n den interna ordningen i A. Modul F och G ligger i CDK.ASM.
;
; Programmet utnyttjar CDK.ASM, CLINEPAR.ASM, ENDINIT.ASM, I2ASC.ASM, och
; indirekt FINDDEV.ASM vilka inneh}ller de externa rutinerna Exek.CD,
; Clinepar, Chain.Clr, Chain.Load, I2ASC samt FindDev.

Rst.Err:    =     16
SkipSp:     =     24
StrComp:    =     27
TypComp:    =     29
Evalu:      =     32
StmTba:     =     65405

;*  Prototyp-l{nk till instruktionslistan. Eftersom det ibland {r en och
;*  ibland tv} instruktioner m}ste delarna flyttas om lite hit och dit...
;*
PtrSav.BT:  DEFW  0                   ; Gamla pekare: Y.BOTM
PtrSav.ST:                            ;               STMTBA (ing}r i l{nken)
StmTba.L{nk:DEFW  0                   ; Utrymme f|r gammal STMTBA
            DEFB  164                 ; Kod-offset (samma som i LUXNET-dos)
StmTba.Ant: DEFB  2                   ; 1 eller 2 instruktioner.
StmTba.Exek:DEFW  ExekTba
StmTba.Text:DEFW  TextTba
            DEFW  CmplTba

CmplTba:    DEFW  StrComp            ; CD $
CmplT.FS:   DEFW  Cmpl.FS

ExekTba:
ExekT.CD:   DEFW  Exek.CD
ExekT.FS:   DEFW  Exek.FS

TextTba:    DEFB  80H
            DEFM  "CD"
Text.FS1:   DEFB  81H
            DEFM  "FILESTAT"
Text.FS2:   DEFB  81H
            DEFM  "FS"
            DEFB  0FFH
Text.End:

ExekTba.1:  =     CmplTba + 2         ; Alternativa adresser med bara en
TextTba.1:  =     ExekTba.1 + 2       ;   instruktion (CD) i tabellerna.

;_ Initiering                             _
ChkLU:      =     43
HLbuf1:     =     81
IO:         =     90
IO.Print:   =     4
DR.0:       =     24678
DosType:    =     24688
Y.Botm:     =     65292               ; Botten av BASIC-minnet
Y.Top:      =     65294               ; Minnestak.
Y.Comtop:   =     65328               ; Toppen av COMMON-variablerna

Opt.CD:     =     1                   ; Option f|r att ladda CD,
Opt.CDF:    =     2                   ; ladda CD f|r fader-bibliotek,
Opt.FSE:    =     4                   ; exekvering av FILESTAT,
Opt.FSC:    =     8                   ; kompilering av FILESTAT,
Opt.Err:    =     16                  ; syntaxfel i kommandorad,
Opt.Help:   =     32                  ; hj{lptext |nksas,
Opt.Nld:    =     64                  ; ladda inget (inte ens CD),
Opt.Nch:    =     128                 ; kontrollera ej dubbelladdning.
Opt.Std:    =     Opt.CD              ; Default-option.

Init:       CALL  Chain.Clr
            CALL  HardPar
            CALL  Clinepar            ; C = L{ngd, A = F|rsta tecken, Carry
            JR    C,MakeL{nk
            CALL  ParDelim            ; Om optionsstr{ngen {r tom, kommer
            JR    Z,Par.Chain         ;   patch-parametrarna att g{lla.

            ; Loop f|r att unders|ka optioner angivna p} kommandoraden.
            LD    D,Opt.Std           ; D f}r ackumulera optionsbittarna.
ParLoop:    LD    E,Opt.Nch
            CP    '!'                 ; ! - F|rhindra inte dubbelladdning.
            JR    Z,Par.OR
            LD    E,0
            CP    '-'                 ; - - Dummy.
            JR    Z,Par.OR
            CP    '?'                 ; ? - Hj{lp.
            JR    Z,Par.Help
            CP    'A'                 ; F|rkasta nu andra tecken {n bokst{ver.
            JR    C,Par.Err
            CP    '`'
            JR    C,Par.X1
            SUB   'a'-'A'             ; Konvertera gemener till versaler.
Par.X1:     CP    'N'                 ; N - Ladda ej CD.
            JR    NZ,Par.X2
            LD    A,!(Opt.CD + Opt.CDF)
            AND   D
            JR    Par.Next
Par.X2:     CP    'H'                 ; H - Hj{lp (enbart hj{lp om inga andra
            JR    NZ,Par.X3           ;            optioner anges efter H).
Par.Help:   LD    A,Opt.Help + Opt.Nld
            JR    Par.Next
Par.X3:     LD    E,Opt.CD
            CP    'C'                 ; C - Ladda CD.
            JR    Z,Par.OR
            LD    E,Opt.Std
            CP    'D'                 ; D - Default.
            JR    Z,Par.OR
            LD    E,Opt.FSE
            CP    'E'                 ; E - Ladda FILESTAT-exekvering.
            JR    Z,Par.OR
            LD    E,Opt.FSC
            CP    'F'                 ; F - Ladda FILESTAT-kompilering.
            JR    Z,Par.OR
            LD    E,Opt.CD + Opt.CDF
            CP    'L'                 ; L - Ladda "Lyx-CD" (Fader-bibl.).
            JR    Z,Par.OR
Par.Err:    LD    A,Opt.Err + Opt.Help
            JR    Par.Next

Par.OR:     LD    A,E
            OR    D
            AND   !Opt.Nld            ; Ta bort denna bit som kom fr}n H.
Par.Next:   LD    D,A
            RST   SkipSp              ; L{s n{sta oblanka tecken p} raden.
            CALL  ParDelim
            JR    NZ,ParLoop
Par.Finish: LD    A,D
            LD    (Option),A
Par.Chain:  CALL  Chain.Load          ; Ta hand om chain-fil sist p} raden.

; H{r {r det dags att konstruera den instruktionslistel{nk som ska anv{ndas.
MakeL{nk:   LD    A,(Option)          ; Det kan antingen vara CD ensamt, eller
            AND   Opt.FSC + Opt.FSE   ;   b}de CD och FILESTAT.
            JR    NZ,Ld.B}da
                                      ; Enbart CD.
            LD    A,1
            LD    (StmTba.Ant),A      ; Antal instruktioner i denna l{nk.
            LD    HL,ExekTba.1        ; [ndra pekarna till exekverings och
            LD    (StmTba.Exek),HL    ;   text-tabelen, n{r det bara {r en
            LD    DE,TextTba.1        ;   instruktion.
            LD    (StmTba.Text),DE
            LD    HL,Text.CD
            LD    BC,Text.CD.Len      ; Ers{tt texttabellen med en som enbart
            LD    (TextTLen),BC       ;   inneh}ller CD.
            LDIR
            LD    (ExekTba.1),DE      ; Adress till Exek.CD.
            LD    HL,-(Text.End - TextTba.1 - Text.CD.Len) ; S} h{r mycket
            LD    (Just1),HL          ; kortare blir instruktionslistans l{nk.
            LD    L,E
            LD    H,D                 ; HL <- N{sta lediga adress.
            JR    Ld.Cd2

Ld.B}da:    AND   Opt.FSC             ; B}de CD o FILESTAT i textlistan.
            LD    DE,Text.End
            JR    NZ,Ld.BX1
            LD    DE,Text.FS1
            LD    HL,Text.FS2            ; L}t den korta varianten av FILESTAT
            LD    BC,Text.End - Text.FS2 ;   ers{tta den l}nga, n{r bara
            LDIR                         ;   exekveringsrutinen anv{nds.
            LD    HL,-(Text.FS2 - Text.FS1); S} h{r mycket kortare blir text-
            LD    (Just1),HL             ;   listan d}.
            LD    HL,Text.End - TextTba - (Text.FS2 - Text.FS1)
            LD    (TextTLen),HL          ; Och just s} h{r l}ng blir den.
Ld.BX1:     LD    (ExekT.FS),DE
            LD    HL,FS.Exek.Len      ; R{kna fram f|rsta adress efter Exek.FS
            ADD   HL,DE
            AND   A                   ; Upprepa testet av Opt.FSC.
            JR    NZ,Ld.BCmpl
            PUSH  HL
            LD    HL,0
            LD    BC,30720
            LD    A,201               ; Leta reda p} en RET-instruktion i
            CPIR                      ;   prommet.
            DEC   HL
            LD    (CmplT.FS),HL       ; L}t FILESTAT kompileras av RET om
            POP   HL                  ;   kompileringsrutinen inte anv{nds.
            LD    BC,-FS.Cmpl.Len     ; D} m}ste {ven en laddadress juseras.
            LD    (Just2),BC
            JR    Ld.Cd
Ld.BCmpl:   LD    (CmplT.FS),HL
            LD    BC,FS.Cmpl.Len      ; R{kna fram f|rsta adress efter Cmpl.FS
            ADD   HL,BC
            LD    BC,0                ; Ingen adressjustering - b}da FILESTAT-
            LD    (Just2),BC          ;   rutinerna ska anv{ndas.
Ld.Cd:      LD    (ExekT.CD),HL
Ld.Cd2:     LD    A,(Option)
            AND   Opt.CD + Opt.CDF
            CP    Opt.CD + Opt.CDF
            LD    BC,CD.Exek.Len + DotDot.Len
            JR    Z,Ld.BX3
            AND   Opt.CD
            LD    BC,CD.Exek.Len
            JR    NZ,Ld.BX2
            LD    BC,CD0.Exek.Len     ; R{kna med att anv{nda NOP-varianten av
            LD    DE,0                ;  CD. D} ska laddadressen inte justeras
            LD    (Just3),DE
Ld.BX2:     XOR   A
            LD    (JustDot),A
Ld.BX3:     ADD   HL,BC               ; F|rsta adress efter r{tt Exek.CD.

Ld.Finish:  LD    (MaxAdress),HL      ; Spara f|rsta oanv{nda adress.
            POP   BC                  ; Plocka tillf{lligt upp returadressen
            LD    A,(JustDot)         ;  till relokeringsrutinen, s} vi kommer
            PUSH  AF                  ;  }t stacken, f|r att d{r placera data
            LD    HL,(Just3)          ;  till adressjusteringssnuttarna mellan
            PUSH  HL                  ;  modulerna.
            PUSH  HL
            LD    HL,(Just2)
            PUSH  HL
            PUSH  HL
            LD    HL,(Just1)
            PUSH  HL
            PUSH  HL
            PUSH  BC

            ; Ska n}gon inl{nkning alls g|ras den h{r g}ngen?
            LD    A,(Option)
            LD    C,A
            AND   Opt.Nld + Opt.Err
            JP    NZ,Meddelande
            LD    A,C
            AND   Opt.Nch
            JR    NZ,L{nkain         ; Option f|r att slippa f|ljande kollar.

            ; Kontrollera att DOS:et {r l{mpligt.
            LD    A,(DR.0)
            CP    195
            JR    NZ,J{mf             ; Urgammalt DOS.
            LD    A,(DosType)
            AND   254
            CP    8                   ; Avbryt om LUX-NET-DOS. D{r finns redan
            SCF                       ; instruktionen CD.
            JR    Z,Meddelande

            ; Kontrollera att det inte redan finns laddat en instruktions-
            ; tabell med exakt samma instruktioner.
J{mf:       LD    IX,Stmtba
J{mf.L1:    LD    L,(IX+0)
            LD    H,(IX+1)
            LD    A,H
            OR    L                  ; (Carry <- 0)
            JR Z  L{nkain            ; Inga fler l{nkar, och ingen lik v}ran.
            PUSH  HL
            POP   IX
            LD    L,(IX+6)           ; TextTba
            LD    H,(IX+7)
            LD    DE,(StmTba.Text)
            LD    BC,(TextTLen)
J{mf.L2:    LD    A,(DE)
            INC   DE
            CPI
            SCF
            JP PO Meddelande         ; Hela text-tabellen finns redan.
            JR Z  J{mf.L2            ; Ett tecken lika, j{mf|r n{sta.
            JR    J{mf.L1            ; Texten i l{nken ej lik. J{mf|r n{sta.

            ; Nu kan vi tryggt {ndra systempekare och l{nka in listan.
L{nkain:    LD    HL,(StmTba)
            LD    (StmTba.L{nk),HL
            LD    HL,StmTba.L{nk
            LD    (StmTba),HL

            LD    HL,(Y.Botm)
            LD    (Ptrsav.Bt),HL
            LD    HL,(MaxAdress)      ; Skydda det minne programmet tar upp.
            LD    (Y.Botm),HL
            LD    (Y.Comtop),HL

            ;*  Meddela hur inladdningen gick (eller snarare g}r).
            ;*  Om options-byten anger fel eller ingen laddning, g}r rutinen
            ;*  direkt till utskriften av hj{lptexten.
            ;*  Annars, om Carry-flaggan {r sann skrivs "Finns redan" ut,
            ;*  annars blir det ett positivt meddelande.
Meddelande: EXX
            PUSH  HL                  ; Skydda relokeringsv{rdena.
            PUSH  DE
            PUSH  BC
            PUSH  AF               ;--,
            XOR   A                ;  ! Hitta LU-blocket f|r fil nr 0. Det {r
            CALL  ChkLU            ;  !   d{r utskrifterna ska g|ras.
            JP    C,Pr.Ret         ;  !
            LD    A,(Option)       ;  !
            AND   Opt.Err + Opt.Nld;  !
            JR    NZ,Pr.Help       ;  !
            LD    A,(Option)       ;  !
            PUSH  AF              ;--,!
            AND   A                ; !!
            JR    Z,Pr.X1          ; !!  Skriv "CD" dels om hela CD laddas,
            AND   Opt.CD           ; !!    och dels om endast lilla CD laddas.
            JR    Z,Pr.X2          ; !!
Pr.X1:      LD    HL,Itext2        ; !!
            LD    BC,Itext3 - Itext2;!!
            CALL  Write            ; !!  "CD"
            POP   AF              ;--'!
            PUSH  AF              ;--,!
            AND   Opt.FSC + Opt.FSE; !!
            LD    HL,Itext3        ; !!
            LD    BC,Itext4 - Itext3;!!
            CALL  NZ,Write         ; !!  "+"
Pr.X2:      POP   AF              ;--'!
            AND   Opt.FSC + Opt.FSE ; !
            LD    HL,Itext4         ; !
            LD    BC,Itext5 - Itext4; !
            CALL  NZ,Write          ; !  "FILESTAT"
            POP   AF              ;---'
            JR    NC,Pr.Ver
            LD    HL,Itext1
            LD    BC,Itext2 - Itext1
            CALL  Write               ; "finns redan." (Sann Carry)
            JR    Pr.Help?

Pr.Ver:     LD    HL,Itext5
            LD    BC,Itext6 - Itext5
            CALL  Write               ; "Ver ..."
            LD    DE,(PtrSav.Bt)
            LD    HL,(MaxAdress)
            XOR   A                   ; Nolla carry, och signalera undertryck-
            SBC   HL,DE               ;   ning av inledande nollor i I2ASC.
            EX    DE,HL
            LD    HL,Itext7n
            CALL  I2ASC               ; F|rbrukat minne.
            LD    DE,(MaxAdress)
            LD    HL,(Y.Top)
            XOR   A                   ; Nolla carry osv.
            SBC   HL,DE               ; Ber{kna kvarvarande minnesutrymme.
            EX    DE,HL
            LD    HL,Itext8n
            CALL  I2ASC
            LD    HL,Itext6
            LD    BC,Itext9 - Itext6
            CALL  Write               ; "Det tar ...., det finns .... kvar."

Pr.Help?:   LD    A,(Option)
            AND   Opt.Err + Opt.Help
            JR    Z,Pr.Ret
            PUSH  AF                  ; PUSH-POP f|r att komma p} samma stack-
Pr.Help:    POP   AF                  ;   niv} som inhoppet hit.
            LD    HL,Itext9           ; Hj{lptext.
            LD    BC,ItextEnd - Itext9
            CALL  Write
            LD    A,(Option)
            AND   Opt.Err
            JR    Z,Pr.Ret
            RST   Rst.Err
            DEFB  221                 ; Error 221 - Otill}tet tecken.

Pr.Ret:     POP   BC
            POP   DE
            POP   HL
            EXX
            RET                       ; Initieringen klar. (Puh!)

Write:      LD    A,IO.Print          ; Utskrift p} aktuell "IX-map".
            JP    IO

Itext1:     DEFM  "finns redan."
            DEFB  10,13
Itext2:     DEFM  "CD "
Itext3:     DEFM  "+ "
Itext4:     DEFM  "FILESTAT "
Itext5:     DEFM  "Ver 1.20, Av Kristoffer Eriksson 1986."
            DEFB  10,13
Itext6:     DEFM  "Det tar "
Itext7n:    DEFM  "    bytes. Du har "
Itext8n:    DEFM  "      bytes kvar."
            DEFB  10,13
Itext9:     DEFM  "CD/FILESTAT Ver 1.20. "
            DEFM  "Syntax: RUN CD(,(-)(optioner)(;n{staprogram))"
            DEFB  10,13
            DEFM  "Optioner: E - Exekverbar FILESTAT   N - Ingen CD alls"
            DEFB  10,13
            DEFM  '          F - Fullst{ndig FILESTAT  L - "Lyx"-CD'
            DEFB  10,13
            DEFM  "    -, C, D - Standard CD        ?, H - Hj{lp"
            DEFB  10,13
            DEFM  "          ! - Ladda {ven om det redan finns"
            DEFB  10,13
ItextEnd:

Text.CD:    DEFB  80H                 ; Texttabell med enbart CD.
            DEFM  "CD"
            DEFB  0FFH
Text.CD.Len:=     * - Text.CD

;*  Testa om tecknet i A avslutar optionsstr{ngen i kommandot.
;*  G|r i s} fall Z-flaggan sann.
;*
ParDelim:   CP    ";"
            RET   Z
            CP    ","
            RET   Z
            CP    13
            RET

;*  L{ser av de patchbara parametrarna, och l{gger resultatet i Option.
;*
HardPar:    LD    D,0
            LD    A,(HPar.CD)
            CP    0
            JR    Z,HP.X1
            LD    D,Opt.CD
            CP    1
            JR    Z,HP.X1
            LD    D,Opt.CD + Opt.CDF
HP.X1:      LD    A,(HPar.FSC)
            CP    "J"
            JR    NZ,HP.X2
            LD    A,Opt.FSC
            OR    D
            LD    D,A
HP.X2:      LD    A,(HPar.FSE)
            CP    "J"
            LD    A,D
            JR    NZ,HP.X3
            OR    Opt.FSE
HP.X3:      LD    (Option),A
            RET

            INCLUDE CLINEPAR          ; Hitta kommandoraden.
            INCLUDE ENDINIT           ; Initiering av filnamn }t ENDREL.
            INCLUDE I2ASC             ; Omvandla heltal i DE till ASCII vid HL

Just1:      DEFW  0                   ; Justering av laddadresser. H{r n}got
Just2:      DEFW  -(FS.Exek.Len+FS.Cmpl.Len) ; blandat f{rdigt f|r fullst{ndig
Just3:      DEFW  -CD0.Exek.Len       ; modul A, men enbart exekvering av CD.
JustDot:    DEFB  1                   ; Flagga f|r att l{nka in DotDot (Opt L)
MaxAdress:  DEFW  0                   ; H|gsta adress att reservera.
TextTLen:   DEFW  Text.End - TextTba
Option:     DEFB  Opt.Std

            DEFB  255
            DEFM  "PARM:Ladda CD (0=Nej, 1=Standard, 2=Stora)?"
            DEFB  0,2,0,2,1           ; Typ=2 (Bytetal), 0-2, L{ngd=1
HPar.CD:    DEFB  1                   ; Default: Ladda standard CD.
            DEFB  255
            DEFM  "PARM:Ladda endast exekveringsdelen av FILESTAT?"
            DEFB  0,4,"J","N",1       ; Typ=4 (Teckenval), J/N, L{ngd=1
HPar.FSE:   DEFB  "N"
            DEFB  255
            DEFM  "PARM:Ladda hela FILESTAT?"
            DEFB  0,4,"J","N",1       ; Typ=4 (Teckenval), J/N, L{ngd=1
HPar.FSC:   DEFB  "N"

            REL PUSH Init
            REL CALL
            ORG Init

            REL   PUSH BASE           ; Justera laddadressen efter storleken
            REL   ADD                 ;   p} instruktionslistel{nken.
            REL   POP BASE            ;   Justering 1.
            REL   PUSH PC
            REL   ADD
            REL   POP PC

;*  Exekveringsrutin f|r FILESTAT.
;*  Utr{ttar i praktiken inget annat {n att {ven exekvera parametrarna.
;*
Exek.FS:    LD    A,(DE)
            CP    "#"                 ; Direkt }terhopp om varianten utan
            RET   NZ                  ;   parametrar anv{nds.
            INC   DE
            RST   Evalu               ; Exekvera f|rsta parametern.
            INC   DE                  ; Kommatecknet.
            RST   Evalu               ; Andra parametern.
            RET
FS.Exek.Len:=     * - Exek.FS

;*  Kompileringsrutin f|r FILESTAT.
;*  (CD kompileras direkt av StrComp.)
;*
Cmpl.FS:    LD    A,(HL)              ; Tv} syntaxer: #%,% eller tom.
            XOR   "#"                 ; (XOR nollst{ller carry)
            RET   NZ
            CALL  Cmpl.CI             ; F|rsta heltalet (filnummer).
            RET   C
            LD    A,(HL)
            CP    ","                 ; Kommatecken.
            LD    A,227               ; Ev. Error 227 - "," saknas.
            SCF
            RET   NZ
Cmpl.CI:    LDI
            DEC   HL
            Rst   SkipSp
            LD    B,1                 ; Andra heltalet.
            JP    TypComp
FS.Cmpl.Len:=     * - Cmpl.FS

            REL   PUSH BASE           ; Justera f|r uteslutning av Cmpl.FS,
            REL   ADD                 ;   eller b}de Cmpl.FS och Exek.FS.
            REL   POP BASE            ;   Justering 2.
            REL   PUSH PC
            REL   ADD
            REL   POP PC

;*  Exekveringsrutin f|r CD n{r CD inte anv{nds.
;*  G|r inge annat {n exekverar parametern.
;*
Exek.CD0:   RST   Evalu               ; $
            POP   HL                  ; Slaskutrymme p} stacken,
            POP   BC                  ; Textpekare,
            POP   BC                  ; Textl{ngd.
            ADD   HL,SP               ; Returposition f|r stacken.
            LD    SP,HL
            RET
CD0.Exek.Len:=    * - Exek.CD0

            REL   PUSH BASE           ; Justera f|r uteslutning av Cmpl.FS,
            REL   ADD                 ;   eller b}de Cmpl.FS och Exek.FS.
            REL   POP BASE            ;   Justering 3.
            REL   PUSH PC
            REL   ADD
            REL   POP PC

;*  Exekveringsrutin f|r CD n{r fullst{ndig CD anv{nds, i tv} varianter,
;*  med och utan rutin f|r byte till faderbibliotek. Valet mellan dessa g|rs
;*  av en parameter som ligger p} relokeringsstacken.
;*  Det {r viktigt att CD.Exek ligger p} modulens f|rsta adress.
;*
            INCLUDE CDK               ; CD.Exek, CD.Exek.Len och DotDot.Len
            ; H{r beh|vs ingen laddningsadressjustering, eftersom inget som
            ; ska ligga kvar f|ljer. Det viktiga h{r {r den nya Y.Botm.

;*  Den vanliga CHAIN-avslutningen...
;*
            INCLUDE ENDREL
