1 REM Ins{nd av Kristoffer Eriksson <5357>    1987-12-11 19.34.18 (KERMIT)
; Fil: BITIO.ASM
; Av:  Kristoffer Eriksson, "SKE" <5357>.
;
;-Ver--/-Datum----/-Sign-/-Kommentar----------------------------------
;      / 87-08-24 / SKE  / BITIO p}b|rjad.
; 1.00 / 87-10-31 / SKE  / Klart. 
; 
; Bitt-vis sekvensiell in- och utmatning till fil. 
; 
; Anropar BDoIO f|r filhanteringen. DE och HL bevaras. BC f|rst|rs. \vriga 
; register kan p}verkas om filhanteringsrutinerna anv{nder dem. 
; IX ska ange LU-block. Carry i retur fr}n BitOut, BitFlush eller BitIn 
; signalerar fel fr}n BDoIO. 
; 
; StartBitOut/In m}ste anropas innan BitOut/In kan anv{ndas p} en ny fil. 
; Bara en fil i taget kan behandlas, eftersom bara en bytebuffert finns. 
; BitFlush anv{nds n{r bitutmatningen avslutas, s} sista byten skrivs ut, 
; eller f|r att stega fram till n{rmaste bytegr{ns. Efter BitFlush {r BitOut 
; redo att forts{tta utmatningen p} samma eller en ny fil. 
; 
; L{sning och skrivning av hela bytes g|rs med anrop till BDoIO, som 
; normalt s{tts lika med GIO fr}n GIO.ASM eller liknande i den omgivande 
; k{llkodsfilen. Via $BDoOut+1 och $BDoIn+1 kan man i st{llet l{gga dit 
; anrop till speciella rutiner som t ex r{knar antal bytes eller vad som 
; hellst.
; 
; - Kanske det vore effektivare att skifta fram bittar {n att maska och 
;   OR:a ?


            EXTERN StartBitOut, BitOut, BitFlush, StartBitIn, BitIn 
            EXTERN $BDoOut, $BDoIn 

Iocm.Rdc:   =  5
Iocm.Wrc:   =  6 

OutByte:    DEFB   0                  ; Buffert f|r byte-omvandling.
OutBit:     DEFB   128                ; N{sta bitmask f|r bufferten.

BitFlush:   LD     A,(OutBit)         ; Mata ut Byte-bufferten om den
            XOR    128                ; inneh}ller n}got (OutBit<>128).
            CALL   NZ,DoFlush
StartBitOut:LD     BC,128 << 8 + 0    ; Nollst{ll buffert och pekare.
            LD     (OutByte),BC       ; OutByte <- 0, OutBit <- 128.
            RET

; Skriv bit. 0 om A=0, 1 om A<>0.
; Vid retur signalerar carry fel fr}n BDoIO, med felkod i A.

BitOut:     LD     BC,(OutByte)       ; C <- OutByte, B <- OutBit.
            AND    A
            JR Z   O.x1
            LD     A,C                ; S{tt bitt.
            OR     B
            LD     C,A
O.x1:       RRC    B                  ; Skifta mask.
            LD     (OutByte),BC
            RET NC
DoFlush:    PUSH   HL                 ; Skriv ut byten n{r den {r f{rdig.
            PUSH   DE
            LD     HL,OutByte
            LD     BC,1
            LD     A,Iocm.Wrc
$BDoOut:    CALL   BDoIO
            POP    DE
            POP    HL
            EX     AF,AF'
            XOR    A
            LD     (OutByte),A
            EX     AF,AF' 
            RET


InByte:     DEFB   0                  ; Buffert f|r byte-omvandling.
InBit:      DEFB   1                  ; N{sta bitmask f|r bufferten.

StartBitIn: LD     BC,1 << 8 + 0
            LD     (InByte),BC        ; InByte <- 0, InBit <- 1.
            RET


; L{s bit. 0 ger A=0, 1 ger A=255, biten avspeglas i Z-flaggan ocks}, s}vida
; inte fel fr}n BDoIO uppst}r, vilket signaleras med sann carry och felkod i 
; A.

BitIn:      LD     BC,(InByte)        ; C <- InByte, B <- InBit.
            RRC    B                  ; Skifta mask.
            LD     (InByte),BC
            JR NC  I.x1
            PUSH   HL                 ; L{s in ny byte vid behov.
            PUSH   DE
            LD     HL,InByte
            LD     BC,1
            LD     A,Iocm.Rdc
$BDoIn:     CALL   BDoIO
            POP    DE
            POP    HL
            LD     BC,(InByte)
            RET C
I.x1:       LD     A,C                ; Maska fram bitt.
            AND    B
            RET Z
            LD     A,255
            RET
